/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.data;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelHttpRequestFacet;
import de.gematik.rbellogger.data.facet.RbelHttpResponseFacet;
import de.gematik.rbellogger.data.facet.RbelRequestFacet;
import de.gematik.rbellogger.data.facet.RbelResponseFacet;
import de.gematik.rbellogger.data.facet.RbelTcpIpMessageFacet;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageMetaDataDto {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageMetaDataDto.class);
    private String uuid;
    private String path;
    private String method;
    private Integer responseCode;
    private String recipient;
    private String sender;
    private long sequenceNumber;
    private String menuInfoString;
    private long timestamp;
    private boolean isRequest;

    public static MessageMetaDataDto createFrom(RbelElement el) {
        MessageMetaDataDtoBuilder builder = MessageMetaDataDto.builder();
        builder = builder.uuid(el.getUuid()).sequenceNumber(MessageMetaDataDto.getElementSequenceNumber(el)).sender(el.getFacet(RbelTcpIpMessageFacet.class).map(RbelTcpIpMessageFacet::getSender).filter(Objects::nonNull).filter(element -> element.getRawStringContent() != null).flatMap(element -> Optional.of(element.getRawStringContent())).orElse("")).recipient(el.getFacet(RbelTcpIpMessageFacet.class).map(RbelTcpIpMessageFacet::getReceiver).filter(Objects::nonNull).filter(element -> element.getRawStringContent() != null).flatMap(element -> Optional.of(element.getRawStringContent())).orElse(""));
        if (el.hasFacet(RbelHttpRequestFacet.class)) {
            RbelHttpRequestFacet req = (RbelHttpRequestFacet)el.getFacetOrFail(RbelHttpRequestFacet.class);
            builder = builder.path(req.getPath().getRawStringContent()).method(req.getMethod().getRawStringContent()).responseCode(null);
        } else if (el.hasFacet(RbelHttpResponseFacet.class)) {
            builder.responseCode(Integer.parseInt(((RbelHttpResponseFacet)el.getFacetOrFail(RbelHttpResponseFacet.class)).getResponseCode().getRawStringContent()));
        } else {
            throw new IllegalArgumentException("We do not support meta data for non http elements (" + el.getFacets().stream().map(Object::getClass).map(Class::getSimpleName).collect(Collectors.joining(", ")) + ")");
        }
        builder.isRequest = el.hasFacet(RbelRequestFacet.class);
        builder.menuInfoString = el.getFacet(RbelRequestFacet.class).map(RbelRequestFacet::getMenuInfoString).or(() -> el.getFacet(RbelResponseFacet.class).map(RbelResponseFacet::getMenuInfoString)).orElse(null);
        return builder.build();
    }

    private static long getElementSequenceNumber(RbelElement rbelElement) {
        return rbelElement.getFacet(RbelTcpIpMessageFacet.class).map(RbelTcpIpMessageFacet::getSequenceNumber).orElse(0L);
    }

    @Generated
    public static MessageMetaDataDtoBuilder builder() {
        return new MessageMetaDataDtoBuilder();
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public String getMethod() {
        return this.method;
    }

    @Generated
    public Integer getResponseCode() {
        return this.responseCode;
    }

    @Generated
    public String getRecipient() {
        return this.recipient;
    }

    @Generated
    public String getSender() {
        return this.sender;
    }

    @Generated
    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    @Generated
    public String getMenuInfoString() {
        return this.menuInfoString;
    }

    @Generated
    public long getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public boolean isRequest() {
        return this.isRequest;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Generated
    public void setPath(String path) {
        this.path = path;
    }

    @Generated
    public void setMethod(String method) {
        this.method = method;
    }

    @Generated
    public void setResponseCode(Integer responseCode) {
        this.responseCode = responseCode;
    }

    @Generated
    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    @Generated
    public void setSender(String sender) {
        this.sender = sender;
    }

    @Generated
    public void setSequenceNumber(long sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    @Generated
    public void setMenuInfoString(String menuInfoString) {
        this.menuInfoString = menuInfoString;
    }

    @Generated
    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Generated
    public void setRequest(boolean isRequest) {
        this.isRequest = isRequest;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageMetaDataDto)) {
            return false;
        }
        MessageMetaDataDto other = (MessageMetaDataDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSequenceNumber() != other.getSequenceNumber()) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        if (this.isRequest() != other.isRequest()) {
            return false;
        }
        Integer this$responseCode = this.getResponseCode();
        Integer other$responseCode = other.getResponseCode();
        if (this$responseCode == null ? other$responseCode != null : !((Object)this$responseCode).equals(other$responseCode)) {
            return false;
        }
        String this$uuid = this.getUuid();
        String other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$recipient = this.getRecipient();
        String other$recipient = other.getRecipient();
        if (this$recipient == null ? other$recipient != null : !this$recipient.equals(other$recipient)) {
            return false;
        }
        String this$sender = this.getSender();
        String other$sender = other.getSender();
        if (this$sender == null ? other$sender != null : !this$sender.equals(other$sender)) {
            return false;
        }
        String this$menuInfoString = this.getMenuInfoString();
        String other$menuInfoString = other.getMenuInfoString();
        return !(this$menuInfoString == null ? other$menuInfoString != null : !this$menuInfoString.equals(other$menuInfoString));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MessageMetaDataDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $sequenceNumber = this.getSequenceNumber();
        result = result * 59 + (int)($sequenceNumber >>> 32 ^ $sequenceNumber);
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        result = result * 59 + (this.isRequest() ? 79 : 97);
        Integer $responseCode = this.getResponseCode();
        result = result * 59 + ($responseCode == null ? 43 : ((Object)$responseCode).hashCode());
        String $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $recipient = this.getRecipient();
        result = result * 59 + ($recipient == null ? 43 : $recipient.hashCode());
        String $sender = this.getSender();
        result = result * 59 + ($sender == null ? 43 : $sender.hashCode());
        String $menuInfoString = this.getMenuInfoString();
        result = result * 59 + ($menuInfoString == null ? 43 : $menuInfoString.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MessageMetaDataDto(uuid=" + this.getUuid() + ", path=" + this.getPath() + ", method=" + this.getMethod() + ", responseCode=" + this.getResponseCode() + ", recipient=" + this.getRecipient() + ", sender=" + this.getSender() + ", sequenceNumber=" + this.getSequenceNumber() + ", menuInfoString=" + this.getMenuInfoString() + ", timestamp=" + this.getTimestamp() + ", isRequest=" + this.isRequest() + ")";
    }

    @ConstructorProperties(value={"uuid", "path", "method", "responseCode", "recipient", "sender", "sequenceNumber", "menuInfoString", "timestamp", "isRequest"})
    @Generated
    public MessageMetaDataDto(String uuid, String path, String method, Integer responseCode, String recipient, String sender, long sequenceNumber, String menuInfoString, long timestamp, boolean isRequest) {
        this.uuid = uuid;
        this.path = path;
        this.method = method;
        this.responseCode = responseCode;
        this.recipient = recipient;
        this.sender = sender;
        this.sequenceNumber = sequenceNumber;
        this.menuInfoString = menuInfoString;
        this.timestamp = timestamp;
        this.isRequest = isRequest;
    }

    @Generated
    public MessageMetaDataDto() {
    }

    @Generated
    public static class MessageMetaDataDtoBuilder {
        @Generated
        private String uuid;
        @Generated
        private String path;
        @Generated
        private String method;
        @Generated
        private Integer responseCode;
        @Generated
        private String recipient;
        @Generated
        private String sender;
        @Generated
        private long sequenceNumber;
        @Generated
        private String menuInfoString;
        @Generated
        private long timestamp;
        @Generated
        private boolean isRequest;

        @Generated
        MessageMetaDataDtoBuilder() {
        }

        @Generated
        public MessageMetaDataDtoBuilder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        @Generated
        public MessageMetaDataDtoBuilder path(String path) {
            this.path = path;
            return this;
        }

        @Generated
        public MessageMetaDataDtoBuilder method(String method) {
            this.method = method;
            return this;
        }

        @Generated
        public MessageMetaDataDtoBuilder responseCode(Integer responseCode) {
            this.responseCode = responseCode;
            return this;
        }

        @Generated
        public MessageMetaDataDtoBuilder recipient(String recipient) {
            this.recipient = recipient;
            return this;
        }

        @Generated
        public MessageMetaDataDtoBuilder sender(String sender) {
            this.sender = sender;
            return this;
        }

        @Generated
        public MessageMetaDataDtoBuilder sequenceNumber(long sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        @Generated
        public MessageMetaDataDtoBuilder menuInfoString(String menuInfoString) {
            this.menuInfoString = menuInfoString;
            return this;
        }

        @Generated
        public MessageMetaDataDtoBuilder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Generated
        public MessageMetaDataDtoBuilder isRequest(boolean isRequest) {
            this.isRequest = isRequest;
            return this;
        }

        @Generated
        public MessageMetaDataDto build() {
            return new MessageMetaDataDto(this.uuid, this.path, this.method, this.responseCode, this.recipient, this.sender, this.sequenceNumber, this.menuInfoString, this.timestamp, this.isRequest);
        }

        @Generated
        public String toString() {
            return "MessageMetaDataDto.MessageMetaDataDtoBuilder(uuid=" + this.uuid + ", path=" + this.path + ", method=" + this.method + ", responseCode=" + this.responseCode + ", recipient=" + this.recipient + ", sender=" + this.sender + ", sequenceNumber=" + this.sequenceNumber + ", menuInfoString=" + this.menuInfoString + ", timestamp=" + this.timestamp + ", isRequest=" + this.isRequest + ")";
        }
    }
}

