/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy;

import de.gematik.rbellogger.modifier.RbelModificationDescription;
import de.gematik.rbellogger.renderer.RbelHtmlRenderer;
import de.gematik.test.tiger.common.data.config.tigerProxy.TigerProxyConfiguration;
import de.gematik.test.tiger.common.data.config.tigerProxy.TigerRoute;
import de.gematik.test.tiger.common.data.config.tigerProxy.TigerTlsConfiguration;
import de.gematik.test.tiger.common.pki.TigerPkiIdentity;
import de.gematik.test.tiger.proxy.AbstractTigerProxy;
import de.gematik.test.tiger.proxy.ForwardAllCallback;
import de.gematik.test.tiger.proxy.ForwardProxyCallback;
import de.gematik.test.tiger.proxy.MockServerToRbelConverter;
import de.gematik.test.tiger.proxy.ReverseProxyCallback;
import de.gematik.test.tiger.proxy.TigerKeyAndCertificateFactory;
import de.gematik.test.tiger.proxy.client.TigerRemoteProxyClient;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyConfigurationException;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyRouteConflictException;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyStartupException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import kong.unirest.Client;
import kong.unirest.Config;
import kong.unirest.Unirest;
import kong.unirest.apache.ApacheClient;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.tomcat.util.buf.UriUtil;
import org.mockserver.client.MockServerClient;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.TimeToLive;
import org.mockserver.matchers.Times;
import org.mockserver.mock.Expectation;
import org.mockserver.mock.action.ExpectationForwardCallback;
import org.mockserver.model.ExpectationId;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.RequestDefinition;
import org.mockserver.netty.MockServer;
import org.mockserver.proxyconfiguration.ProxyConfiguration;
import org.mockserver.socket.tls.KeyAndCertificateFactory;
import org.mockserver.socket.tls.KeyAndCertificateFactoryFactory;
import org.mockserver.socket.tls.NettySslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerProxy
extends AbstractTigerProxy
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerProxy.class);
    private final List<TigerKeyAndCertificateFactory> tlsFactories = new ArrayList<TigerKeyAndCertificateFactory>();
    private final List<Consumer<Throwable>> exceptionListeners = new ArrayList<Consumer<Throwable>>();
    private final MockServer mockServer;
    private final MockServerClient mockServerClient;
    private final MockServerToRbelConverter mockServerToRbelConverter;
    private final Map<String, TigerRoute> tigerRouteMap = new HashMap<String, TigerRoute>();
    private final List<TigerRemoteProxyClient> remoteProxyClients = new ArrayList<TigerRemoteProxyClient>();

    public TigerProxy(TigerProxyConfiguration configuration) {
        super(configuration);
        KeyAndCertificateFactoryFactory.setCustomKeyAndCertificateFactorySupplier(this.buildKeyAndCertificateFactory());
        this.mockServerToRbelConverter = new MockServerToRbelConverter(this.getRbelLogger().getRbelConverter());
        ConfigurationProperties.useBouncyCastleForKeyAndCertificateGeneration((boolean)true);
        ConfigurationProperties.forwardProxyTLSX509CertificatesTrustManagerType((String)"ANY");
        ConfigurationProperties.maxLogEntries((int)10);
        if (StringUtils.isNotEmpty((CharSequence)configuration.getProxyLogLevel())) {
            ConfigurationProperties.logLevel((String)configuration.getProxyLogLevel());
        }
        this.customizeSslSuitesIfApplicable(configuration);
        Optional forwardProxyConfig = configuration.convertForwardProxyConfigurationToMockServerConfiguration();
        this.outputForwardProxyConfigLogs(forwardProxyConfig);
        this.mockServer = forwardProxyConfig.map(proxyConfiguration -> new MockServer(proxyConfiguration, configuration.getPortAsArray())).orElseGet(() -> new MockServer(configuration.getPortAsArray()));
        log.info("Proxy started on port " + this.mockServer.getLocalPort());
        this.mockServerClient = new MockServerClient("localhost", this.mockServer.getLocalPort());
        if (configuration.getProxyRoutes() != null) {
            for (TigerRoute tigerRoute : configuration.getProxyRoutes()) {
                this.addRoute(tigerRoute);
            }
        }
        if (configuration.isActivateRbelEndpoint()) {
            this.addRbelTrafficEndpoint();
        }
        if (!configuration.isSkipTrafficEndpointsSubscription()) {
            this.subscribeToTrafficEndpoints(configuration);
        }
        if (configuration.getModifications() != null) {
            int counter = 0;
            for (RbelModificationDescription modification : configuration.getModifications()) {
                if (modification.getName() == null) {
                    modification.setName("TigerModification #" + counter++);
                }
                this.getRbelLogger().getRbelModifier().addModification(modification);
            }
        }
        if (configuration.isActivateForwardAllLogging()) {
            this.mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(".*"), Times.unlimited(), TimeToLive.unlimited(), Integer.valueOf(Integer.MIN_VALUE)).forward((ExpectationForwardCallback)new ForwardAllCallback(this));
        }
    }

    private void customizeSslSuitesIfApplicable(TigerProxyConfiguration configuration) {
        if (configuration.getTls().getServerSslSuites() != null) {
            NettySslContextFactory.sslServerContextBuilderCustomizer = builder -> {
                builder.ciphers((Iterable)configuration.getTls().getServerSslSuites());
                return builder;
            };
        }
        if (configuration.getTls().getClientSslSuites() != null) {
            NettySslContextFactory.sslClientContextBuilderCustomizer = builder -> {
                builder.ciphers((Iterable)configuration.getTls().getClientSslSuites());
                return builder;
            };
        }
    }

    private BiFunction<MockServerLogger, Boolean, KeyAndCertificateFactory> buildKeyAndCertificateFactory() {
        if (this.getTigerProxyConfiguration().getTls().getServerIdentity() != null && !this.getTigerProxyConfiguration().getTls().getServerIdentity().hasValidChainWithRootCa()) {
            throw new TigerProxyStartupException("Configured server-identity has no valid chain!");
        }
        return (mockServerLogger, isServerInstance) -> {
            if (isServerInstance.booleanValue() || this.getTigerProxyConfiguration().getTls() == null || this.getTigerProxyConfiguration().getTls().getForwardMutualTlsIdentity() == null) {
                TigerKeyAndCertificateFactory factory = new TigerKeyAndCertificateFactory((MockServerLogger)mockServerLogger, this.determineServerRootCa().orElse(null), (TigerPkiIdentity)this.getTigerProxyConfiguration().getTls().getServerIdentity(), this.getTigerProxyConfiguration().getTls());
                if (isServerInstance.booleanValue()) {
                    this.tlsFactories.add(factory);
                }
                return factory;
            }
            return new TigerKeyAndCertificateFactory((MockServerLogger)mockServerLogger, null, (TigerPkiIdentity)this.getTigerProxyConfiguration().getTls().getForwardMutualTlsIdentity(), this.getTigerProxyConfiguration().getTls());
        };
    }

    private Optional<TigerPkiIdentity> determineServerRootCa() {
        if (this.getTigerProxyConfiguration().getTls().getServerRootCa() != null) {
            return Optional.ofNullable(this.getTigerProxyConfiguration().getTls().getServerRootCa());
        }
        if (this.getTigerProxyConfiguration().getTls().getServerIdentity() != null) {
            return Optional.empty();
        }
        return Optional.of(new TigerPkiIdentity("CertificateAuthorityCertificate.pem;PKCS8CertificateAuthorityPrivateKey.pem;PKCS8"));
    }

    public void subscribeToTrafficEndpoints(TigerProxyConfiguration configuration) {
        Optional.of(configuration).filter(Objects::nonNull).map(TigerProxyConfiguration::getTrafficEndpoints).ifPresent(this::subscribeToTrafficEndpoints);
    }

    public void subscribeToTrafficEndpoints(List<String> trafficEndpointUrls) {
        ((Stream)Optional.of(trafficEndpointUrls).filter(Objects::nonNull).stream().flatMap(Collection::stream).parallel()).map(url -> new TigerRemoteProxyClient((String)url, TigerProxyConfiguration.builder().downloadInitialTrafficFromEndpoints(this.getTigerProxyConfiguration().isDownloadInitialTrafficFromEndpoints()).name(this.getTigerProxyConfiguration().getName()).connectionTimeoutInSeconds(this.getTigerProxyConfiguration().getConnectionTimeoutInSeconds()).build(), this)).forEach(this.remoteProxyClients::add);
    }

    private void addRbelTrafficEndpoint() {
        this.mockServerClient.when((RequestDefinition)HttpRequest.request().withHeader("Host", new String[]{"rbel"})).respond(HttpResponse.response().withHeader("content-type", new String[]{"text/html; charset=utf-8"}).withBody(new RbelHtmlRenderer().doRender(this.getRbelLogger().getMessageHistory())));
        this.mockServerClient.when((RequestDefinition)HttpRequest.request().withHeader("Host", null).withPath("/rbel")).respond(httpRequest -> HttpResponse.response().withHeader("content-type", new String[]{"text/html; charset=utf-8"}).withBody(new RbelHtmlRenderer().doRender(this.getRbelLogger().getMessageHistory())));
    }

    @Override
    public String getBaseUrl() {
        return "http://localhost:" + this.mockServer.getLocalPort();
    }

    @Override
    public int getProxyPort() {
        return this.mockServer.getLocalPort();
    }

    @Override
    public List<TigerRoute> getRoutes() {
        return this.tigerRouteMap.values().stream().collect(Collectors.toUnmodifiableList());
    }

    @Override
    public RbelModificationDescription addModificaton(RbelModificationDescription modification) {
        this.getRbelLogger().getRbelModifier().addModification(modification);
        return modification;
    }

    @Override
    public List<RbelModificationDescription> getModifications() {
        return this.getRbelLogger().getRbelModifier().getModifications();
    }

    @Override
    public void removeModification(String modificationId) {
        this.getRbelLogger().getRbelModifier().deleteModification(modificationId);
    }

    @Override
    public TigerRoute addRoute(TigerRoute tigerRoute) {
        this.tigerRouteMap.values().stream().filter(existingRoute -> this.uriTwoIsBelowUriOne(existingRoute.getFrom(), tigerRoute.getFrom()) || this.uriTwoIsBelowUriOne(tigerRoute.getFrom(), existingRoute.getFrom())).findAny().ifPresent(existingRoute -> {
            throw new TigerProxyRouteConflictException((TigerRoute)existingRoute);
        });
        log.info("Adding route {} -> {}", (Object)tigerRoute.getFrom(), (Object)tigerRoute.getTo());
        Expectation[] expectations = this.buildRouteAndReturnExpectation(tigerRoute);
        if (expectations.length > 1) {
            log.warn("Unexpected number of expectations created! Got {}, expected 1", (Object)expectations.length);
        }
        if (expectations.length == 0) {
            throw new TigerProxyConfigurationException("Error while adding route from '{}' to '{}': Got 0 new expectations");
        }
        TigerRoute createdTigerRoute = tigerRoute.withId(expectations[0].getId());
        this.tigerRouteMap.put(expectations[0].getId(), createdTigerRoute);
        log.info("Created route {} with expectation {}", (Object)createdTigerRoute, (Object)expectations[0]);
        return createdTigerRoute;
    }

    private boolean uriTwoIsBelowUriOne(String value1, String value2) {
        try {
            URI uri1 = new URI(value1);
            URI uri2WithUri1Scheme = new URIBuilder(value2).setScheme(uri1.getScheme()).build();
            return !new URI(value1).relativize(uri2WithUri1Scheme).equals(uri2WithUri1Scheme);
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    private Expectation[] buildRouteAndReturnExpectation(TigerRoute tigerRoute) {
        if (UriUtil.hasScheme((CharSequence)tigerRoute.getFrom())) {
            return this.buildForwardProxyRoute(tigerRoute);
        }
        return this.buildReverseProxyRoute(tigerRoute);
    }

    private Expectation[] buildReverseProxyRoute(TigerRoute tigerRoute) {
        return this.mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(tigerRoute.getFrom() + ".*")).forward((ExpectationForwardCallback)new ReverseProxyCallback(this, tigerRoute));
    }

    private Expectation[] buildForwardProxyRoute(TigerRoute tigerRoute) {
        return this.mockServerClient.when((RequestDefinition)HttpRequest.request().withHeader("Host", new String[]{tigerRoute.getFrom().split("://")[1]}).withSecure(Boolean.valueOf(tigerRoute.getFrom().startsWith("https://")))).forward((ExpectationForwardCallback)new ForwardProxyCallback(this, tigerRoute));
    }

    public void addAlternativeName(String host) {
        ArrayList<String> newAlternativeNames = new ArrayList<String>();
        if (this.getTigerProxyConfiguration().getTls() != null && this.getTigerProxyConfiguration().getTls().getAlternativeNames() != null) {
            newAlternativeNames.addAll(this.getTigerProxyConfiguration().getTls().getAlternativeNames());
        }
        newAlternativeNames.add(host);
        this.getTigerProxyConfiguration().getTls().setAlternativeNames(newAlternativeNames);
        for (TigerKeyAndCertificateFactory tlsFactory : this.tlsFactories) {
            tlsFactory.addAlternativeName(host);
            tlsFactory.resetEeCertificate();
        }
    }

    @Override
    public void removeRoute(String routeId) {
        if (!this.mockServer.isRunning()) {
            return;
        }
        this.mockServerClient.clear(new ExpectationId().withId(routeId));
        TigerRoute route = this.tigerRouteMap.remove(routeId);
        log.info("Deleted route {}. Current # expectations {}", (Object)route, (Object)this.mockServerClient.retrieveActiveExpectations((RequestDefinition)HttpRequest.request()).length);
    }

    public SSLContext getConfiguredTigerProxySslContext() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{this.buildTrustManagerForTigerProxy()}, null);
            SSLContext.setDefault(sslContext);
            return sslContext;
        }
        catch (Exception e) {
            throw new TigerProxyTrustManagerBuildingException("Error while configuring SSL Context for Tiger Proxy", e);
        }
    }

    public X509TrustManager buildTrustManagerForTigerProxy() {
        try {
            final X509TrustManager defaultTrustManager = this.extractTrustManager(null);
            final X509TrustManager customTrustManager = this.extractTrustManager(this.buildTruststore());
            return new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return defaultTrustManager.getAcceptedIssuers();
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    try {
                        customTrustManager.checkServerTrusted(chain, authType);
                    }
                    catch (CertificateException e) {
                        defaultTrustManager.checkServerTrusted(chain, authType);
                    }
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    defaultTrustManager.checkClientTrusted(chain, authType);
                }
            };
        }
        catch (Exception e) {
            throw new TigerProxyTrustManagerBuildingException("Error while building TrustManager for Tiger Proxy", e);
        }
    }

    private X509TrustManager extractTrustManager(KeyStore keystore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keystore);
        return (X509TrustManager)Arrays.stream(trustManagerFactory.getTrustManagers()).filter(X509TrustManager.class::isInstance).findAny().orElseThrow(() -> new TigerProxyTrustManagerBuildingException("Error while configuring TrustManager for Tiger Proxy"));
    }

    public KeyStore buildTruststore() {
        try {
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(null);
            TigerPkiIdentity serverIdentity = this.determineServerRootCa().or(() -> Optional.ofNullable(this.getTigerProxyConfiguration().getTls()).map(TigerTlsConfiguration::getServerIdentity).filter(Objects::nonNull)).orElseThrow(() -> new TigerProxyTrustManagerBuildingException("Unrecoverable state: Server-Identity null and Server-CA empty"));
            ks.setCertificateEntry("caCert", serverIdentity.getCertificate());
            int chainCertCtr = 0;
            for (X509Certificate chainCert : serverIdentity.getCertificateChain()) {
                ks.setCertificateEntry("chainCert" + chainCertCtr++, chainCert);
            }
            return ks;
        }
        catch (Exception e) {
            throw new TigerProxyTrustManagerBuildingException("Error while building SSL-Context for Tiger Proxy", e);
        }
    }

    public SSLContext buildSslContext() {
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(this.buildTruststore());
            SSLContext sslContext = SSLContext.getInstance("TLS");
            TrustManager[] trustManagers = tmf.getTrustManagers();
            sslContext.init(null, trustManagers, null);
            CloseableHttpClient httpClient = HttpClients.custom().setSSLContext(sslContext).setSSLHostnameVerifier((HostnameVerifier)new DefaultHostnameVerifier()).build();
            Unirest.primaryInstance().config().httpClient(arg_0 -> TigerProxy.lambda$buildSslContext$12((HttpClient)httpClient, arg_0));
            return sslContext;
        }
        catch (RuntimeException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new TigerProxyTrustManagerBuildingException("Error while building SSL-Context for Tiger Proxy", e);
        }
    }

    private void outputForwardProxyConfigLogs(Optional<ProxyConfiguration> forwardProxyConfig) {
        if (forwardProxyConfig.isEmpty()) {
            log.info("Tigerproxy has NO forward proxy configured!");
        } else {
            ProxyConfiguration configNotEmpty = forwardProxyConfig.get();
            if (configNotEmpty.getUsername() == null) {
                log.info("Forward proxy is set to " + configNotEmpty.getType() + "://" + configNotEmpty.getProxyAddress().getHostName() + ":" + configNotEmpty.getProxyAddress().getPort());
            } else if (configNotEmpty.getUsername() != null) {
                log.info("Forward proxy is set to " + configNotEmpty.getType() + "://" + configNotEmpty.getProxyAddress().getHostName() + ":" + configNotEmpty.getProxyAddress().getPort() + "@" + configNotEmpty.getUsername() + ":" + configNotEmpty.getPassword());
            }
        }
    }

    public void propagateException(Throwable exception) {
        this.exceptionListeners.forEach(consumer -> consumer.accept(exception));
    }

    public void addNewExceptionConsumer(Consumer<Throwable> newConsumer) {
        this.exceptionListeners.add(newConsumer);
    }

    public void shutdown() {
        this.remoteProxyClients.forEach(TigerRemoteProxyClient::close);
        this.mockServerClient.stop();
        this.mockServer.stop();
    }

    @Override
    public void close() throws Exception {
        this.shutdown();
    }

    @Generated
    public MockServerToRbelConverter getMockServerToRbelConverter() {
        return this.mockServerToRbelConverter;
    }

    private static /* synthetic */ Client lambda$buildSslContext$12(HttpClient httpClient, Config config) {
        return ApacheClient.builder((HttpClient)httpClient).apply(config);
    }

    private static class TigerProxyTrustManagerBuildingException
    extends RuntimeException {
        public TigerProxyTrustManagerBuildingException(String s, Exception e) {
            super(s, e);
        }

        public TigerProxyTrustManagerBuildingException(String s) {
            super(s);
        }
    }
}

