/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.controller;

import com.google.common.html.HtmlEscapers;
import de.gematik.rbellogger.converter.RbelJexlExecutor;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.util.RbelElementTreePrinter;
import de.gematik.rbellogger.renderer.RbelHtmlRenderer;
import de.gematik.rbellogger.renderer.RbelHtmlRenderingToolkit;
import de.gematik.rbellogger.util.RbelAnsiColors;
import de.gematik.rbellogger.util.RbelFileWriterUtils;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.proxy.client.TigerRemoteProxyClientException;
import de.gematik.test.tiger.proxy.configuration.ApplicationConfiguration;
import de.gematik.test.tiger.proxy.data.GetMessagesAfterDto;
import de.gematik.test.tiger.proxy.data.JexlQueryResponseDto;
import de.gematik.test.tiger.proxy.data.MessageMetaDataDto;
import de.gematik.test.tiger.proxy.data.ResetMessagesDto;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyConfigurationException;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyWebUiException;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import j2html.tags.EmptyTag;
import java.beans.ConstructorProperties;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"webui"})
@Validated
public class TigerWebUiController
implements ApplicationContextAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerWebUiController.class);
    private final TigerProxy tigerProxy;
    private final RbelHtmlRenderer renderer = new RbelHtmlRenderer();
    private final ApplicationConfiguration applicationConfiguration;
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext appContext) throws BeansException {
        this.applicationContext = appContext;
    }

    @GetMapping(value={"/trafficLog.tgr"}, produces={"application/octet-stream"})
    public String downloadTraffic() {
        return this.tigerProxy.getRbelMessages().stream().map(RbelFileWriterUtils::convertToRbelFileString).collect(Collectors.joining("\n\n"));
    }

    @GetMapping(value={""}, produces={"text/html"})
    public String getUI(@RequestParam(defaultValue="false") boolean embedded) {
        String html = this.renderer.getEmptyPage();
        String targetDiv = embedded ? "<div class=\"column msglist embeddedlist\">" : "<div class=\"column ml-6 msglist\">";
        html = this.replaceScript(html.replace("<div class=\"column ml-6\">", targetDiv));
        if (this.applicationConfiguration.isLocalResources()) {
            log.info("Running with local resources...");
            html = html.replace("https://cdn.jsdelivr.net/npm/bulma@0.9.1/css/bulma.min.css", "/webui/css/bulma.min.css").replace("https://jenil.github.io/bulmaswatch/simplex/bulmaswatch.min.css", "/webui/css/bulmaswatch.min.css").replace("https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.2/css/all.min.css", "/webui/css/all.min.css");
        }
        String navbar = ((ContainerTag)((ContainerTag)TagCreator.nav().withClass("navbar is-dark is-fixed-bottom not4embedded")).withStyle("bottom: 57px !important;")).with((DomContent)((ContainerTag)TagCreator.div().withClass("navbar-menu")).with((DomContent)((ContainerTag)TagCreator.div().withClass("navbar-start")).with(new DomContent[]{((ContainerTag)TagCreator.div().withClass("navbar-item not4embedded")).with((DomContent)((ContainerTag)((ContainerTag)((ContainerTag)TagCreator.button().withId("routeModalBtn")).withClass("button is-dark")).attr("data-target", (Object)"routeModalDialog")).with(new DomContent[]{((ContainerTag)TagCreator.div().withId("routeModalLed")).withClass("led"), TagCreator.span((String)"Routes")})), ((ContainerTag)TagCreator.div().withClass("navbar-item")).with((DomContent)((ContainerTag)((ContainerTag)TagCreator.button().withId("scrollLockBtn")).withClass("button is-dark")).with(new DomContent[]{((ContainerTag)TagCreator.div().withId("scrollLockLed")).withClass("led"), TagCreator.span((String)"Scroll Lock")})), ((ContainerTag)((ContainerTag)TagCreator.form().withClass("is-inline-flex")).attr("onSubmit", (Object)"return false;")).with(new DomContent[]{((ContainerTag)TagCreator.div().withClass("navbar-item")).with((DomContent)((ContainerTag)TagCreator.div().withClass("field")).with((DomContent)((ContainerTag)TagCreator.p().withClass("control has-icons-left")).with((DomContent)((EmptyTag)((EmptyTag)((EmptyTag)((EmptyTag)TagCreator.input().withClass("input is-rounded has-text-dark")).withType("text")).withPlaceholder("RbelPath filter criterion")).withId("setFilterCriterionInput")).attr("autocomplete", (Object)"on")))), ((ContainerTag)TagCreator.div().withClass("navbar-item")).with((DomContent)((ContainerTag)((ContainerTag)TagCreator.button().withId("setFilterCriterionBtn")).withClass("button is-outlined is-success")).with(new DomContent[]{TagCreator.i().withClass("fas fa-filter"), ((ContainerTag)TagCreator.span((String)"Set Filter").withClass("ml-2")).withStyle("color:inherit;")}))}), ((ContainerTag)TagCreator.div().withClass("navbar-item mr-3")).with(new DomContent[]{((ContainerTag)TagCreator.div().withId("updateLed")).withClass("led "), this.radio("1s", "updates", "update1", "1", "updates"), this.radio("2s", "updates", "update2", "2", "updates"), this.radio("5s", "updates", "update5", "5", "updates"), this.radio("Manual", "updates", "noupdate", "0", "updates"), ((ContainerTag)TagCreator.button((String)"Update").withId("updateBtn")).withClass("button is-outlined is-success")}), ((ContainerTag)TagCreator.div().withClass("navbar-item ml-3")).with((DomContent)((ContainerTag)((ContainerTag)TagCreator.button().withId("resetMsgs")).withClass("button is-outlined is-danger")).with(new DomContent[]{TagCreator.i().withClass("far fa-trash-alt"), ((ContainerTag)TagCreator.span((String)"Reset").withClass("ml-2")).withStyle("color:inherit;")})), ((ContainerTag)TagCreator.div().withClass("navbar-item")).with((DomContent)((ContainerTag)((ContainerTag)TagCreator.button().withId("saveMsgs")).withClass("button is-outlined is-success")).with(new DomContent[]{TagCreator.i().withClass("far fa-save"), ((ContainerTag)TagCreator.span((String)"Save").withClass("ml-2")).withStyle("color:inherit;")})), ((ContainerTag)TagCreator.div().withClass("navbar-item")).with((DomContent)((ContainerTag)((ContainerTag)TagCreator.button().withId("uploadMsgs")).withClass("button is-outlined is-info")).with(new DomContent[]{TagCreator.i().withClass("fas fa-upload"), ((ContainerTag)TagCreator.span((String)"Upload").withClass("ml-2")).withStyle("color:inherit;")})), ((ContainerTag)TagCreator.div().withClass("navbar-item")).with(new DomContent[]{TagCreator.span((String)"Proxy port "), TagCreator.b((String)("" + this.tigerProxy.getProxyPort())).withClass("ml-3")}), ((ContainerTag)TagCreator.div().withClass("navbar-item")).with((DomContent)((ContainerTag)((ContainerTag)TagCreator.button().withId("quitProxy")).withClass("button is-outlined is-danger")).with(new DomContent[]{TagCreator.i().withClass("fas fa-power-off"), ((ContainerTag)TagCreator.span((String)"Quit").withClass("ml-2")).withStyle("color:inherit;")}))}))).render();
        String configJSSnippetStr = this.loadResourceToString("/configScript.html").replace("${ProxyPort}", String.valueOf(this.tigerProxy.getProxyPort())).replace("${FilenamePattern}", this.applicationConfiguration.getFilenamePattern()).replace("${UploadUrl}", this.applicationConfiguration.getUploadUrl());
        return html.replace("<div id=\"navbardiv\"></div>", navbar + this.loadResourceToString("/routeModal.html") + this.loadResourceToString("/jexlModal.html") + this.loadResourceToString("/saveModal.html")).replace("</body>", configJSSnippetStr + "</body>");
    }

    private String replaceScript(String html) {
        Document jsoup = Jsoup.parse((String)html);
        Element script = (Element)jsoup.select("script").get(0);
        ((DataNode)script.dataNodes().get(0)).replaceWith((Node)new DataNode(this.loadResourceToString("/tigerProxy.js")));
        return jsoup.html();
    }

    private String loadResourceToString(String resourceName) {
        InputStream resource = this.getClass().getResourceAsStream(resourceName);
        if (resource == null) {
            throw new TigerProxyConfigurationException("Unable to load resource '" + resourceName + "' !");
        }
        try {
            return IOUtils.toString((InputStream)resource, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new TigerProxyWebUiException("Exception while loading resource '" + resourceName + "'", e);
        }
    }

    @GetMapping(value={"/css/{cssfile}"}, produces={"text/css"})
    public String getCSS(@PathVariable(value="cssfile") String cssFile) throws IOException {
        try (InputStream is = this.getClass().getResourceAsStream("/css/" + cssFile);){
            if (is == null) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, "css file " + cssFile + " not found");
            }
            String string = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }

    @GetMapping(value={"/testJexlQuery"}, produces={"application/json"})
    public JexlQueryResponseDto testJexlQuery(@RequestParam(name="msgUuid") String msgUuid, @RequestParam(name="query") String query) {
        RbelJexlExecutor jexlExecutor = new RbelJexlExecutor();
        RbelElement targetMessage = this.getTigerProxy().getRbelMessages().stream().filter(msg -> msg.getUuid().equals(msgUuid)).findFirst().orElseThrow();
        Map messageContext = jexlExecutor.buildJexlMapContext((Object)targetMessage, Optional.empty());
        RbelElementTreePrinter treePrinter = RbelElementTreePrinter.builder().rootElement(targetMessage).printFacets(false).build();
        return JexlQueryResponseDto.builder().matchSuccessful(jexlExecutor.matchesAsJexlExpression((Object)targetMessage, query)).messageContext(messageContext).rbelTreeHtml(HtmlEscapers.htmlEscaper().escape(treePrinter.execute()).replace(RbelAnsiColors.RESET.toString(), "</span>").replace(RbelAnsiColors.RED_BOLD.toString(), "<span class='has-text-danger'>").replace(RbelAnsiColors.CYAN.toString(), "<span class='has-text-info'>").replace(RbelAnsiColors.YELLOW_BRIGHT.toString(), "<span class='has-text-primary has-text-weight-bold'>").replace(RbelAnsiColors.GREEN.toString(), "<span class='has-text-warning'>").replace(RbelAnsiColors.BLUE.toString(), "<span class='has-text-success'>").replace("\n", "<br/>")).build();
    }

    @GetMapping(value={"/testRbelExpression"}, produces={"application/json"})
    public JexlQueryResponseDto testRbelExpression(@RequestParam(name="msgUuid") String msgUuid, @RequestParam(name="rbelPath") String rbelPath) {
        List targetElements = this.getTigerProxy().getRbelMessages().stream().filter(msg -> msg.getUuid().equals(msgUuid)).map(msg -> msg.findRbelPathMembers(rbelPath)).flatMap(Collection::stream).collect(Collectors.toList());
        if (targetElements.isEmpty()) {
            return JexlQueryResponseDto.builder().build();
        }
        RbelElementTreePrinter treePrinter = RbelElementTreePrinter.builder().rootElement((RbelElement)targetElements.get(0)).printFacets(false).build();
        return JexlQueryResponseDto.builder().rbelTreeHtml(HtmlEscapers.htmlEscaper().escape(treePrinter.execute()).replace(RbelAnsiColors.RESET.toString(), "</span>").replace(RbelAnsiColors.RED_BOLD.toString(), "<span class='has-text-danger'>").replace(RbelAnsiColors.CYAN.toString(), "<span class='has-text-info'>").replace(RbelAnsiColors.YELLOW_BRIGHT.toString(), "<span class='has-text-primary has-text-weight-bold'>").replace(RbelAnsiColors.GREEN.toString(), "<span class='has-text-warning'>").replace(RbelAnsiColors.BLUE.toString(), "<span class='has-text-success'>").replace("\n", "<br/>")).elements(targetElements.stream().map(RbelElement::findNodePath).map(key -> "$." + key).collect(Collectors.toList())).build();
    }

    @GetMapping(value={"/webfonts/{fontfile}"}, produces={"text/css"})
    public ResponseEntity<byte[]> getWebFont(@PathVariable(value="fontfile") String fontFile) throws IOException {
        try (InputStream is = this.getClass().getResourceAsStream("/webfonts/" + fontFile);){
            if (is == null) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, "webfont file " + fontFile + " not found");
            }
            ResponseEntity responseEntity = new ResponseEntity((Object)IOUtils.toByteArray((InputStream)is), HttpStatus.OK);
            return responseEntity;
        }
    }

    @GetMapping(value={"/getMsgAfter"}, produces={"application/json"})
    public GetMessagesAfterDto getMessagesAfter(@RequestParam(name="lastMsgUuid", required=false) String lastMsgUuid, @RequestParam(name="filterCriterion", required=false) String filterCriterion) {
        log.debug("requesting messages since " + lastMsgUuid + " (filtered by . " + filterCriterion + ")");
        RbelJexlExecutor jexlExecutor = new RbelJexlExecutor();
        List msgs = this.tigerProxy.getRbelLogger().getMessageHistory().stream().dropWhile(msg -> {
            if (StringUtils.isEmpty((CharSequence)lastMsgUuid)) {
                return false;
            }
            return !msg.getUuid().equals(lastMsgUuid);
        }).filter(msg -> !msg.getUuid().equals(lastMsgUuid)).filter(msg -> {
            if (StringUtils.isEmpty((CharSequence)filterCriterion)) {
                return true;
            }
            return jexlExecutor.matchesAsJexlExpression(msg, filterCriterion, Optional.empty());
        }).collect(Collectors.toList());
        GetMessagesAfterDto result = new GetMessagesAfterDto();
        result.setLastMsgUuid(lastMsgUuid);
        log.debug("returning {} messages of total {}", (Object)msgs.size(), (Object)this.tigerProxy.getRbelMessages().size());
        result.setHtmlMsgList(msgs.stream().map(msg -> new RbelHtmlRenderingToolkit(this.renderer).convertMessage(msg).render()).collect(Collectors.toList()));
        result.setMetaMsgList(msgs.stream().map(MessageMetaDataDto::createFrom).collect(Collectors.toList()));
        return result;
    }

    @GetMapping(value={"/resetMsgs"}, produces={"application/json"})
    public ResetMessagesDto resetMessages() {
        log.info("resetting currently recorded messages on rbel logger..");
        List msgs = this.tigerProxy.getRbelLogger().getMessageHistory();
        ResetMessagesDto result = new ResetMessagesDto();
        result.setNumMsgs(msgs.size());
        msgs.clear();
        return result;
    }

    @GetMapping(value={"/quit"}, produces={"application/json"})
    public void quitProxy(@RequestParam(name="noSystemExit", required=false) String noSystemExit) {
        log.info("shutting down tiger standalone proxy at port " + this.tigerProxy.getProxyPort() + "...");
        this.tigerProxy.clearAllRoutes();
        this.tigerProxy.shutdown();
        log.info("shutting down tiger standalone proxy ui...");
        int exitCode = SpringApplication.exit((ApplicationContext)this.applicationContext, (ExitCodeGenerator[])new ExitCodeGenerator[0]);
        if (exitCode != 0) {
            log.warn("Exit of tiger proxy ui not successful - exit code: " + exitCode);
        }
        if (StringUtils.isEmpty((CharSequence)noSystemExit)) {
            System.exit(0);
        }
    }

    @PostMapping(value={"/uploadReport"}, produces={"application/json"})
    public void uploadReport(@RequestBody String htmlReport) {
        if (this.applicationConfiguration.getUploadUrl().equals("UNDEFINED")) {
            throw new TigerProxyConfigurationException("Upload feature is not configured!");
        }
        log.info("uploading report...");
        this.performUploadReport(URLDecoder.decode(htmlReport, StandardCharsets.UTF_8));
    }

    private ContainerTag radio(String text, String name, String id, String value, String clazz) {
        return this.radio(text, name, id, value, clazz, false);
    }

    private ContainerTag radio(String text, String name, String id, String value, String clazz, boolean checked) {
        return ((ContainerTag)TagCreator.div().withClass("radio-item")).with(new DomContent[]{((EmptyTag)((EmptyTag)((EmptyTag)((EmptyTag)((EmptyTag)TagCreator.input().withType("radio")).withName(name)).withId(id)).withValue(value)).withClass(clazz)).attr("checked", (Object)checked), TagCreator.label((String)text).attr("for", (Object)id)});
    }

    private void performUploadReport(String htmlReport) {
        String filename = this.applicationConfiguration.getFilenamePattern().replace("${DATE}", LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"))).replace("${TIME}", LocalTime.now().format(DateTimeFormatter.ofPattern("HHmmssSSS")));
        String uploadUrl = this.applicationConfiguration.getUploadUrl() + filename;
        try {
            URL serverUrl = new URL(uploadUrl);
            HttpURLConnection urlConnection = (HttpURLConnection)serverUrl.openConnection();
            String boundaryString = "----TigerProxyReport";
            urlConnection.setDoOutput(true);
            urlConnection.setRequestMethod("POST");
            urlConnection.addRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundaryString);
            if (this.applicationConfiguration.getUsername() != null) {
                String auth = this.applicationConfiguration.getUsername() + ":" + this.applicationConfiguration.getPassword();
                byte[] encodedAuth = Base64.encodeBase64((byte[])auth.getBytes(StandardCharsets.UTF_8));
                String authHeaderValue = "Basic " + new String(encodedAuth);
                urlConnection.setRequestProperty("Authorization", authHeaderValue);
            }
            try (OutputStream outputStreamToRequestBody = urlConnection.getOutputStream();
                 BufferedWriter httpRequestBodyWriter = new BufferedWriter(new OutputStreamWriter(outputStreamToRequestBody));){
                httpRequestBodyWriter.write("\n--" + boundaryString + "\n");
                httpRequestBodyWriter.write("Content-Disposition: form-data;name=\"Tiger proxy report archive\";filename=\"" + filename + "\"\nContent-Type: application/zip\n\n");
                httpRequestBodyWriter.flush();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try (ZipOutputStream zos = new ZipOutputStream(baos);){
                    ZipEntry entry = new ZipEntry(filename);
                    zos.putNextEntry(entry);
                    zos.write(htmlReport.getBytes(StandardCharsets.UTF_8));
                    zos.closeEntry();
                    entry = new ZipEntry("application.cfg");
                    zos.putNextEntry(entry);
                    zos.write(this.tigerProxy.getTigerProxyConfiguration().toString().getBytes(StandardCharsets.UTF_8));
                    zos.closeEntry();
                }
                outputStreamToRequestBody.write(baos.toByteArray());
                outputStreamToRequestBody.flush();
                baos.close();
                httpRequestBodyWriter.write("\n--" + boundaryString + "--\n");
                httpRequestBodyWriter.flush();
            }
        }
        catch (MalformedURLException | ProtocolException e) {
            throw new TigerProxyConfigurationException("Invalid upload url '" + uploadUrl + "'", e);
        }
        catch (IOException e) {
            throw new TigerRemoteProxyClientException("Failed to upload report to '" + uploadUrl + "'", e);
        }
    }

    @Generated
    public TigerProxy getTigerProxy() {
        return this.tigerProxy;
    }

    @Generated
    public RbelHtmlRenderer getRenderer() {
        return this.renderer;
    }

    @Generated
    public ApplicationConfiguration getApplicationConfiguration() {
        return this.applicationConfiguration;
    }

    @Generated
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TigerWebUiController)) {
            return false;
        }
        TigerWebUiController other = (TigerWebUiController)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TigerProxy this$tigerProxy = this.getTigerProxy();
        TigerProxy other$tigerProxy = other.getTigerProxy();
        if (this$tigerProxy == null ? other$tigerProxy != null : !((Object)this$tigerProxy).equals(other$tigerProxy)) {
            return false;
        }
        RbelHtmlRenderer this$renderer = this.getRenderer();
        RbelHtmlRenderer other$renderer = other.getRenderer();
        if (this$renderer == null ? other$renderer != null : !this$renderer.equals(other$renderer)) {
            return false;
        }
        ApplicationConfiguration this$applicationConfiguration = this.getApplicationConfiguration();
        ApplicationConfiguration other$applicationConfiguration = other.getApplicationConfiguration();
        if (this$applicationConfiguration == null ? other$applicationConfiguration != null : !((Object)((Object)this$applicationConfiguration)).equals((Object)other$applicationConfiguration)) {
            return false;
        }
        ApplicationContext this$applicationContext = this.getApplicationContext();
        ApplicationContext other$applicationContext = other.getApplicationContext();
        return !(this$applicationContext == null ? other$applicationContext != null : !this$applicationContext.equals(other$applicationContext));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TigerWebUiController;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TigerProxy $tigerProxy = this.getTigerProxy();
        result = result * 59 + ($tigerProxy == null ? 43 : ((Object)$tigerProxy).hashCode());
        RbelHtmlRenderer $renderer = this.getRenderer();
        result = result * 59 + ($renderer == null ? 43 : $renderer.hashCode());
        ApplicationConfiguration $applicationConfiguration = this.getApplicationConfiguration();
        result = result * 59 + ($applicationConfiguration == null ? 43 : ((Object)((Object)$applicationConfiguration)).hashCode());
        ApplicationContext $applicationContext = this.getApplicationContext();
        result = result * 59 + ($applicationContext == null ? 43 : $applicationContext.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TigerWebUiController(tigerProxy=" + this.getTigerProxy() + ", renderer=" + this.getRenderer() + ", applicationConfiguration=" + this.getApplicationConfiguration() + ", applicationContext=" + this.getApplicationContext() + ")";
    }

    @ConstructorProperties(value={"tigerProxy", "applicationConfiguration"})
    @Generated
    public TigerWebUiController(TigerProxy tigerProxy, ApplicationConfiguration applicationConfiguration) {
        this.tigerProxy = tigerProxy;
        this.applicationConfiguration = applicationConfiguration;
    }
}

