/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.client;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import de.gematik.rbellogger.converter.RbelJexlExecutor;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelHostname;
import de.gematik.rbellogger.data.facet.RbelFacet;
import de.gematik.rbellogger.data.facet.RbelMessageTimingFacet;
import de.gematik.rbellogger.modifier.RbelModificationDescription;
import de.gematik.test.tiger.common.data.config.tigerProxy.TigerProxyConfiguration;
import de.gematik.test.tiger.common.data.config.tigerProxy.TigerRoute;
import de.gematik.test.tiger.proxy.AbstractTigerProxy;
import de.gematik.test.tiger.proxy.client.TigerExceptionDto;
import de.gematik.test.tiger.proxy.client.TigerRemoteProxyClientException;
import de.gematik.test.tiger.proxy.client.TigerTracingDto;
import de.gematik.test.tiger.proxy.client.TracingMessagePart;
import de.gematik.test.tiger.proxy.data.TracingMessagePairFacet;
import java.beans.ConstructorProperties;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.websocket.ContainerProvider;
import javax.websocket.WebSocketContainer;
import kong.unirest.GenericType;
import kong.unirest.Unirest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.simp.stomp.ConnectionLostException;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.messaging.simp.stomp.StompFrameHandler;
import org.springframework.messaging.simp.stomp.StompHeaders;
import org.springframework.messaging.simp.stomp.StompSession;
import org.springframework.messaging.simp.stomp.StompSessionHandler;
import org.springframework.messaging.simp.stomp.StompSessionHandlerAdapter;
import org.springframework.util.Assert;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.web.socket.client.WebSocketClient;
import org.springframework.web.socket.client.standard.StandardWebSocketClient;
import org.springframework.web.socket.messaging.WebSocketStompClient;
import org.springframework.web.socket.sockjs.client.SockJsClient;
import org.springframework.web.socket.sockjs.client.WebSocketTransport;

public class TigerRemoteProxyClient
extends AbstractTigerProxy
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerRemoteProxyClient.class);
    public static final String WS_TRACING = "/topic/traces";
    public static final String WS_DATA = "/topic/data";
    public static final String WS_ERRORS = "/topic/errors";
    private final String remoteProxyUrl;
    private final WebSocketStompClient tigerProxyStompClient;
    private final List<TigerExceptionDto> receivedRemoteExceptions = new ArrayList<TigerExceptionDto>();
    private final Map<String, PartialTracingMessage> partiallyReceivedMessageMap = new HashMap<String, PartialTracingMessage>();

    public TigerRemoteProxyClient(String remoteProxyUrl) {
        this(remoteProxyUrl, new TigerProxyConfiguration());
    }

    public TigerRemoteProxyClient(String remoteProxyUrl, TigerProxyConfiguration configuration) {
        super(configuration);
        String tracingWebSocketUrl = remoteProxyUrl.replaceFirst("http", "ws") + "/tracing";
        this.remoteProxyUrl = remoteProxyUrl;
        WebSocketContainer container = ContainerProvider.getWebSocketContainer();
        container.setDefaultMaxBinaryMessageBufferSize(0x100000 * configuration.getPerMessageBufferSizeInMb());
        container.setDefaultMaxTextMessageBufferSize(0x100000 * configuration.getPerMessageBufferSizeInMb());
        SockJsClient webSocketClient = new SockJsClient(List.of(new WebSocketTransport((WebSocketClient)new StandardWebSocketClient(container))));
        webSocketClient.stop();
        MappingJackson2MessageConverter messageConverter = new MappingJackson2MessageConverter();
        messageConverter.getObjectMapper().registerModule((Module)new JavaTimeModule());
        this.tigerProxyStompClient = new WebSocketStompClient((WebSocketClient)webSocketClient);
        this.tigerProxyStompClient.setMessageConverter((MessageConverter)messageConverter);
        this.tigerProxyStompClient.setInboundMessageSizeLimit(0x100000 * configuration.getStompClientBufferSizeInMb());
        TigerStompSessionHandler tigerStompSessionHandler = new TigerStompSessionHandler(remoteProxyUrl);
        ListenableFuture connectFuture = this.tigerProxyStompClient.connect(tracingWebSocketUrl, (StompSessionHandler)tigerStompSessionHandler, new Object[0]);
        connectFuture.addCallback(stompSession -> log.info("Succesfully opened stomp session {} to url", (Object)stompSession.getSessionId(), (Object)tracingWebSocketUrl), throwable -> {
            throw new TigerRemoteProxyClientException("Exception while opening tracing-connection to " + tracingWebSocketUrl, throwable);
        });
        try {
            connectFuture.get((long)configuration.getConnectionTimeoutInSeconds(), TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new TigerRemoteProxyClientException("Exception while opening tracing-connection to " + tracingWebSocketUrl, e);
        }
    }

    @Override
    public TigerRoute addRoute(TigerRoute tigerRoute) {
        return (TigerRoute)Unirest.put((String)(this.remoteProxyUrl + "/route")).body((Object)tigerRoute).contentType("application/json").asObject(TigerRoute.class).ifFailure(response -> {
            throw new TigerRemoteProxyClientException("Unable to add route. Got " + response.getStatus() + ": " + (String)response.mapError(String.class));
        }).getBody();
    }

    @Override
    public void removeRoute(String routeId) {
        Assert.hasText((String)routeId, () -> "No route ID given!");
        Unirest.delete((String)(this.remoteProxyUrl + "/route/" + routeId)).asEmpty().ifFailure(httpResponse -> {
            throw new TigerRemoteProxyClientException("Unable to remove route. Got " + httpResponse);
        });
    }

    @Override
    public String getBaseUrl() {
        return this.remoteProxyUrl;
    }

    @Override
    public int getProxyPort() {
        return 0;
    }

    @Override
    public List<TigerRoute> getRoutes() {
        return (List)Unirest.get((String)(this.remoteProxyUrl + "/route")).asObject((GenericType)new GenericType<List<TigerRoute>>(){}).ifFailure(response -> {
            throw new TigerRemoteProxyClientException("Unable to get routes. Got " + response.getStatus() + ": " + (String)response.mapError(String.class));
        }).getBody();
    }

    @Override
    public RbelModificationDescription addModificaton(RbelModificationDescription modification) {
        return (RbelModificationDescription)Unirest.put((String)(this.remoteProxyUrl + "/modification")).body((Object)modification).contentType("application/json").asObject(RbelModificationDescription.class).ifFailure(response -> {
            throw new TigerRemoteProxyClientException("Unable to add modification. Got " + response.getStatus() + ": " + (String)response.mapError(String.class));
        }).getBody();
    }

    @Override
    public List<RbelModificationDescription> getModifications() {
        return (List)Unirest.get((String)(this.remoteProxyUrl + "/modification")).asObject((GenericType)new GenericType<List<RbelModificationDescription>>(){}).ifFailure(response -> {
            throw new TigerRemoteProxyClientException("Unable to get modifications. Got " + response.getStatus() + ": " + (String)response.mapError(String.class));
        }).getBody();
    }

    @Override
    public void removeModification(String modificationName) {
        Assert.hasText((String)modificationName, () -> "No modification name given!");
        Unirest.delete((String)(this.remoteProxyUrl + "/modification/" + modificationName)).asEmpty().ifFailure(httpResponse -> {
            throw new TigerRemoteProxyClientException("Unable to remove modification. Got " + httpResponse);
        });
    }

    private Optional<RbelElement> buildNewRbelMessage(RbelHostname sender, RbelHostname receiver, byte[] messageBytes, Optional<ZonedDateTime> transmissionTime) {
        if (messageBytes != null) {
            log.info("Received new message...", (Object)new String(messageBytes));
            RbelElement rbelMessage = this.getRbelLogger().getRbelConverter().parseMessage(messageBytes, sender, receiver);
            transmissionTime.ifPresent(zonedDateTime -> rbelMessage.addFacet((RbelFacet)new RbelMessageTimingFacet(zonedDateTime)));
            return Optional.of(rbelMessage);
        }
        log.warn("Received message with content 'null'. Skipping parsing...");
        return Optional.empty();
    }

    private void propagateMessage(RbelElement rbelMessage) {
        if (this.messageMatchesFilterCriterion(rbelMessage)) {
            super.triggerListener(rbelMessage);
        } else {
            this.getRbelLogger().getMessageHistory().remove(rbelMessage);
        }
    }

    private boolean messageMatchesFilterCriterion(RbelElement rbelMessage) {
        if (StringUtils.isEmpty((CharSequence)this.getTigerProxyConfiguration().getTrafficEndpointFilterString())) {
            return true;
        }
        return new RbelJexlExecutor().matchesAsJexlExpression((Object)rbelMessage, this.getTigerProxyConfiguration().getTrafficEndpointFilterString(), Optional.empty());
    }

    public void unsubscribe() {
        this.tigerProxyStompClient.stop();
    }

    @Override
    public void close() {
        this.unsubscribe();
    }

    @Generated
    public List<TigerExceptionDto> getReceivedRemoteExceptions() {
        return this.receivedRemoteExceptions;
    }

    public class TracingMessagePair {
        private PartialTracingMessage request;
        private PartialTracingMessage response;

        public void checkForCompletePairAndPropagateIfComplete() {
            if (this.request != null && this.response != null && this.request.isComplete() && this.response.isComplete()) {
                Optional<RbelElement> requestParsed = TigerRemoteProxyClient.this.buildNewRbelMessage(this.request.getSender(), this.request.getReceiver(), this.request.buildCompleteContent(), Optional.ofNullable(this.request.getTransmissionTime()));
                Optional<RbelElement> responseParsed = TigerRemoteProxyClient.this.buildNewRbelMessage(this.response.getSender(), this.response.getReceiver(), this.response.buildCompleteContent(), Optional.ofNullable(this.response.getTransmissionTime()));
                if (requestParsed.isEmpty() || responseParsed.isEmpty()) {
                    return;
                }
                TracingMessagePairFacet pairFacet = TracingMessagePairFacet.builder().response(responseParsed.get()).request(requestParsed.get()).build();
                responseParsed.get().addFacet((RbelFacet)pairFacet);
                requestParsed.get().addFacet((RbelFacet)pairFacet);
                TigerRemoteProxyClient.this.propagateMessage(requestParsed.get());
                TigerRemoteProxyClient.this.propagateMessage(responseParsed.get());
            }
        }

        @Generated
        public TracingMessagePair() {
        }

        @Generated
        public PartialTracingMessage getRequest() {
            return this.request;
        }

        @Generated
        public PartialTracingMessage getResponse() {
            return this.response;
        }

        @Generated
        public void setRequest(PartialTracingMessage request) {
            this.request = request;
        }

        @Generated
        public void setResponse(PartialTracingMessage response) {
            this.response = response;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TracingMessagePair)) {
                return false;
            }
            TracingMessagePair other = (TracingMessagePair)o;
            if (!other.canEqual(this)) {
                return false;
            }
            PartialTracingMessage this$request = this.getRequest();
            PartialTracingMessage other$request = other.getRequest();
            if (this$request == null ? other$request != null : !((Object)this$request).equals(other$request)) {
                return false;
            }
            PartialTracingMessage this$response = this.getResponse();
            PartialTracingMessage other$response = other.getResponse();
            return !(this$response == null ? other$response != null : !((Object)this$response).equals(other$response));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TracingMessagePair;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            PartialTracingMessage $request = this.getRequest();
            result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
            PartialTracingMessage $response = this.getResponse();
            result = result * 59 + ($response == null ? 43 : ((Object)$response).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TigerRemoteProxyClient.TracingMessagePair(request=" + this.getRequest() + ", response=" + this.getResponse() + ")";
        }
    }

    private static class PartialTracingMessage {
        private final TigerTracingDto tracingDto;
        private final RbelHostname sender;
        private final RbelHostname receiver;
        private final TracingMessagePair messagePair;
        private final ZonedDateTime transmissionTime;
        private final List<TracingMessagePart> messageParts = new ArrayList<TracingMessagePart>();

        public boolean isComplete() {
            return !this.messageParts.isEmpty() && this.messageParts.get(0).getNumberOfMessages() == this.messageParts.size();
        }

        public byte[] buildCompleteContent() {
            byte[] result = new byte[this.messageParts.stream().map(TracingMessagePart::getData).mapToInt(Array::getLength).sum()];
            int resultIndex = 0;
            for (int i = 0; i < this.messageParts.size(); ++i) {
                System.arraycopy(this.messageParts.get(i).getData(), 0, result, resultIndex, this.messageParts.get(i).getData().length);
                resultIndex += this.messageParts.get(i).getData().length;
            }
            return result;
        }

        @ConstructorProperties(value={"tracingDto", "sender", "receiver", "messagePair", "transmissionTime"})
        @Generated
        PartialTracingMessage(TigerTracingDto tracingDto, RbelHostname sender, RbelHostname receiver, TracingMessagePair messagePair, ZonedDateTime transmissionTime) {
            this.tracingDto = tracingDto;
            this.sender = sender;
            this.receiver = receiver;
            this.messagePair = messagePair;
            this.transmissionTime = transmissionTime;
        }

        @Generated
        public static PartialTracingMessageBuilder builder() {
            return new PartialTracingMessageBuilder();
        }

        @Generated
        public TigerTracingDto getTracingDto() {
            return this.tracingDto;
        }

        @Generated
        public RbelHostname getSender() {
            return this.sender;
        }

        @Generated
        public RbelHostname getReceiver() {
            return this.receiver;
        }

        @Generated
        public TracingMessagePair getMessagePair() {
            return this.messagePair;
        }

        @Generated
        public ZonedDateTime getTransmissionTime() {
            return this.transmissionTime;
        }

        @Generated
        public List<TracingMessagePart> getMessageParts() {
            return this.messageParts;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PartialTracingMessage)) {
                return false;
            }
            PartialTracingMessage other = (PartialTracingMessage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            TigerTracingDto this$tracingDto = this.getTracingDto();
            TigerTracingDto other$tracingDto = other.getTracingDto();
            if (this$tracingDto == null ? other$tracingDto != null : !((Object)this$tracingDto).equals(other$tracingDto)) {
                return false;
            }
            RbelHostname this$sender = this.getSender();
            RbelHostname other$sender = other.getSender();
            if (this$sender == null ? other$sender != null : !this$sender.equals(other$sender)) {
                return false;
            }
            RbelHostname this$receiver = this.getReceiver();
            RbelHostname other$receiver = other.getReceiver();
            if (this$receiver == null ? other$receiver != null : !this$receiver.equals(other$receiver)) {
                return false;
            }
            TracingMessagePair this$messagePair = this.getMessagePair();
            TracingMessagePair other$messagePair = other.getMessagePair();
            if (this$messagePair == null ? other$messagePair != null : !((Object)this$messagePair).equals(other$messagePair)) {
                return false;
            }
            ZonedDateTime this$transmissionTime = this.getTransmissionTime();
            ZonedDateTime other$transmissionTime = other.getTransmissionTime();
            if (this$transmissionTime == null ? other$transmissionTime != null : !((Object)this$transmissionTime).equals(other$transmissionTime)) {
                return false;
            }
            List<TracingMessagePart> this$messageParts = this.getMessageParts();
            List<TracingMessagePart> other$messageParts = other.getMessageParts();
            return !(this$messageParts == null ? other$messageParts != null : !((Object)this$messageParts).equals(other$messageParts));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PartialTracingMessage;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TigerTracingDto $tracingDto = this.getTracingDto();
            result = result * 59 + ($tracingDto == null ? 43 : ((Object)$tracingDto).hashCode());
            RbelHostname $sender = this.getSender();
            result = result * 59 + ($sender == null ? 43 : $sender.hashCode());
            RbelHostname $receiver = this.getReceiver();
            result = result * 59 + ($receiver == null ? 43 : $receiver.hashCode());
            TracingMessagePair $messagePair = this.getMessagePair();
            result = result * 59 + ($messagePair == null ? 43 : ((Object)$messagePair).hashCode());
            ZonedDateTime $transmissionTime = this.getTransmissionTime();
            result = result * 59 + ($transmissionTime == null ? 43 : ((Object)$transmissionTime).hashCode());
            List<TracingMessagePart> $messageParts = this.getMessageParts();
            result = result * 59 + ($messageParts == null ? 43 : ((Object)$messageParts).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TigerRemoteProxyClient.PartialTracingMessage(tracingDto=" + this.getTracingDto() + ", sender=" + this.getSender() + ", receiver=" + this.getReceiver() + ", messagePair=" + this.getMessagePair() + ", transmissionTime=" + this.getTransmissionTime() + ", messageParts=" + this.getMessageParts() + ")";
        }

        @Generated
        public static class PartialTracingMessageBuilder {
            @Generated
            private TigerTracingDto tracingDto;
            @Generated
            private RbelHostname sender;
            @Generated
            private RbelHostname receiver;
            @Generated
            private TracingMessagePair messagePair;
            @Generated
            private ZonedDateTime transmissionTime;

            @Generated
            PartialTracingMessageBuilder() {
            }

            @Generated
            public PartialTracingMessageBuilder tracingDto(TigerTracingDto tracingDto) {
                this.tracingDto = tracingDto;
                return this;
            }

            @Generated
            public PartialTracingMessageBuilder sender(RbelHostname sender) {
                this.sender = sender;
                return this;
            }

            @Generated
            public PartialTracingMessageBuilder receiver(RbelHostname receiver) {
                this.receiver = receiver;
                return this;
            }

            @Generated
            public PartialTracingMessageBuilder messagePair(TracingMessagePair messagePair) {
                this.messagePair = messagePair;
                return this;
            }

            @Generated
            public PartialTracingMessageBuilder transmissionTime(ZonedDateTime transmissionTime) {
                this.transmissionTime = transmissionTime;
                return this;
            }

            @Generated
            public PartialTracingMessage build() {
                return new PartialTracingMessage(this.tracingDto, this.sender, this.receiver, this.messagePair, this.transmissionTime);
            }

            @Generated
            public String toString() {
                return "TigerRemoteProxyClient.PartialTracingMessage.PartialTracingMessageBuilder(tracingDto=" + this.tracingDto + ", sender=" + this.sender + ", receiver=" + this.receiver + ", messagePair=" + this.messagePair + ", transmissionTime=" + this.transmissionTime + ")";
            }
        }
    }

    private class TigerStompSessionHandler
    extends StompSessionHandlerAdapter {
        private final String remoteProxyUrl;

        public void afterConnected(StompSession stompSession, StompHeaders stompHeaders) {
            log.info("Connecting to tracing point {}", (Object)this.remoteProxyUrl);
            stompSession.subscribe(TigerRemoteProxyClient.WS_TRACING, new StompFrameHandler(){

                public Type getPayloadType(StompHeaders stompHeaders) {
                    return TigerTracingDto.class;
                }

                public void handleFrame(StompHeaders stompHeaders, Object frameContent) {
                    if (frameContent instanceof TigerTracingDto) {
                        TigerTracingDto tigerTracingDto = (TigerTracingDto)frameContent;
                        TracingMessagePair messagePair = new TracingMessagePair();
                        messagePair.setRequest(PartialTracingMessage.builder().tracingDto(tigerTracingDto).receiver(tigerTracingDto.getSender()).sender(tigerTracingDto.getReceiver()).messagePair(messagePair).transmissionTime(tigerTracingDto.getRequestTransmissionTime()).build());
                        messagePair.setResponse(PartialTracingMessage.builder().tracingDto(tigerTracingDto).receiver(tigerTracingDto.getReceiver()).sender(tigerTracingDto.getSender()).messagePair(messagePair).transmissionTime(tigerTracingDto.getResponseTransmissionTime()).build());
                        TigerRemoteProxyClient.this.partiallyReceivedMessageMap.put(tigerTracingDto.getRequestUuid(), messagePair.getRequest());
                        TigerRemoteProxyClient.this.partiallyReceivedMessageMap.put(tigerTracingDto.getResponseUuid(), messagePair.getResponse());
                    }
                }
            });
            stompSession.subscribe(TigerRemoteProxyClient.WS_DATA, new StompFrameHandler(){

                public Type getPayloadType(StompHeaders stompHeaders) {
                    return TracingMessagePart.class;
                }

                public void handleFrame(StompHeaders stompHeaders, Object frameContent) {
                    if (frameContent instanceof TracingMessagePart) {
                        TracingMessagePart tracingMessagePart = (TracingMessagePart)frameContent;
                        log.trace("Received part {} of {} for UUID {}", new Object[]{tracingMessagePart.getIndex(), tracingMessagePart.getNumberOfMessages(), tracingMessagePart.getUuid()});
                        if (!TigerRemoteProxyClient.this.partiallyReceivedMessageMap.containsKey(tracingMessagePart.getUuid())) {
                            log.error("Received stray message part with UUID {}", (Object)tracingMessagePart.getUuid());
                        } else {
                            PartialTracingMessage tracingMessage = TigerRemoteProxyClient.this.partiallyReceivedMessageMap.get(tracingMessagePart.getUuid());
                            tracingMessage.getMessageParts().add(tracingMessagePart);
                            if (tracingMessage.isComplete()) {
                                tracingMessage.getMessagePair().checkForCompletePairAndPropagateIfComplete();
                                TigerRemoteProxyClient.this.partiallyReceivedMessageMap.remove(tracingMessagePart.getUuid());
                            }
                        }
                    }
                }
            });
            stompSession.subscribe(TigerRemoteProxyClient.WS_ERRORS, new StompFrameHandler(){

                public Type getPayloadType(StompHeaders stompHeaders) {
                    return TigerExceptionDto.class;
                }

                public void handleFrame(StompHeaders stompHeaders, Object frameContent) {
                    if (frameContent instanceof TigerExceptionDto) {
                        TigerExceptionDto exceptionDto = (TigerExceptionDto)frameContent;
                        log.warn("Received remote exception: ({}) {}: {} ", new Object[]{exceptionDto.getClassName(), exceptionDto.getMessage(), exceptionDto.getStacktrace()});
                        TigerRemoteProxyClient.this.receivedRemoteExceptions.add(exceptionDto);
                    }
                }
            });
        }

        public void handleException(StompSession stompSession, StompCommand stompCommand, StompHeaders stompHeaders, byte[] bytes, Throwable throwable) {
            log.error("handle exception with remote url '{}': {}, {}", new Object[]{this.remoteProxyUrl, new String(bytes), throwable});
            throw new TigerRemoteProxyClientException(throwable);
        }

        public void handleTransportError(StompSession session, Throwable exception) {
            if (!(exception instanceof ConnectionLostException)) {
                log.error("handle transport error from url '{}': {}", (Object)this.remoteProxyUrl, (Object)exception);
                throw new TigerRemoteProxyClientException(exception);
            }
            log.warn("Remote client lost connection to url {}", (Object)this.remoteProxyUrl);
        }

        @ConstructorProperties(value={"remoteProxyUrl"})
        @Generated
        public TigerStompSessionHandler(String remoteProxyUrl) {
            this.remoteProxyUrl = remoteProxyUrl;
        }
    }
}

