/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelFacet;
import de.gematik.test.tiger.common.data.config.tigerProxy.TigerProxyConfiguration;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.proxy.configuration.ApplicationConfiguration;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import lombok.Generated;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;

@SpringBootApplication
public class TigerProxyApplication
implements ServletContextListener {
    private final ApplicationConfiguration applicationConfiguration;
    private TigerProxy tigerProxy;

    public static void main(String[] args) {
        System.setProperty("java.util.logging.config.file", "SKIP_MOCKSERVER_LOG_INIT!");
        SpringApplication.run(TigerProxyApplication.class, (String[])args);
    }

    @Bean
    public TigerProxy tigerProxy() {
        this.tigerProxy = new TigerProxy(Objects.requireNonNullElseGet(this.applicationConfiguration, TigerProxyConfiguration::new));
        return this.tigerProxy;
    }

    @Bean
    public SimpleModule rbelElementDeserializer() {
        SimpleModule module = new SimpleModule();
        module.addSerializer(RbelElement.class, (JsonSerializer)new JsonSerializer<RbelElement>(){

            public void serialize(RbelElement value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeStartObject();
                gen.writeStringField("uuid", value.getUuid());
                gen.writeArrayFieldStart("facets");
                for (RbelFacet facet : value.getFacets()) {
                    gen.writeString(facet.getClass().getSimpleName());
                }
                gen.writeEndArray();
                gen.writeEndObject();
            }
        });
        return module;
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (this.tigerProxy != null) {
            this.tigerProxy.shutdown();
        }
    }

    @ConstructorProperties(value={"applicationConfiguration"})
    @Generated
    public TigerProxyApplication(ApplicationConfiguration applicationConfiguration) {
        this.applicationConfiguration = applicationConfiguration;
    }

    @Generated
    public ApplicationConfiguration getApplicationConfiguration() {
        return this.applicationConfiguration;
    }
}

