/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.client;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelHostname;
import de.gematik.test.tiger.common.config.tigerProxy.TigerProxyConfiguration;
import de.gematik.test.tiger.common.config.tigerProxy.TigerRoute;
import de.gematik.test.tiger.proxy.AbstractTigerProxy;
import de.gematik.test.tiger.proxy.client.TigerExceptionDto;
import de.gematik.test.tiger.proxy.client.TigerRemoteProxyClientException;
import de.gematik.test.tiger.proxy.client.TigerTracingDto;
import de.gematik.test.tiger.proxy.client.TracingMessage;
import java.beans.ConstructorProperties;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.websocket.ContainerProvider;
import javax.websocket.WebSocketContainer;
import kong.unirest.GenericType;
import kong.unirest.Unirest;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.messaging.simp.stomp.StompFrameHandler;
import org.springframework.messaging.simp.stomp.StompHeaders;
import org.springframework.messaging.simp.stomp.StompSession;
import org.springframework.messaging.simp.stomp.StompSessionHandler;
import org.springframework.messaging.simp.stomp.StompSessionHandlerAdapter;
import org.springframework.util.Assert;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.web.socket.client.WebSocketClient;
import org.springframework.web.socket.client.standard.StandardWebSocketClient;
import org.springframework.web.socket.messaging.WebSocketStompClient;
import org.springframework.web.socket.sockjs.client.SockJsClient;
import org.springframework.web.socket.sockjs.client.WebSocketTransport;

public class TigerRemoteProxyClient
extends AbstractTigerProxy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerRemoteProxyClient.class);
    public static final String WS_TRACING = "/topic/traces";
    public static final String WS_ERRORS = "/topic/errors";
    private final String remoteProxyUrl;
    private final WebSocketStompClient tigerProxyStompClient;
    private final List<TigerExceptionDto> receivedRemoteExceptions = new ArrayList<TigerExceptionDto>();

    public TigerRemoteProxyClient(String remoteProxyUrl, TigerProxyConfiguration configuration) {
        super(configuration);
        String tracingWebSocketUrl = remoteProxyUrl.replaceFirst("http", "ws") + "/tracing";
        this.remoteProxyUrl = remoteProxyUrl;
        WebSocketContainer container = ContainerProvider.getWebSocketContainer();
        container.setDefaultMaxBinaryMessageBufferSize(0x100000 * configuration.getPerMessageBufferSizeInMb());
        container.setDefaultMaxTextMessageBufferSize(0x100000 * configuration.getPerMessageBufferSizeInMb());
        SockJsClient webSocketClient = new SockJsClient(List.of(new WebSocketTransport((WebSocketClient)new StandardWebSocketClient(container))));
        this.tigerProxyStompClient = new WebSocketStompClient((WebSocketClient)webSocketClient);
        this.tigerProxyStompClient.setMessageConverter((MessageConverter)new MappingJackson2MessageConverter());
        this.tigerProxyStompClient.setInboundMessageSizeLimit(0x100000 * configuration.getStompClientBufferSizeInMb());
        TigerStompSessionHandler tigerStompSessionHandler = new TigerStompSessionHandler(remoteProxyUrl);
        ListenableFuture connectFuture = this.tigerProxyStompClient.connect(tracingWebSocketUrl, (StompSessionHandler)tigerStompSessionHandler, new Object[0]);
        connectFuture.addCallback(stompSession -> log.info("Succesfully opened stomp session {} to url", (Object)stompSession.getSessionId(), (Object)tracingWebSocketUrl), throwable -> {
            throw new TigerRemoteProxyClientException("Exception while opening tracing-connection to " + tracingWebSocketUrl, throwable);
        });
        try {
            connectFuture.get((long)configuration.getConnectionTimeoutInSeconds(), TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new TigerRemoteProxyClientException("Exception while opening tracing-connection to " + tracingWebSocketUrl, e);
        }
    }

    @Override
    public TigerRoute addRoute(TigerRoute tigerRoute) {
        return (TigerRoute)Unirest.put((String)(this.remoteProxyUrl + "/route")).body((Object)tigerRoute).contentType("application/json").asObject(TigerRoute.class).ifFailure(response -> {
            throw new TigerRemoteProxyClientException("Unable to add route. Got " + response.getStatus() + ": " + (String)response.mapError(String.class));
        }).getBody();
    }

    @Override
    public void removeRoute(String routeId) {
        Assert.hasText((String)routeId, () -> "No route ID given!");
        Unirest.delete((String)(this.remoteProxyUrl + "/route/" + routeId)).asEmpty().ifFailure(httpResponse -> {
            throw new TigerRemoteProxyClientException("Unable to add route. Got " + httpResponse);
        });
    }

    @Override
    public String getBaseUrl() {
        return this.remoteProxyUrl;
    }

    @Override
    public int getPort() {
        return 0;
    }

    @Override
    public List<TigerRoute> getRoutes() {
        return (List)Unirest.get((String)(this.remoteProxyUrl + "/route")).asObject((GenericType)new GenericType<List<TigerRoute>>(){}).ifFailure(response -> {
            throw new TigerRemoteProxyClientException("Unable to get routes. Got " + response.getStatus() + ": " + (String)response.mapError(String.class));
        }).getBody();
    }

    private void propagateNewRbelMessage(RbelHostname sender, RbelHostname receiver, TracingMessage tracingMessage) {
        byte[] messageBytes = tracingMessage.getRawContent();
        if (messageBytes != null) {
            log.info("Received new message {}", (Object)new String(messageBytes));
            RbelElement rbelMessage = this.getRbelLogger().getRbelConverter().parseMessage(messageBytes, sender, receiver);
            super.triggerListener(rbelMessage);
        } else {
            log.warn("Received message with content 'null'. Skipping parsing...");
        }
    }

    @Generated
    public List<TigerExceptionDto> getReceivedRemoteExceptions() {
        return this.receivedRemoteExceptions;
    }

    private class TigerReceivedRemoteException
    extends RuntimeException {
        public TigerReceivedRemoteException(String message) {
            super(message);
        }
    }

    private class TigerStompSessionHandler
    extends StompSessionHandlerAdapter {
        private final String remoteProxyUrl;

        public void afterConnected(StompSession stompSession, StompHeaders stompHeaders) {
            log.info("Connecting to tracing point {}", (Object)this.remoteProxyUrl);
            stompSession.subscribe(TigerRemoteProxyClient.WS_TRACING, new StompFrameHandler(){

                public Type getPayloadType(StompHeaders stompHeaders) {
                    return TigerTracingDto.class;
                }

                public void handleFrame(StompHeaders stompHeaders, Object frameContent) {
                    if (frameContent instanceof TigerTracingDto) {
                        TigerTracingDto tigerTracingDto = (TigerTracingDto)frameContent;
                        TigerRemoteProxyClient.this.propagateNewRbelMessage(tigerTracingDto.getSender(), tigerTracingDto.getReceiver(), tigerTracingDto.getRequest());
                        TigerRemoteProxyClient.this.propagateNewRbelMessage(tigerTracingDto.getReceiver(), tigerTracingDto.getSender(), tigerTracingDto.getResponse());
                    }
                }
            });
            stompSession.subscribe(TigerRemoteProxyClient.WS_ERRORS, new StompFrameHandler(){

                public Type getPayloadType(StompHeaders stompHeaders) {
                    return TigerExceptionDto.class;
                }

                public void handleFrame(StompHeaders stompHeaders, Object frameContent) {
                    if (frameContent instanceof TigerExceptionDto) {
                        TigerExceptionDto exceptionDto = (TigerExceptionDto)frameContent;
                        log.warn("Received remote exception: ({}) {}: {} ", new Object[]{exceptionDto.getClassName(), exceptionDto.getMessage(), exceptionDto.getStacktrace()});
                        TigerRemoteProxyClient.this.receivedRemoteExceptions.add(exceptionDto);
                    }
                }
            });
        }

        public void handleException(StompSession stompSession, StompCommand stompCommand, StompHeaders stompHeaders, byte[] bytes, Throwable throwable) {
            log.error("handle exception TigerRemoteProxy: {}, {}", (Object)new String(bytes), (Object)throwable);
            throw new TigerRemoteProxyClientException(throwable);
        }

        public void handleTransportError(StompSession session, Throwable exception) {
            log.error("handle transport Error TigerRemoteProxy: {}", exception);
            throw new TigerRemoteProxyClientException(exception);
        }

        @ConstructorProperties(value={"remoteProxyUrl"})
        @Generated
        public TigerStompSessionHandler(String remoteProxyUrl) {
            this.remoteProxyUrl = remoteProxyUrl;
        }
    }
}

