/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy;

import de.gematik.test.tiger.common.config.tigerProxy.TigerTlsConfiguration;
import de.gematik.test.tiger.common.pki.TigerPkiIdentity;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import lombok.Generated;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.bc.BcX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.util.IPAddress;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.socket.tls.bouncycastle.BCKeyAndCertificateFactory;
import org.mockserver.socket.tls.jdk.CertificateSigningRequest;
import org.slf4j.event.Level;

public class TigerKeyAndCertificateFactory
extends BCKeyAndCertificateFactory {
    private final TigerPkiIdentity caIdentity;
    private final MockServerLogger mockServerLogger;
    private final List<X509Certificate> certificateChain = new ArrayList<X509Certificate>();
    private final String serverName;
    private final List<String> serverAlternativeNames;
    private TigerPkiIdentity eeIdentity;
    private boolean canEeIdentityBeReset;

    public TigerKeyAndCertificateFactory(MockServerLogger mockServerLogger, TigerPkiIdentity caIdentity, TigerPkiIdentity eeIdentity, TigerTlsConfiguration tls) {
        super(mockServerLogger);
        this.mockServerLogger = mockServerLogger;
        this.caIdentity = caIdentity;
        this.eeIdentity = eeIdentity;
        this.serverName = tls.getDomainName();
        this.serverAlternativeNames = new ArrayList<String>();
        if (tls.getAlternativeNames() != null) {
            this.serverAlternativeNames.addAll(tls.getAlternativeNames());
        }
        this.canEeIdentityBeReset = eeIdentity == null;
    }

    public boolean certificateAuthorityCertificateNotYetCreated() {
        return false;
    }

    public X509Certificate certificateAuthorityX509Certificate() {
        if (this.caIdentity != null) {
            return this.caIdentity.getCertificate();
        }
        if (this.eeIdentity.getCertificateChain() != null && this.eeIdentity.getCertificateChain().size() > 0) {
            return (X509Certificate)this.eeIdentity.getCertificateChain().get(0);
        }
        return null;
    }

    public PrivateKey privateKey() {
        return this.eeIdentity.getPrivateKey();
    }

    public X509Certificate x509Certificate() {
        return this.eeIdentity.getCertificate();
    }

    public void buildAndSavePrivateKeyAndX509Certificate() {
        try {
            if (this.eeIdentity == null) {
                KeyPair keyPair = this.generateRsaKeyPair(2048);
                X509Certificate x509Certificate = this.createCertificateSignedByCa(keyPair.getPublic(), this.caIdentity.getCertificate(), this.caIdentity.getPrivateKey(), this.caIdentity.getCertificate().getPublicKey());
                this.eeIdentity = new TigerPkiIdentity(x509Certificate, keyPair.getPrivate());
                this.certificateChain.add(x509Certificate);
                this.certificateChain.add(this.caIdentity.getCertificate());
            } else if (this.certificateChain.isEmpty()) {
                this.certificateChain.add(this.eeIdentity.getCertificate());
                this.certificateChain.addAll(this.eeIdentity.getCertificateChain());
            }
            if (MockServerLogger.isEnabled((Level)Level.TRACE)) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("created new X509 {} with SAN Domain Names {} and IPs {}").setArguments(new Object[]{this.x509Certificate(), Arrays.toString(ConfigurationProperties.sslSubjectAlternativeNameDomains()), Arrays.toString(ConfigurationProperties.sslSubjectAlternativeNameIps())}));
            }
        }
        catch (Exception e) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while generating private key and X509 certificate").setThrowable((Throwable)e));
        }
    }

    public List<X509Certificate> certificateChain() {
        return this.certificateChain;
    }

    private X509Certificate createCertificateSignedByCa(PublicKey publicKey, X509Certificate certificateAuthorityCert, PrivateKey certificateAuthorityPrivateKey, PublicKey certificateAuthorityPublicKey) throws Exception {
        X500Name issuer = new X509CertificateHolder(certificateAuthorityCert.getEncoded()).getSubject();
        X500Name subject = new X500Name("CN=" + this.serverName + ", O=Gematik, L=Berlin, ST=Berlin, C=DE");
        BigInteger serial = BigInteger.valueOf(new Random().nextInt(Integer.MAX_VALUE));
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(issuer, serial, CertificateSigningRequest.NOT_BEFORE, CertificateSigningRequest.NOT_AFTER, subject, publicKey);
        builder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)this.createNewSubjectKeyIdentifier(publicKey));
        builder.addExtension(Extension.basicConstraints, false, (ASN1Encodable)new BasicConstraints(false));
        if (this.serverAlternativeNames.size() > 0) {
            DERSequence subjectAlternativeNamesExtension = new DERSequence((ASN1Encodable[])Stream.concat(this.serverAlternativeNames.stream(), Stream.of(this.serverName)).distinct().map(this::mapAlternativeNameToAsn1Encodable).toArray(ASN1Encodable[]::new));
            builder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)subjectAlternativeNamesExtension);
        }
        return this.signTheCertificate((X509v3CertificateBuilder)builder, certificateAuthorityPrivateKey);
    }

    private ASN1Encodable mapAlternativeNameToAsn1Encodable(String alternativeName) {
        if (IPAddress.isValidIPv6WithNetmask((String)alternativeName) || IPAddress.isValidIPv6((String)alternativeName) || IPAddress.isValidIPv4WithNetmask((String)alternativeName) || IPAddress.isValidIPv4((String)alternativeName)) {
            return new GeneralName(7, alternativeName);
        }
        return new GeneralName(2, alternativeName);
    }

    private X509Certificate signTheCertificate(X509v3CertificateBuilder certificateBuilder, PrivateKey privateKey) throws OperatorCreationException, CertificateException {
        if (privateKey instanceof RSAPrivateKey) {
            ContentSigner signer = new JcaContentSignerBuilder("SHA256WithRSAEncryption").setProvider("BC").build(privateKey);
            return new JcaX509CertificateConverter().setProvider("BC").getCertificate(certificateBuilder.build(signer));
        }
        ContentSigner signer = new JcaContentSignerBuilder("SHA256withECDSA").setProvider("BC").build(privateKey);
        return new JcaX509CertificateConverter().setProvider("BC").getCertificate(certificateBuilder.build(signer));
    }

    private KeyPair generateRsaKeyPair(int keySize) throws Exception {
        KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA", "BC");
        generator.initialize(keySize, new SecureRandom());
        return generator.generateKeyPair();
    }

    private SubjectKeyIdentifier createNewSubjectKeyIdentifier(Key key) throws IOException {
        try (ASN1InputStream is = new ASN1InputStream((InputStream)new ByteArrayInputStream(key.getEncoded()));){
            ASN1Sequence seq = (ASN1Sequence)is.readObject();
            SubjectPublicKeyInfo info = SubjectPublicKeyInfo.getInstance((Object)seq);
            SubjectKeyIdentifier subjectKeyIdentifier = new BcX509ExtensionUtils().createSubjectKeyIdentifier(info);
            return subjectKeyIdentifier;
        }
    }

    public boolean certificateNotYetCreated() {
        return this.eeIdentity == null;
    }

    public void resetEeCertificate() {
        if (this.canEeIdentityBeReset) {
            this.eeIdentity = null;
        }
    }

    public void addAlternativeName(String host) {
        this.serverAlternativeNames.add(host);
    }

    @Generated
    public static TigerKeyAndCertificateFactoryBuilder builder() {
        return new TigerKeyAndCertificateFactoryBuilder();
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    @Generated
    public static class TigerKeyAndCertificateFactoryBuilder {
        @Generated
        private MockServerLogger mockServerLogger;
        @Generated
        private TigerPkiIdentity caIdentity;
        @Generated
        private TigerPkiIdentity eeIdentity;
        @Generated
        private TigerTlsConfiguration tls;

        @Generated
        TigerKeyAndCertificateFactoryBuilder() {
        }

        @Generated
        public TigerKeyAndCertificateFactoryBuilder mockServerLogger(MockServerLogger mockServerLogger) {
            this.mockServerLogger = mockServerLogger;
            return this;
        }

        @Generated
        public TigerKeyAndCertificateFactoryBuilder caIdentity(TigerPkiIdentity caIdentity) {
            this.caIdentity = caIdentity;
            return this;
        }

        @Generated
        public TigerKeyAndCertificateFactoryBuilder eeIdentity(TigerPkiIdentity eeIdentity) {
            this.eeIdentity = eeIdentity;
            return this;
        }

        @Generated
        public TigerKeyAndCertificateFactoryBuilder tls(TigerTlsConfiguration tls) {
            this.tls = tls;
            return this;
        }

        @Generated
        public TigerKeyAndCertificateFactory build() {
            return new TigerKeyAndCertificateFactory(this.mockServerLogger, this.caIdentity, this.eeIdentity, this.tls);
        }

        @Generated
        public String toString() {
            return "TigerKeyAndCertificateFactory.TigerKeyAndCertificateFactoryBuilder(mockServerLogger=" + this.mockServerLogger + ", caIdentity=" + this.caIdentity + ", eeIdentity=" + this.eeIdentity + ", tls=" + this.tls + ")";
        }
    }
}

