/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy;

import de.gematik.rbellogger.RbelLogger;
import de.gematik.rbellogger.configuration.RbelConfiguration;
import de.gematik.rbellogger.converter.initializers.RbelKeyFolderInitializer;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.key.RbelKey;
import de.gematik.test.tiger.common.config.tigerProxy.TigerProxyConfiguration;
import de.gematik.test.tiger.common.config.tigerProxy.TigerRoute;
import de.gematik.test.tiger.common.pki.KeyMgr;
import de.gematik.test.tiger.exception.TigerProxyStartupException;
import de.gematik.test.tiger.proxy.IRbelMessageListener;
import de.gematik.test.tiger.proxy.ITigerProxy;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTigerProxy
implements ITigerProxy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractTigerProxy.class);
    private static final String FIX_VAU_KEY = "-----BEGIN PRIVATE KEY-----\nMIGIAgEAMBQGByqGSM49AgEGCSskAwMCCAEBBwRtMGsCAQEEIAeOzpSQT8a/mQDM\n7Uxa9NzU++vFhbIFS2Nsw/djM73uoUQDQgAEIfr+3Iuh71R3mVooqXlPhjVd8wXx\n9Yr8iPh+kcZkNTongD49z2cL0wXzuSP5Fb/hGTidhpw1ZYKMib1CIjH59A==\n-----END PRIVATE KEY-----\n";
    private final List<IRbelMessageListener> rbelMessageListeners = new ArrayList<IRbelMessageListener>();
    private final TigerProxyConfiguration tigerProxyConfiguration;
    private RbelLogger rbelLogger;

    public AbstractTigerProxy(TigerProxyConfiguration configuration) {
        if (configuration.getTls() == null) {
            throw new TigerProxyStartupException("no TLS-configuration found!");
        }
        this.rbelLogger = this.buildRbelLoggerConfiguration(configuration).constructRbelLogger();
        if (configuration.isDisableRbelParsing()) {
            this.rbelLogger.getRbelConverter().removeAllConverterPlugins();
        }
        this.addFixVauKey();
        this.tigerProxyConfiguration = configuration;
    }

    private void addFixVauKey() {
        KeyPair keyPair = KeyMgr.readEcdsaKeypairFromPkcs8Pem((byte[])FIX_VAU_KEY.getBytes(StandardCharsets.UTF_8));
        RbelKey rbelPublicVauKey = RbelKey.builder().keyName("fixVauKey_public").key((Key)keyPair.getPublic()).precedence(0).build();
        RbelKey rbelPrivateVauKey = RbelKey.builder().keyName("fixVauKey_public").key((Key)keyPair.getPublic()).precedence(0).matchingPublicKey(Optional.ofNullable(rbelPublicVauKey)).build();
        this.rbelLogger.getRbelKeyManager().addKey(rbelPublicVauKey);
        this.rbelLogger.getRbelKeyManager().addKey(rbelPrivateVauKey);
    }

    private RbelConfiguration buildRbelLoggerConfiguration(TigerProxyConfiguration configuration) {
        RbelConfiguration rbelConfiguration = new RbelConfiguration();
        if (configuration.getKeyFolders() != null) {
            configuration.getKeyFolders().stream().forEach(folder -> rbelConfiguration.addInitializer((Consumer)new RbelKeyFolderInitializer(folder)));
        }
        rbelConfiguration.setFileSaveInfo(configuration.getFileSaveInfo());
        rbelConfiguration.setActivateAsn1Parsing(configuration.isActivateAsn1Parsing());
        return rbelConfiguration;
    }

    @Override
    public List<RbelElement> getRbelMessages() {
        return this.rbelLogger.getMessageHistory();
    }

    @Override
    public void addKey(String keyid, Key key) {
        this.rbelLogger.getRbelKeyManager().addKey(keyid, key, 110);
    }

    public void triggerListener(RbelElement element) {
        this.getRbelMessageListeners().forEach(listener -> listener.triggerNewReceivedMessage(element));
    }

    @Override
    public void addRbelMessageListener(IRbelMessageListener listener) {
        this.rbelMessageListeners.add(listener);
    }

    @Override
    public void clearAllRoutes() {
        this.getRoutes().stream().filter(route -> !route.isInternalRoute()).map(TigerRoute::getId).forEach(this::removeRoute);
    }

    @Override
    public void removeRbelMessageListener(IRbelMessageListener listener) {
        this.rbelMessageListeners.remove(listener);
    }

    @Generated
    public List<IRbelMessageListener> getRbelMessageListeners() {
        return this.rbelMessageListeners;
    }

    @Generated
    public TigerProxyConfiguration getTigerProxyConfiguration() {
        return this.tigerProxyConfiguration;
    }

    @Generated
    public RbelLogger getRbelLogger() {
        return this.rbelLogger;
    }

    @Generated
    public void setRbelLogger(RbelLogger rbelLogger) {
        this.rbelLogger = rbelLogger;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractTigerProxy)) {
            return false;
        }
        AbstractTigerProxy other = (AbstractTigerProxy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<IRbelMessageListener> this$rbelMessageListeners = this.getRbelMessageListeners();
        List<IRbelMessageListener> other$rbelMessageListeners = other.getRbelMessageListeners();
        if (this$rbelMessageListeners == null ? other$rbelMessageListeners != null : !((Object)this$rbelMessageListeners).equals(other$rbelMessageListeners)) {
            return false;
        }
        TigerProxyConfiguration this$tigerProxyConfiguration = this.getTigerProxyConfiguration();
        TigerProxyConfiguration other$tigerProxyConfiguration = other.getTigerProxyConfiguration();
        if (this$tigerProxyConfiguration == null ? other$tigerProxyConfiguration != null : !this$tigerProxyConfiguration.equals(other$tigerProxyConfiguration)) {
            return false;
        }
        RbelLogger this$rbelLogger = this.getRbelLogger();
        RbelLogger other$rbelLogger = other.getRbelLogger();
        return !(this$rbelLogger == null ? other$rbelLogger != null : !this$rbelLogger.equals(other$rbelLogger));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractTigerProxy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<IRbelMessageListener> $rbelMessageListeners = this.getRbelMessageListeners();
        result = result * 59 + ($rbelMessageListeners == null ? 43 : ((Object)$rbelMessageListeners).hashCode());
        TigerProxyConfiguration $tigerProxyConfiguration = this.getTigerProxyConfiguration();
        result = result * 59 + ($tigerProxyConfiguration == null ? 43 : $tigerProxyConfiguration.hashCode());
        RbelLogger $rbelLogger = this.getRbelLogger();
        result = result * 59 + ($rbelLogger == null ? 43 : $rbelLogger.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AbstractTigerProxy(rbelMessageListeners=" + this.getRbelMessageListeners() + ", tigerProxyConfiguration=" + this.getTigerProxyConfiguration() + ", rbelLogger=" + this.getRbelLogger() + ")";
    }
}

