/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.modifier.RbelModificationDescription;
import de.gematik.rbellogger.renderer.RbelHtmlRenderer;
import de.gematik.test.tiger.common.config.tigerProxy.TigerProxyConfiguration;
import de.gematik.test.tiger.common.config.tigerProxy.TigerProxyType;
import de.gematik.test.tiger.common.config.tigerProxy.TigerRoute;
import de.gematik.test.tiger.common.config.tigerProxy.TigerTlsConfiguration;
import de.gematik.test.tiger.common.pki.TigerPkiIdentity;
import de.gematik.test.tiger.exception.TigerProxyStartupException;
import de.gematik.test.tiger.proxy.AbstractTigerProxy;
import de.gematik.test.tiger.proxy.ForwardProxyCallback;
import de.gematik.test.tiger.proxy.MockServerToRbelConverter;
import de.gematik.test.tiger.proxy.ReverseProxyCallback;
import de.gematik.test.tiger.proxy.TigerKeyAndCertificateFactory;
import de.gematik.test.tiger.proxy.client.TigerRemoteProxyClient;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyConfigurationException;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyRouteConflictException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.tomcat.util.buf.UriUtil;
import org.mockserver.client.MockServerClient;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.TimeToLive;
import org.mockserver.matchers.Times;
import org.mockserver.mock.Expectation;
import org.mockserver.mock.action.ExpectationForwardCallback;
import org.mockserver.model.ExpectationId;
import org.mockserver.model.HttpOverrideForwardedRequest;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.RequestDefinition;
import org.mockserver.netty.MockServer;
import org.mockserver.proxyconfiguration.ProxyConfiguration;
import org.mockserver.socket.tls.KeyAndCertificateFactory;
import org.mockserver.socket.tls.KeyAndCertificateFactoryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerProxy
extends AbstractTigerProxy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerProxy.class);
    private final List<TigerKeyAndCertificateFactory> tlsFactories = new ArrayList<TigerKeyAndCertificateFactory>();
    private final MockServer mockServer;
    private final MockServerClient mockServerClient;
    private final MockServerToRbelConverter mockServerToRbelConverter;
    private final Map<String, TigerRoute> tigerRouteMap = new HashMap<String, TigerRoute>();

    public TigerProxy(TigerProxyConfiguration configuration) {
        super(configuration);
        KeyAndCertificateFactoryFactory.setCustomKeyAndCertificateFactorySupplier(this.buildKeyAndCertificateFactory());
        this.mockServerToRbelConverter = new MockServerToRbelConverter(this.getRbelLogger().getRbelConverter());
        ConfigurationProperties.useBouncyCastleForKeyAndCertificateGeneration((boolean)true);
        ConfigurationProperties.forwardProxyTLSX509CertificatesTrustManagerType((String)"ANY");
        ConfigurationProperties.maxLogEntries((int)10);
        if (StringUtils.isNotEmpty((CharSequence)configuration.getProxyLogLevel())) {
            ConfigurationProperties.logLevel((String)configuration.getProxyLogLevel());
        }
        this.mockServer = this.convertProxyConfiguration().map(proxyConfiguration -> new MockServer(proxyConfiguration, configuration.getPortAsArray())).orElseGet(() -> new MockServer(configuration.getPortAsArray()));
        log.info("Proxy started on port " + this.mockServer.getLocalPort());
        this.mockServerClient = new MockServerClient("localhost", this.mockServer.getLocalPort()){};
        if (configuration.getProxyRoutes() != null) {
            for (TigerRoute tigerRoute : configuration.getProxyRoutes()) {
                this.addRoute(tigerRoute);
            }
        }
        if (configuration.isActivateRbelEndpoint()) {
            this.addRbelTrafficEndpoint();
        }
        if (!configuration.isSkipTrafficEndpointsSubscription()) {
            this.subscribeToTrafficEndpoints(configuration);
        }
        if (configuration.getModifications() != null) {
            int counter = 0;
            for (RbelModificationDescription modification : configuration.getModifications()) {
                if (modification.getName() == null) {
                    this.getRbelLogger().getRbelModifier().addModification(modification.withName("TigerModification #" + counter++));
                    continue;
                }
                this.getRbelLogger().getRbelModifier().addModification(modification);
            }
        }
        if (configuration.isActivateForwardAllLogging()) {
            this.mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(".*"), Times.unlimited(), TimeToLive.unlimited(), Integer.valueOf(Integer.MIN_VALUE)).forward(req -> HttpOverrideForwardedRequest.forwardOverriddenRequest((HttpRequest)req.withSocketAddress(req.isSecure(), req.socketAddressFromHostHeader().getHostName(), Integer.valueOf(req.socketAddressFromHostHeader().getPort()))).getHttpRequest(), (req, resp) -> {
                try {
                    this.triggerListener(this.mockServerToRbelConverter.convertRequest(req, req.getSocketAddress().getScheme() + "://" + req.getSocketAddress().getHost() + ":" + req.getSocketAddress().getPort()));
                    this.triggerListener(this.mockServerToRbelConverter.convertResponse(resp, req.getSocketAddress().getScheme() + "://" + req.getSocketAddress().getHost() + ":" + req.getSocketAddress().getPort()));
                    this.manageRbelBufferSize();
                }
                catch (Exception e) {
                    log.error("RBel FAILED!", (Throwable)e);
                }
                return resp;
            });
        }
    }

    private BiFunction<MockServerLogger, Boolean, KeyAndCertificateFactory> buildKeyAndCertificateFactory() {
        if (this.getTigerProxyConfiguration().getTls().getServerIdentity() != null && !this.getTigerProxyConfiguration().getTls().getServerIdentity().hasValidChainWithRootCa()) {
            throw new TigerProxyStartupException("Configured server-identity has no valid chain!");
        }
        return (mockServerLogger, isServerInstance) -> {
            if (isServerInstance.booleanValue() || this.getTigerProxyConfiguration().getTls() == null || this.getTigerProxyConfiguration().getTls().getForwardMutualTlsIdentity() == null) {
                TigerKeyAndCertificateFactory factory = new TigerKeyAndCertificateFactory((MockServerLogger)mockServerLogger, this.determineServerRootCa().orElse(null), this.getTigerProxyConfiguration().getTls().getServerIdentity(), this.getTigerProxyConfiguration().getTls());
                if (isServerInstance.booleanValue()) {
                    this.tlsFactories.add(factory);
                }
                return factory;
            }
            return new TigerKeyAndCertificateFactory((MockServerLogger)mockServerLogger, null, this.getTigerProxyConfiguration().getTls().getForwardMutualTlsIdentity(), this.getTigerProxyConfiguration().getTls());
        };
    }

    private Optional<TigerPkiIdentity> determineServerRootCa() {
        if (this.getTigerProxyConfiguration().getTls().getServerRootCa() != null) {
            return Optional.ofNullable(this.getTigerProxyConfiguration().getTls().getServerRootCa());
        }
        if (this.getTigerProxyConfiguration().getTls().getServerIdentity() != null) {
            return Optional.empty();
        }
        return Optional.of(new TigerPkiIdentity("CertificateAuthorityCertificate.pem;PKCS8CertificateAuthorityPrivateKey.pem;PKCS8"));
    }

    public void subscribeToTrafficEndpoints(TigerProxyConfiguration configuration) {
        Optional.of(configuration).filter(Objects::nonNull).map(TigerProxyConfiguration::getTrafficEndpoints).ifPresent(this::subscribeToTrafficEndpoints);
    }

    public void subscribeToTrafficEndpoints(List<String> trafficEndpointUrls) {
        Optional.of(trafficEndpointUrls).filter(Objects::nonNull).stream().flatMap(Collection::stream).map(url -> new TigerRemoteProxyClient((String)url, new TigerProxyConfiguration())).forEach(remoteClient -> {
            remoteClient.setRbelLogger(this.getRbelLogger());
            remoteClient.addRbelMessageListener(this::triggerListener);
        });
    }

    private void addRbelTrafficEndpoint() {
        this.mockServerClient.when((RequestDefinition)HttpRequest.request().withHeader("Host", new String[]{"rbel"})).respond(HttpResponse.response().withHeader("content-type", new String[]{"text/html; charset=utf-8"}).withBody(new RbelHtmlRenderer().doRender(this.getRbelLogger().getMessageHistory())));
        this.mockServerClient.when((RequestDefinition)HttpRequest.request().withHeader("Host", null).withPath("/rbel")).respond(httpRequest -> HttpResponse.response().withHeader("content-type", new String[]{"text/html; charset=utf-8"}).withBody(new RbelHtmlRenderer().doRender(this.getRbelLogger().getMessageHistory())));
    }

    public ProxyConfiguration.Type toMockServerType(TigerProxyType type) {
        if (type == TigerProxyType.HTTP) {
            return ProxyConfiguration.Type.HTTP;
        }
        return ProxyConfiguration.Type.HTTPS;
    }

    private Optional<ProxyConfiguration> convertProxyConfiguration() {
        Optional<ProxyConfiguration> optional;
        block14: {
            Optional<ProxyConfiguration> cfg;
            block12: {
                block10: {
                    Optional<ProxyConfiguration> optional2;
                    block13: {
                        block11: {
                            cfg = Optional.empty();
                            try {
                                if (this.getTigerProxyConfiguration().getForwardToProxy() != null && !StringUtils.isEmpty((CharSequence)this.getTigerProxyConfiguration().getForwardToProxy().getHostname())) break block10;
                                optional2 = cfg;
                                if (!cfg.isEmpty()) break block11;
                            }
                            catch (Throwable throwable) {
                                if (cfg.isEmpty()) {
                                    log.info("Tigerproxy has NO forward proxy configured!");
                                } else {
                                    log.info("Forward proxy is set to " + ((ProxyConfiguration)cfg.get()).getType() + "://" + ((ProxyConfiguration)cfg.get()).getProxyAddress().getHostName() + ":" + cfg.get().getProxyAddress().getPort());
                                }
                                throw throwable;
                            }
                            log.info("Tigerproxy has NO forward proxy configured!");
                            break block13;
                        }
                        log.info("Forward proxy is set to " + ((ProxyConfiguration)cfg.get()).getType() + "://" + cfg.get().getProxyAddress().getHostName() + ":" + cfg.get().getProxyAddress().getPort());
                    }
                    return optional2;
                }
                if (this.getTigerProxyConfiguration().getForwardToProxy().getHostname() != null && this.getTigerProxyConfiguration().getForwardToProxy().getHostname().equals("$SYSTEM")) {
                    if (System.getProperty("http.proxyHost") != null) {
                        cfg = Optional.of(ProxyConfiguration.proxyConfiguration((ProxyConfiguration.Type)ProxyConfiguration.Type.HTTP, (String)(System.getProperty("http.proxyHost") + ":" + System.getProperty("http.proxyPort"))));
                    } else if (System.getenv("http_proxy") != null) {
                        cfg = Optional.of(ProxyConfiguration.proxyConfiguration((ProxyConfiguration.Type)ProxyConfiguration.Type.HTTP, (String)System.getenv("http_proxy").split("://")[1]));
                    }
                } else {
                    cfg = Optional.of(ProxyConfiguration.proxyConfiguration((ProxyConfiguration.Type)Optional.ofNullable(this.getTigerProxyConfiguration().getForwardToProxy().getType()).map(this::toMockServerType).orElse(ProxyConfiguration.Type.HTTPS), (String)(this.getTigerProxyConfiguration().getForwardToProxy().getHostname() + ":" + this.getTigerProxyConfiguration().getForwardToProxy().getPort())));
                }
                optional = cfg;
                if (!cfg.isEmpty()) break block12;
                log.info("Tigerproxy has NO forward proxy configured!");
                break block14;
            }
            log.info("Forward proxy is set to " + cfg.get().getType() + "://" + cfg.get().getProxyAddress().getHostName() + ":" + cfg.get().getProxyAddress().getPort());
        }
        return optional;
    }

    @Override
    public String getBaseUrl() {
        return "http://localhost:" + this.mockServer.getLocalPort();
    }

    @Override
    public int getPort() {
        return this.mockServer.getLocalPort();
    }

    @Override
    public List<TigerRoute> getRoutes() {
        return this.tigerRouteMap.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
    }

    @Override
    public TigerRoute addRoute(TigerRoute tigerRoute) {
        this.tigerRouteMap.values().stream().filter(existingRoute -> this.uriEquals(existingRoute.getFrom(), tigerRoute.getFrom())).findAny().ifPresent(existingRoute -> {
            throw new TigerProxyRouteConflictException((TigerRoute)existingRoute);
        });
        log.info("adding route {} -> {}", (Object)tigerRoute.getFrom(), (Object)tigerRoute.getTo());
        Expectation[] expectations = this.buildRouteAndReturnExpectation(tigerRoute);
        if (expectations.length > 1) {
            log.warn("Unexpected number of expectations created! Got {}, expected 1", (Object)expectations.length);
        }
        if (expectations.length == 0) {
            throw new TigerProxyConfigurationException("Error while adding route from '{}' to '{}': Got 0 new expectations");
        }
        TigerRoute createdTigerRoute = tigerRoute.withId(expectations[0].getId());
        this.tigerRouteMap.put(expectations[0].getId(), createdTigerRoute);
        log.info("Created route {} with expectation {}", (Object)createdTigerRoute, (Object)expectations[0]);
        return createdTigerRoute;
    }

    private boolean uriEquals(String value1, String value2) {
        try {
            return new URI(value1).equals(new URI(value2));
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    private Expectation[] buildRouteAndReturnExpectation(TigerRoute tigerRoute) {
        if (UriUtil.hasScheme((CharSequence)tigerRoute.getFrom())) {
            return this.buildForwardProxyRoute(tigerRoute);
        }
        return this.buildReverseProxyRoute(tigerRoute);
    }

    private Expectation[] buildReverseProxyRoute(TigerRoute tigerRoute) {
        return this.mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(tigerRoute.getFrom() + ".*")).forward((ExpectationForwardCallback)new ReverseProxyCallback(this, tigerRoute));
    }

    private Expectation[] buildForwardProxyRoute(TigerRoute tigerRoute) {
        return this.mockServerClient.when((RequestDefinition)HttpRequest.request().withHeader("Host", new String[]{tigerRoute.getFrom().split("://")[1]}).withSecure(Boolean.valueOf(tigerRoute.getFrom().startsWith("https://")))).forward((ExpectationForwardCallback)new ForwardProxyCallback(this, tigerRoute));
    }

    public void addAlternativeName(String host) {
        ArrayList<String> newAlternativeNames = new ArrayList<String>();
        if (this.getTigerProxyConfiguration().getTls() != null && this.getTigerProxyConfiguration().getTls().getAlternativeNames() != null) {
            newAlternativeNames.addAll(this.getTigerProxyConfiguration().getTls().getAlternativeNames());
        }
        newAlternativeNames.add(host);
        this.getTigerProxyConfiguration().getTls().setAlternativeNames(newAlternativeNames);
        for (TigerKeyAndCertificateFactory tlsFactory : this.tlsFactories) {
            tlsFactory.addAlternativeName(host);
            tlsFactory.resetEeCertificate();
        }
    }

    public void manageRbelBufferSize() {
        while (this.rbelBufferIsExceedingMaxSize()) {
            log.info("Exceeded buffer size, dropping oldest message in history");
            this.getRbelLogger().getMessageHistory().remove(0);
        }
    }

    private boolean rbelBufferIsExceedingMaxSize() {
        boolean exceedingLimit;
        long bufferSize = this.getRbelLogger().getMessageHistory().stream().map(RbelElement::getRawContent).mapToLong(ar -> ((byte[])ar).length).sum();
        boolean bl = exceedingLimit = bufferSize > (long)(this.getTigerProxyConfiguration().getRbelBufferSizeInMb() * 1024 * 1024);
        if (exceedingLimit) {
            log.info("Buffersize is {} Mb which exceeds the limit of {} Mb", (Object)(bufferSize / 1026L), (Object)this.getTigerProxyConfiguration().getRbelBufferSizeInMb());
        }
        return exceedingLimit;
    }

    @Override
    public void removeRoute(String routeId) {
        this.mockServerClient.clear(new ExpectationId().withId(routeId));
        TigerRoute route = this.tigerRouteMap.remove(routeId);
        log.info("Deleted route {}. Current # expectations {}", (Object)route, (Object)this.mockServerClient.retrieveActiveExpectations((RequestDefinition)HttpRequest.request()).length);
    }

    public KeyStore buildTruststore() {
        try {
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(null);
            TigerPkiIdentity serverIdentity = this.determineServerRootCa().or(() -> Optional.ofNullable(this.getTigerProxyConfiguration().getTls()).map(TigerTlsConfiguration::getServerIdentity).filter(Objects::nonNull)).orElseThrow(() -> new TigerProxyTrustManagerBuildingException("Unrecoverable state: Server-Identity null and Server-CA empty"));
            ks.setCertificateEntry("caCert", serverIdentity.getCertificate());
            int chainCertCtr = 0;
            for (X509Certificate chainCert : serverIdentity.getCertificateChain()) {
                ks.setCertificateEntry("chainCert" + chainCertCtr++, chainCert);
            }
            return ks;
        }
        catch (Exception e) {
            throw new TigerProxyTrustManagerBuildingException("Error while building SSL-Context for tiger-proxy", e);
        }
    }

    public SSLContext buildSslContext() {
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(this.buildTruststore());
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, tmf.getTrustManagers(), null);
            return sslContext;
        }
        catch (Exception e) {
            throw new TigerProxyTrustManagerBuildingException("Error while building SSL-Context for tiger-proxy", e);
        }
    }

    @Generated
    public MockServerToRbelConverter getMockServerToRbelConverter() {
        return this.mockServerToRbelConverter;
    }

    private class TigerProxyTrustManagerBuildingException
    extends RuntimeException {
        public TigerProxyTrustManagerBuildingException(String s, Exception e) {
            super(s, e);
        }

        public TigerProxyTrustManagerBuildingException(String s) {
            super(s);
        }
    }
}

