/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy;

import de.gematik.test.tiger.common.config.tigerProxy.TigerRoute;
import de.gematik.test.tiger.proxy.AbstractTigerRouteCallback;
import de.gematik.test.tiger.proxy.TigerProxy;
import java.net.URI;
import lombok.Generated;
import org.mockserver.model.Header;
import org.mockserver.model.HttpOverrideForwardedRequest;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardProxyCallback
extends AbstractTigerRouteCallback {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ForwardProxyCallback.class);
    private final URI targetUri;
    private final int port;

    public ForwardProxyCallback(TigerProxy tigerProxy, TigerRoute tigerRoute) {
        super(tigerProxy, tigerRoute);
        this.targetUri = new URI(tigerRoute.getTo());
        this.port = this.targetUri.getPort() < 0 ? (tigerRoute.getTo().startsWith("https://") ? 443 : 80) : this.targetUri.getPort();
        tigerProxy.addAlternativeName(new URI(tigerRoute.getFrom()).getHost());
    }

    public HttpRequest handle(HttpRequest req) {
        this.applyModifications(req);
        req.replaceHeader(Header.header((String)"Host", (String[])new String[]{this.targetUri.getHost() + ":" + this.port}));
        if (this.getTigerRoute().getBasicAuth() != null) {
            req.replaceHeader(Header.header((String)"Authorization", (String[])new String[]{this.getTigerRoute().getBasicAuth().toAuthorizationHeaderValue()}));
        }
        String path = req.getPath().equals((Object)"/") ? this.targetUri.getPath() : this.targetUri.getPath() + req.getPath();
        return HttpOverrideForwardedRequest.forwardOverriddenRequest((HttpRequest)req).getHttpRequest().withPath(path).withSecure(Boolean.valueOf(this.getTigerRoute().getTo().startsWith("https://")));
    }

    public HttpResponse handle(HttpRequest req, HttpResponse resp) {
        this.applyModifications(resp);
        if (!this.getTigerRoute().isDisableRbelLogging()) {
            try {
                this.getTigerProxy().triggerListener(this.getTigerProxy().getMockServerToRbelConverter().convertRequest(req, this.getTigerRoute().getFrom()));
                this.getTigerProxy().triggerListener(this.getTigerProxy().getMockServerToRbelConverter().convertResponse(resp, this.getTigerRoute().getFrom()));
                this.getTigerProxy().manageRbelBufferSize();
            }
            catch (Exception e) {
                log.error("RBel FAILED!", (Throwable)e);
            }
        }
        return resp;
    }
}

