/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelHostname;
import de.gematik.rbellogger.data.facet.RbelFacet;
import de.gematik.rbellogger.data.facet.RbelHttpRequestFacet;
import de.gematik.rbellogger.data.facet.RbelHttpResponseFacet;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.util.Arrays;
import org.mockserver.model.Header;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockServerToRbelConverter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MockServerToRbelConverter.class);
    private final RbelConverter rbelConverter;

    public RbelElement convertResponse(HttpResponse response, String protocolAndHost) {
        log.trace("Converting response {}, headers {}, body {}", new Object[]{response, response.getHeaders(), response.getBodyAsString()});
        return this.rbelConverter.parseMessage(this.responseToRbelMessage(response), this.convertUri(protocolAndHost), null);
    }

    public RbelElement convertRequest(HttpRequest request, String protocolAndHost) {
        log.trace("Converting request {}, headers {}, body {}", new Object[]{request, request.getHeaders(), request.getBodyAsString()});
        return this.rbelConverter.parseMessage(this.requestToRbelMessage(request), null, this.convertUri(protocolAndHost));
    }

    private RbelHostname convertUri(String protocolAndHost) {
        try {
            URI uri = new URI(protocolAndHost);
            if (StringUtils.isEmpty((CharSequence)uri.getScheme())) {
                return null;
            }
            return RbelHostname.generateFromUrl((String)protocolAndHost);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private RbelElement responseToRbelMessage(HttpResponse response) {
        byte[] httpMessage = this.responseToRawMessage(response);
        RbelElement element = this.rbelConverter.convertElement(httpMessage, null);
        if (!element.hasFacet(RbelHttpResponseFacet.class)) {
            element.addFacet((RbelFacet)RbelHttpResponseFacet.builder().responseCode(RbelElement.builder().parentNode(element).rawContent(response.getStatusCode().toString().getBytes()).build()).build());
        }
        return element;
    }

    private RbelElement requestToRbelMessage(HttpRequest request) {
        byte[] httpMessage = this.requestToRawMessage(request);
        RbelElement element = this.rbelConverter.convertElement(httpMessage, null);
        if (!element.hasFacet(RbelHttpRequestFacet.class)) {
            element.addFacet((RbelFacet)RbelHttpRequestFacet.builder().path(RbelElement.wrap((RbelElement)element, (Object)request.getPath().getValue())).method(RbelElement.wrap((RbelElement)element, (Object)request.getMethod().getValue())).build());
        }
        return element;
    }

    private byte[] requestToRawMessage(HttpRequest request) {
        byte[] httpRequestHeader = (request.getMethod().toString() + " " + this.getRequestUrl(request) + " HTTP/1.1\r\n" + this.formatHeaderList(request.getHeaderList()) + "\r\n\r\n").getBytes();
        byte[] httpMessage = Arrays.concatenate((byte[])httpRequestHeader, (byte[])request.getBodyAsRawBytes());
        return httpMessage;
    }

    private byte[] responseToRawMessage(HttpResponse response) {
        byte[] httpResponseHeader = ("HTTP/1.1 " + response.getStatusCode() + " " + (response.getReasonPhrase() != null ? response.getReasonPhrase() : "") + "\r\n" + this.formatHeaderList(response.getHeaderList()) + "\r\n\r\n").getBytes(StandardCharsets.US_ASCII);
        byte[] httpMessage = Arrays.concatenate((byte[])httpResponseHeader, (byte[])response.getBodyAsRawBytes());
        return httpMessage;
    }

    private String formatHeaderList(List<Header> headerList) {
        return headerList.stream().map(h -> h.getValues().stream().map(value -> h.getName().getValue() + ": " + value).collect(Collectors.joining("\n"))).collect(Collectors.joining("\r\n"));
    }

    private String getRequestUrl(HttpRequest request) {
        return request.getPath().getValue();
    }

    @ConstructorProperties(value={"rbelConverter"})
    @Generated
    public MockServerToRbelConverter(RbelConverter rbelConverter) {
        this.rbelConverter = rbelConverter;
    }
}

