/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.engine;

import io.ktor.events.EventDefinition;
import io.ktor.events.Events;
import io.ktor.events.EventsKt;
import io.ktor.http.HttpStatusCode;
import io.ktor.server.application.Application;
import io.ktor.server.application.ApplicationEnvironment;
import io.ktor.server.application.DefaultApplicationEventsKt;
import io.ktor.server.application.ServerConfig;
import io.ktor.server.config.ApplicationConfigValue;
import io.ktor.server.engine.ApplicationEngine;
import io.ktor.server.engine.ApplicationEngineFactory;
import io.ktor.server.engine.ClassLoadersKt;
import io.ktor.server.engine.EmbeddedServerJvmKt;
import io.ktor.server.engine.EngineConnectorConfig;
import io.ktor.server.engine.OverridingClassLoader;
import io.ktor.server.engine.ServerHostUtilsKt;
import io.ktor.server.engine.ShutdownHookKt;
import io.ktor.server.engine.internal.ApplicationUtilsJvmKt;
import io.ktor.server.engine.internal.AutoReloadUtilsKt;
import io.ktor.server.engine.internal.CallableUtilsKt;
import io.ktor.server.engine.internal.EngineUtilsJvmKt;
import io.ktor.server.engine.internal.ReloadingException;
import io.ktor.util.Attributes;
import io.ktor.util.pipeline.Pipeline;
import io.ktor.utils.io.ByteReadChannel;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Function;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.io.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u0001*\b\b\u0001\u0010\u0004*\u00020\u00032\u00020\u0005B>\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u0012\u0019\b\u0002\u0010\r\u001a\u0013\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\b\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001b\u0010\u0017\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0016\u0018\u00010\u0015H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001b\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000f\u0010\u001d\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ%\u0010\"\u001a\u00020\u000b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00120\u001f2\u0006\u0010!\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\"\u0010#J\u000f\u0010$\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b$\u0010\u0011J\u001d\u0010'\u001a\u00020\u000b2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020%0\u0015H\u0002\u00a2\u0006\u0004\b'\u0010(J#\u0010+\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010*\u001a\u00020)\u00a2\u0006\u0004\b+\u0010,J&\u0010-\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010*\u001a\u00020)H\u0086@\u00a2\u0006\u0004\b-\u0010.J%\u00104\u001a\u00020\u000b2\u0006\u00100\u001a\u00020/2\u0006\u00101\u001a\u00020/2\u0006\u00103\u001a\u000202\u00a2\u0006\u0004\b4\u00105J!\u00104\u001a\u00020\u000b2\b\b\u0002\u00106\u001a\u00020/2\b\b\u0002\u00107\u001a\u00020/\u00a2\u0006\u0004\b4\u00108J$\u00109\u001a\u00020\u000b2\b\b\u0002\u00106\u001a\u00020/2\b\b\u0002\u00107\u001a\u00020/H\u0086@\u00a2\u0006\u0004\b9\u0010:J\u0017\u0010<\u001a\u00020\u00122\u0006\u0010;\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b<\u0010=J2\u0010B\u001a\u001d\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u000b0@j\u0002`A\u00a2\u0006\u0002\b\f2\u0006\u0010?\u001a\u00020>H\u0002\u00a2\u0006\u0004\bB\u0010CJG\u0010E\u001a!\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u000b\u0018\u00010@j\u0004\u0018\u0001`A\u00a2\u0006\u0002\b\f*\u0017\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000b0\nj\u0002`D\u00a2\u0006\u0002\b\fH\u0002\u00a2\u0006\u0004\bE\u0010FJC\u0010G\u001a\u001d\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u000b0@j\u0002`A\u00a2\u0006\u0002\b\f*\u0017\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000b0\nj\u0002`D\u00a2\u0006\u0002\b\fH\u0002\u00a2\u0006\u0004\bG\u0010FJ'\u0010I\u001a\u00020\u000b2\u0006\u0010?\u001a\u00020>2\u0006\u0010;\u001a\u00020\u001a2\u0006\u0010H\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\bI\u0010JJ\u001d\u0010M\u001a\u00020\u000b2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020\u000b0KH\u0002\u00a2\u0006\u0004\bM\u0010NJ%\u0010P\u001a\u00020\u000b2\u0006\u0010O\u001a\u00020>2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020\u000b0KH\u0002\u00a2\u0006\u0004\bP\u0010QJ\u000f\u0010R\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\bR\u0010\u0011R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010SR\u001d\u0010U\u001a\u00020T8\u0006\u00a2\u0006\u0012\n\u0004\bU\u0010V\u0012\u0004\bY\u0010\u0011\u001a\u0004\bW\u0010XR\u0017\u0010[\u001a\u00020Z8\u0006\u00a2\u0006\f\n\u0004\b[\u0010\\\u001a\u0004\b]\u0010^R\u0011\u0010!\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b_\u0010\u0014R\u0017\u0010`\u001a\u00028\u00018\u0006\u00a2\u0006\f\n\u0004\b`\u0010a\u001a\u0004\bb\u0010cR\u0014\u0010e\u001a\u00020d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\be\u0010fR\u0016\u0010g\u001a\u00020)8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bg\u0010hR\u0018\u0010i\u001a\u0004\u0018\u00010\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bi\u0010jR\u001c\u0010l\u001a\b\u0012\u0004\u0012\u00020k0\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bl\u0010mR\u001a\u0010n\u001a\b\u0012\u0004\u0012\u00020>0\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bn\u0010mR\u001a\u0010o\u001a\b\u0012\u0004\u0012\u00020>0\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bo\u0010mR\u001a\u0010p\u001a\b\u0012\u0004\u0012\u00020>0\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bp\u0010mR8\u0010t\u001a\u001f\u0012\u001b\u0012\u0019\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u000b0@\u00a2\u0006\u0002\b\f0\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bq\u0010r\u001a\u0004\bs\u0010\u0018R\u0018\u0010u\u001a\u0004\u0018\u00010\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bu\u0010vR\u0017\u0010w\u001a\u00028\u00008\u0006\u00a2\u0006\f\n\u0004\bw\u0010x\u001a\u0004\by\u0010zR\u001d\u0010\u007f\u001a\u0004\u0018\u00010{8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b|\u0010r\u001a\u0004\b}\u0010~\u00a8\u0006\u0080\u0001"}, d2={"Lio/ktor/server/engine/EmbeddedServer;", "Lio/ktor/server/engine/ApplicationEngine;", "TEngine", "Lio/ktor/server/engine/ApplicationEngine$Configuration;", "TConfiguration", "", "Lio/ktor/server/application/ServerConfig;", "rootConfig", "Lio/ktor/server/engine/ApplicationEngineFactory;", "engineFactory", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "engineConfigBlock", "<init>", "(Lio/ktor/server/application/ServerConfig;Lio/ktor/server/engine/ApplicationEngineFactory;Lkotlin/jvm/functions/Function1;)V", "reload", "()V", "Lio/ktor/server/application/Application;", "currentApplication", "()Lio/ktor/server/application/Application;", "", "Ljava/nio/file/WatchEvent;", "getFileChanges", "()Ljava/util/List;", "Lkotlin/Pair;", "Ljava/lang/ClassLoader;", "createApplication", "()Lkotlin/Pair;", "createClassLoader", "()Ljava/lang/ClassLoader;", "Lio/ktor/events/EventDefinition;", "event", "application", "safeRaiseEvent", "(Lio/ktor/events/EventDefinition;Lio/ktor/server/application/Application;)V", "destroyApplication", "Ljava/net/URL;", "urls", "watchUrls", "(Ljava/util/List;)V", "", "wait", "start", "(Z)Lio/ktor/server/engine/EmbeddedServer;", "startSuspend", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "shutdownGracePeriod", "shutdownTimeout", "Ljava/util/concurrent/TimeUnit;", "timeUnit", "stop", "(JJLjava/util/concurrent/TimeUnit;)V", "gracePeriodMillis", "timeoutMillis", "(JJ)V", "stopSuspend", "(JJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "currentClassLoader", "instantiateAndConfigureApplication", "(Ljava/lang/ClassLoader;)Lio/ktor/server/application/Application;", "", "name", "Lkotlin/Function2;", "Lio/ktor/server/engine/DynamicApplicationModule;", "dynamicModule", "(Ljava/lang/String;)Lkotlin/jvm/functions/Function2;", "Lio/ktor/server/engine/ApplicationModule;", "toDynamicModuleOrNull", "(Lkotlin/jvm/functions/Function1;)Lkotlin/jvm/functions/Function2;", "wrapWithDynamicModule", "newInstance", "launchModuleByName", "(Ljava/lang/String;Ljava/lang/ClassLoader;Lio/ktor/server/application/Application;)V", "Lkotlin/Function0;", "block", "avoidingDoubleStartup", "(Lkotlin/jvm/functions/Function0;)V", "fqName", "avoidingDoubleStartupFor", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "cleanupWatcher", "Lio/ktor/server/application/ServerConfig;", "Lio/ktor/events/Events;", "monitor", "Lio/ktor/events/Events;", "getMonitor", "()Lio/ktor/events/Events;", "getMonitor$annotations", "Lio/ktor/server/application/ApplicationEnvironment;", "environment", "Lio/ktor/server/application/ApplicationEnvironment;", "getEnvironment", "()Lio/ktor/server/application/ApplicationEnvironment;", "getApplication", "engineConfig", "Lio/ktor/server/engine/ApplicationEngine$Configuration;", "getEngineConfig", "()Lio/ktor/server/engine/ApplicationEngine$Configuration;", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "applicationInstanceLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "recreateInstance", "Z", "applicationClassLoader", "Ljava/lang/ClassLoader;", "Ljava/nio/file/WatchKey;", "packageWatchKeys", "Ljava/util/List;", "configuredWatchPath", "watchPatterns", "configModulesNames", "modules$delegate", "Lkotlin/Lazy;", "getModules", "modules", "applicationInstance", "Lio/ktor/server/application/Application;", "engine", "Lio/ktor/server/engine/ApplicationEngine;", "getEngine", "()Lio/ktor/server/engine/ApplicationEngine;", "Ljava/nio/file/WatchService;", "watcher$delegate", "getWatcher", "()Ljava/nio/file/WatchService;", "watcher", "ktor-server-core"})
@SourceDebugExtension(value={"SMAP\nEmbeddedServerJvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmbeddedServerJvm.kt\nio/ktor/server/engine/EmbeddedServer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,462:1\n1374#2:463\n1460#2,5:464\n1374#2:469\n1460#2,5:470\n1869#2,2:475\n1563#2:477\n1634#2,3:478\n774#2:481\n865#2,2:482\n1625#2:484\n1869#2:485\n1870#2:487\n1626#2:488\n774#2:489\n865#2:490\n1761#2,3:491\n866#2:494\n1869#2,2:495\n1869#2,2:498\n1617#2,9:500\n1869#2:509\n1870#2:511\n1626#2:512\n1563#2:514\n1634#2,3:515\n1563#2:518\n1634#2,3:519\n1869#2,2:522\n1#3:486\n1#3:497\n1#3:510\n1#3:513\n*S KotlinDebug\n*F\n+ 1 EmbeddedServerJvm.kt\nio/ktor/server/engine/EmbeddedServer\n*L\n133#1:463\n133#1:464,5\n143#1:469\n143#1:470,5\n153#1:475,2\n193#1:477\n193#1:478,3\n195#1:481\n195#1:482,2\n208#1:484\n208#1:485\n208#1:487\n208#1:488\n210#1:489\n210#1:490\n212#1:491,3\n210#1:494\n248#1:495,2\n284#1:498,2\n289#1:500,9\n289#1:509\n289#1:511\n289#1:512\n67#1:514\n67#1:515,3\n68#1:518\n68#1:519,3\n371#1:522,2\n208#1:486\n289#1:510\n*E\n"})
public final class EmbeddedServer<TEngine extends ApplicationEngine, TConfiguration extends ApplicationEngine.Configuration> {
    @NotNull
    private final ServerConfig rootConfig;
    @NotNull
    private final Events monitor;
    @NotNull
    private final ApplicationEnvironment environment;
    @NotNull
    private final TConfiguration engineConfig;
    @NotNull
    private final ReentrantReadWriteLock applicationInstanceLock;
    private boolean recreateInstance;
    @Nullable
    private ClassLoader applicationClassLoader;
    @NotNull
    private List<? extends WatchKey> packageWatchKeys;
    @NotNull
    private final List<String> configuredWatchPath;
    @NotNull
    private final List<String> watchPatterns;
    @NotNull
    private final List<String> configModulesNames;
    @NotNull
    private final Lazy modules$delegate;
    @Nullable
    private Application applicationInstance;
    @NotNull
    private final TEngine engine;
    @NotNull
    private final Lazy watcher$delegate;

    public EmbeddedServer(@NotNull ServerConfig rootConfig, @NotNull ApplicationEngineFactory<? extends TEngine, TConfiguration> engineFactory, @NotNull Function1<? super TConfiguration, Unit> engineConfigBlock) {
        Intrinsics.checkNotNullParameter(rootConfig, "rootConfig");
        Intrinsics.checkNotNullParameter(engineFactory, "engineFactory");
        Intrinsics.checkNotNullParameter(engineConfigBlock, "engineConfigBlock");
        this.rootConfig = rootConfig;
        this.monitor = this.rootConfig.getEnvironment().getMonitor();
        this.environment = this.rootConfig.getEnvironment();
        this.engineConfig = engineFactory.configuration(engineConfigBlock);
        this.applicationInstanceLock = new ReentrantReadWriteLock();
        this.packageWatchKeys = CollectionsKt.emptyList();
        ApplicationConfigValue applicationConfigValue = this.environment.getConfig().propertyOrNull("ktor.deployment.watch");
        List<String> list = applicationConfigValue != null ? applicationConfigValue.getList() : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        this.configuredWatchPath = list;
        this.watchPatterns = CollectionsKt.plus((Collection)this.configuredWatchPath, (Iterable)this.rootConfig.getWatchPaths$ktor_server_core());
        ApplicationConfigValue applicationConfigValue2 = this.environment.getConfig().propertyOrNull("ktor.application.modules");
        List<String> list2 = applicationConfigValue2 != null ? applicationConfigValue2.getList() : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        this.configModulesNames = list2;
        this.modules$delegate = LazyKt.lazy(() -> EmbeddedServer.modules_delegate$lambda$2(this));
        this.applicationInstance = new Application(this.environment, this.rootConfig.getDevelopmentMode(), this.rootConfig.getRootPath(), this.monitor, this.rootConfig.getParentCoroutineContext(), new PropertyReference0Impl(this){

            public Object get() {
                return ((EmbeddedServer)this.receiver).getEngine();
            }
        });
        this.engine = engineFactory.create(this.environment, this.monitor, this.rootConfig.getDevelopmentMode(), this.engineConfig, new Function0<Application>((Object)this){

            public final Application invoke() {
                return EmbeddedServer.access$currentApplication((EmbeddedServer)this.receiver);
            }
        });
        this.watcher$delegate = LazyKt.lazy(EmbeddedServer::watcher_delegate$lambda$3);
    }

    public /* synthetic */ EmbeddedServer(ServerConfig serverConfig, ApplicationEngineFactory applicationEngineFactory, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = EmbeddedServer::_init_$lambda$0;
        }
        this(serverConfig, applicationEngineFactory, function1);
    }

    @NotNull
    public final Events getMonitor() {
        return this.monitor;
    }

    public static /* synthetic */ void getMonitor$annotations() {
    }

    @NotNull
    public final ApplicationEnvironment getEnvironment() {
        return this.environment;
    }

    @NotNull
    public final Application getApplication() {
        return this.currentApplication();
    }

    @NotNull
    public final TConfiguration getEngineConfig() {
        return this.engineConfig;
    }

    private final List<Function2<Application, ClassLoader, Unit>> getModules() {
        Lazy lazy = this.modules$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public final TEngine getEngine() {
        return this.engine;
    }

    private final WatchService getWatcher() {
        Lazy lazy = this.watcher$delegate;
        return (WatchService)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reload() {
        ReentrantReadWriteLock reentrantReadWriteLock = this.applicationInstanceLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            this.destroyApplication();
            Pair<Application, ClassLoader> pair = this.createApplication();
            Application application = pair.component1();
            ClassLoader classLoader = pair.component2();
            this.applicationInstance = application;
            this.applicationClassLoader = classLoader;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Application currentApplication() {
        Application application;
        ReentrantReadWriteLock.ReadLock readLock = this.applicationInstanceLock.readLock();
        readLock.lock();
        try {
            Application application2;
            boolean bl = false;
            Application application3 = this.applicationInstance;
            if (application3 == null) {
                throw new IllegalStateException("EmbeddedServer was stopped".toString());
            }
            Application currentApplication = application3;
            if (!this.rootConfig.getDevelopmentMode()) {
                application2 = currentApplication;
            } else {
                Object object = this.getFileChanges();
                if (object == null || object.isEmpty()) {
                    application2 = currentApplication;
                } else {
                    object = this.applicationInstanceLock;
                    ReentrantReadWriteLock.ReadLock readLock2 = ((ReentrantReadWriteLock)object).readLock();
                    int n = ((ReentrantReadWriteLock)object).getWriteHoldCount() == 0 ? ((ReentrantReadWriteLock)object).getReadHoldCount() : 0;
                    for (int i = 0; i < n; ++i) {
                        readLock2.unlock();
                    }
                    ReentrantReadWriteLock.WriteLock writeLock = ((ReentrantReadWriteLock)object).writeLock();
                    writeLock.lock();
                    try {
                        boolean bl2 = false;
                        this.destroyApplication();
                        Pair<Application, ClassLoader> pair = this.createApplication();
                        Application application4 = pair.component1();
                        ClassLoader classLoader = pair.component2();
                        this.applicationInstance = application4;
                        this.applicationClassLoader = classLoader;
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        for (int i = 0; i < n; ++i) {
                            readLock2.lock();
                        }
                        writeLock.unlock();
                    }
                    application2 = this.applicationInstance;
                    if (application2 == null) {
                        throw new IllegalStateException("EmbeddedServer was stopped".toString());
                    }
                }
            }
            application = application2;
        }
        finally {
            readLock.unlock();
        }
        return application;
    }

    /*
     * WARNING - void declaration
     */
    private final List<WatchEvent<?>> getFileChanges() {
        try {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = this.packageWatchKeys;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                WatchKey it = (WatchKey)element$iv$iv;
                boolean bl = false;
                List<WatchEvent<?>> list = it.pollEvents();
                Intrinsics.checkNotNullExpressionValue(list, "pollEvents(...)");
                Iterable list$iv$iv = list;
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            List changes = (List)destination$iv$iv;
            if (changes.isEmpty()) {
                return changes;
            }
            this.environment.getLog().info("Changes in application detected.");
            int count2 = changes.size();
            while (true) {
                void $this$flatMapTo$iv$iv2;
                Thread.sleep(200L);
                Iterable $this$flatMap$iv2 = this.packageWatchKeys;
                boolean $i$f$flatMap2 = false;
                Iterable $i$f$flatMapTo2 = $this$flatMap$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$flatMapTo3 = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
                    WatchKey it = (WatchKey)element$iv$iv;
                    boolean bl = false;
                    List<WatchEvent<?>> list = it.pollEvents();
                    Intrinsics.checkNotNullExpressionValue(list, "pollEvents(...)");
                    Iterable list$iv$iv = list;
                    CollectionsKt.addAll(destination$iv$iv2, list$iv$iv);
                }
                List moreChanges = (List)destination$iv$iv2;
                if (moreChanges.isEmpty()) break;
                this.environment.getLog().debug("Waiting for more changes.");
                count2 += moreChanges.size();
            }
            this.environment.getLog().debug("Changes to " + count2 + " files caused application restart.");
            Iterable $this$forEach$iv = CollectionsKt.take(changes, 5);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WatchEvent it = (WatchEvent)element$iv;
                boolean bl = false;
                this.environment.getLog().debug("...  {}", it.context());
            }
            return changes;
        }
        catch (InterruptedException e) {
            this.environment.getLog().debug("Watch service was interrupted", e);
            return null;
        }
        catch (ClosedWatchServiceException e) {
            this.environment.getLog().debug("Watch service was closed", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Pair<Application, ClassLoader> createApplication() {
        ClassLoader classLoader = this.createClassLoader();
        Thread currentThread = Thread.currentThread();
        ClassLoader oldThreadClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(classLoader);
        try {
            Pair<Application, ClassLoader> pair = TuplesKt.to(this.instantiateAndConfigureApplication(classLoader), classLoader);
            return pair;
        }
        finally {
            currentThread.setContextClassLoader(oldThreadClassLoader);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final ClassLoader createClassLoader() {
        baseClassLoader = this.environment.getClassLoader();
        if (!this.rootConfig.getDevelopmentMode()) {
            this.environment.getLog().info("Autoreload is disabled because the development mode is off.");
            return baseClassLoader;
        }
        watchPatterns = this.watchPatterns;
        if (watchPatterns.isEmpty()) {
            this.environment.getLog().info("No ktor.deployment.watch patterns specified, automatic reload is not active.");
            return baseClassLoader;
        }
        allUrls = ClassLoadersKt.allURLs(baseClassLoader);
        jre = new File(System.getProperty("java.home")).getParent();
        $this$map$iv = allUrls;
        $i$f$map = false;
        var8_8 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var13_18 = (URL)item$iv$iv;
            var23_22 = destination$iv$iv;
            $i$a$-map-EmbeddedServer$createClassLoader$debugUrls$1 = false;
            var23_22.add(it.getFile());
        }
        debugUrls = (List)destination$iv$iv;
        this.environment.getLog().debug("Java Home: " + jre);
        $this$map$iv = debugUrls;
        var24_24 = new StringBuilder().append("Class Loader: ").append(baseClassLoader).append(": ");
        var23_22 = this.environment.getLog();
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            $i$a$-filter-EmbeddedServer$createClassLoader$1 = false;
            v0 = it.toString();
            Intrinsics.checkNotNull(jre);
            if (!(StringsKt.startsWith$default(v0, jre, false, 2, null) == false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        var25_25 = (List)destination$iv$iv;
        var23_22.debug(var24_24.append(var25_25).toString());
        $i$f$filter /* !! */  = new Class[]{ApplicationEnvironment.class, Pipeline.class, HttpStatusCode.class, Function1.class, Logger.class, ByteReadChannel.class, Source.class, Attributes.class};
        $i$f$filter /* !! */  = CollectionsKt.listOf($i$f$filter /* !! */ );
        destination$iv = new HashSet<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        $i$f$forEach = false;
        element$iv$iv = $this$forEach$iv$iv.iterator();
        while (element$iv$iv.hasNext()) {
            element$iv = element$iv$iv = element$iv$iv.next();
            $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv = false;
            it = (Class)element$iv;
            $i$a$-mapNotNullTo-EmbeddedServer$createClassLoader$coreUrls$1 = false;
            if (it.getProtectionDomain().getCodeSource().getLocation() == null) continue;
            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv = false;
            destination$iv.add(it$iv);
        }
        coreUrls = (HashSet)destination$iv;
        $this$filter$iv = allUrls;
        $i$f$filter = false;
        $this$forEach$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (E element$iv$iv : $this$filterTo$iv$iv) {
            block13: {
                url = (URL)element$iv$iv;
                $i$a$-filter-EmbeddedServer$createClassLoader$watchUrls$1 = false;
                if (coreUrls.contains(url)) ** GOTO lbl-1000
                $this$any$iv = watchPatterns;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v1 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        pattern = (String)element$iv;
                        $i$a$-any-EmbeddedServer$createClassLoader$watchUrls$1$1 = false;
                        if (!EmbeddedServerJvmKt.checkUrlMatches(url, pattern)) continue;
                        v1 = true;
                        break block13;
                    }
                    v1 = false;
                }
            }
            if (!v1) ** GOTO lbl-1000
            v2 = url.getPath();
            if (v2 == null) {
                v2 = "";
            }
            Intrinsics.checkNotNull(jre);
            if (!StringsKt.startsWith$default(v2, jre, false, 2, null)) {
                v3 = true;
            } else lbl-1000:
            // 3 sources

            {
                v3 = false;
            }
            if (!v3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        watchUrls = (List)destination$iv$iv;
        if (watchUrls.isEmpty()) {
            this.environment.getLog().info("No ktor.deployment.watch patterns match classpath entries, automatic reload is not active");
            return baseClassLoader;
        }
        this.watchUrls(watchUrls);
        return new OverridingClassLoader(watchUrls, baseClassLoader);
    }

    private final void safeRaiseEvent(EventDefinition<Application> event, Application application) {
        EventsKt.raiseCatching$default(this.monitor, event, application, null, 4, null);
    }

    private final void destroyApplication() {
        Application currentApplication = this.applicationInstance;
        ClassLoader currentApplicationClassLoader = this.applicationClassLoader;
        this.applicationInstance = null;
        this.applicationClassLoader = null;
        if (currentApplication != null) {
            this.safeRaiseEvent(DefaultApplicationEventsKt.getApplicationStopping(), currentApplication);
            try {
                currentApplication.dispose();
                OverridingClassLoader overridingClassLoader = currentApplicationClassLoader instanceof OverridingClassLoader ? (OverridingClassLoader)currentApplicationClassLoader : null;
                if (overridingClassLoader != null) {
                    overridingClassLoader.close();
                }
            }
            catch (Throwable e) {
                this.environment.getLog().error("Failed to destroy application instance.", e);
            }
            this.safeRaiseEvent(DefaultApplicationEventsKt.getApplicationStopped(), currentApplication);
        }
        Iterable $this$forEach$iv = this.packageWatchKeys;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WatchKey it = (WatchKey)element$iv;
            boolean bl = false;
            it.cancel();
        }
        this.packageWatchKeys = new ArrayList();
    }

    /*
     * WARNING - void declaration
     */
    private final void watchUrls(List<URL> urls) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        WatchEvent.Modifier[] modifierArray;
        Object element$iv2;
        WatchEvent.Modifier[] modifierArray2;
        HashSet<Path> paths2 = new HashSet<Path>();
        for (URL url2 : urls) {
            Path folder;
            Object $this$watchUrls_u24lambda_u2416;
            Object path;
            if (url2.getPath() == null) continue;
            String decodedPath = URLDecoder.decode((String)path, "utf-8");
            modifierArray2 = this;
            try {
                $this$watchUrls_u24lambda_u2416 = modifierArray2;
                boolean bl = false;
                $this$watchUrls_u24lambda_u2416 = Result.constructor-impl(new File(decodedPath).toPath());
            }
            catch (Throwable throwable) {
                $this$watchUrls_u24lambda_u2416 = Result.constructor-impl(ResultKt.createFailure(throwable));
            }
            modifierArray2 = $this$watchUrls_u24lambda_u2416;
            if ((Path)(Result.isFailure-impl(modifierArray2) ? null : modifierArray2) == null || !Files.exists(folder, new LinkOption[0])) continue;
            SimpleFileVisitor<Path> visitor2 = new SimpleFileVisitor<Path>(paths2){
                final /* synthetic */ HashSet<Path> $paths;
                {
                    this.$paths = $paths;
                }

                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    Intrinsics.checkNotNullParameter(dir, "dir");
                    Intrinsics.checkNotNullParameter(attrs, "attrs");
                    this.$paths.add(dir);
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult visitFile(Path file2, BasicFileAttributes attrs) {
                    Intrinsics.checkNotNullParameter(file2, "file");
                    Intrinsics.checkNotNullParameter(attrs, "attrs");
                    Path dir = file2.getParent();
                    if (dir != null) {
                        this.$paths.add(dir);
                    }
                    return FileVisitResult.CONTINUE;
                }
            };
            if (!Files.isDirectory(folder, new LinkOption[0])) continue;
            Files.walkFileTree(folder, (FileVisitor<? super Path>)visitor2);
        }
        Iterable $this$forEach$iv = paths2;
        boolean $i$f$forEach22 = false;
        for (Object element$iv2 : $this$forEach$iv) {
            Path path = (Path)element$iv2;
            boolean bl = false;
            this.environment.getLog().debug("Watching " + path + " for changes.");
        }
        WatchEvent.Modifier modifier2 = AutoReloadUtilsKt.get_com_sun_nio_file_SensitivityWatchEventModifier_HIGH();
        if (modifier2 != null) {
            WatchEvent.Modifier it = modifier2;
            boolean bl = false;
            modifierArray2 = new WatchEvent.Modifier[]{it};
            modifierArray = modifierArray2;
        } else {
            modifierArray = new WatchEvent.Modifier[]{};
        }
        WatchEvent.Modifier[] modifiers = modifierArray;
        Iterable $i$f$forEach22 = paths2;
        WatchEvent.Modifier[] modifierArray3 = this;
        boolean $i$f$mapNotNull = false;
        element$iv2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            WatchKey watchKey;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Path path = (Path)element$iv$iv;
            boolean bl2 = false;
            if (super.getWatcher() != null) {
                WatchService it;
                boolean bl3 = false;
                WatchEvent.Kind[] kindArray = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
                watchKey = path.register(it, kindArray, Arrays.copyOf(modifiers, modifiers.length));
            } else {
                watchKey = null;
            }
            if (watchKey == null) continue;
            WatchKey it$iv$iv = watchKey;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        modifierArray3.packageWatchKeys = (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final EmbeddedServer<TEngine, TConfiguration> start(boolean wait) {
        ShutdownHookKt.addShutdownHook(this, () -> EmbeddedServer.start$lambda$21(this));
        ReentrantReadWriteLock reentrantReadWriteLock = this.applicationInstanceLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            Pair<Application, ClassLoader> pair;
            boolean bl = false;
            try {
                pair = this.createApplication();
            }
            catch (Throwable cause) {
                this.destroyApplication();
                if (!((Collection)this.watchPatterns).isEmpty()) {
                    this.cleanupWatcher();
                }
                throw cause;
            }
            Pair<Application, ClassLoader> pair2 = pair;
            Application application = pair2.component1();
            ClassLoader classLoader = pair2.component2();
            this.applicationInstance = application;
            this.applicationClassLoader = classLoader;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        BuildersKt.launch$default(CoroutineScopeKt.CoroutineScope(this.getApplication().getCoroutineContext()), null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ EmbeddedServer<TEngine, TConfiguration> this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        this.label = 1;
                        v0 = this.this$0.getEngine().resolvedConnectors(this);
                        if (v0 == var10_2) {
                            return var10_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        var2_3 = (Iterable)v0;
                        var3_4 = this.this$0;
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            it = (EngineConnectorConfig)element$iv;
                            $i$a$-forEach-EmbeddedServer$start$3$1 = false;
                            host = EngineUtilsJvmKt.escapeHostname(it.getHost());
                            v1 = var3_4.getEnvironment().getLog();
                            v2 = new StringBuilder().append("Responding at ");
                            v3 = it.getType().getName().toLowerCase(Locale.ROOT);
                            Intrinsics.checkNotNullExpressionValue(v3, "toLowerCase(...)");
                            v1.info(v2.append(v3).append("://").append(host).append(':').append(it.getPort()).toString());
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
        this.engine.start(wait);
        return this;
    }

    public static /* synthetic */ EmbeddedServer start$default(EmbeddedServer embeddedServer, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return embeddedServer.start(bl);
    }

    @Nullable
    public final Object startSuspend(boolean wait, @NotNull Continuation<? super EmbeddedServer<TEngine, TConfiguration>> $completion) {
        return BuildersKt.withContext(ApplicationUtilsJvmKt.getIOBridge(Dispatchers.INSTANCE), new Function2<CoroutineScope, Continuation<? super EmbeddedServer<TEngine, TConfiguration>>, Object>(this, wait, null){
            int label;
            final /* synthetic */ EmbeddedServer<TEngine, TConfiguration> this$0;
            final /* synthetic */ boolean $wait;
            {
                this.this$0 = $receiver;
                this.$wait = $wait;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        return this.this$0.start(this.$wait);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super EmbeddedServer<TEngine, TConfiguration>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    public static /* synthetic */ Object startSuspend$default(EmbeddedServer embeddedServer, boolean bl, Continuation continuation2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return embeddedServer.startSuspend(bl, continuation2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop(long shutdownGracePeriod, long shutdownTimeout, @NotNull TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter((Object)timeUnit, "timeUnit");
        try {
            this.engine.stop(timeUnit.toMillis(shutdownGracePeriod), timeUnit.toMillis(shutdownTimeout));
        }
        catch (Exception e) {
            this.environment.getLog().warn("Exception occurred during engine shutdown", e);
        }
        ReentrantReadWriteLock reentrantReadWriteLock = this.applicationInstanceLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            this.destroyApplication();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        if (!((Collection)this.watchPatterns).isEmpty()) {
            this.cleanupWatcher();
        }
    }

    public final void stop(long gracePeriodMillis, long timeoutMillis) {
        this.stop(gracePeriodMillis, timeoutMillis, TimeUnit.MILLISECONDS);
    }

    public static /* synthetic */ void stop$default(EmbeddedServer embeddedServer, long l, long l2, int n, Object object) {
        if ((n & 1) != 0) {
            l = ((ApplicationEngine.Configuration)embeddedServer.engineConfig).getShutdownGracePeriod();
        }
        if ((n & 2) != 0) {
            l2 = ((ApplicationEngine.Configuration)embeddedServer.engineConfig).getShutdownGracePeriod();
        }
        embeddedServer.stop(l, l2);
    }

    @Nullable
    public final Object stopSuspend(long gracePeriodMillis, long timeoutMillis, @NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext(ApplicationUtilsJvmKt.getIOBridge(Dispatchers.INSTANCE), (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, gracePeriodMillis, timeoutMillis, null){
            int label;
            final /* synthetic */ EmbeddedServer<TEngine, TConfiguration> this$0;
            final /* synthetic */ long $gracePeriodMillis;
            final /* synthetic */ long $timeoutMillis;
            {
                this.this$0 = $receiver;
                this.$gracePeriodMillis = $gracePeriodMillis;
                this.$timeoutMillis = $timeoutMillis;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        this.this$0.stop(this.$gracePeriodMillis, this.$timeoutMillis);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static /* synthetic */ Object stopSuspend$default(EmbeddedServer embeddedServer, long l, long l2, Continuation continuation2, int n, Object object) {
        if ((n & 1) != 0) {
            l = ((ApplicationEngine.Configuration)embeddedServer.engineConfig).getShutdownGracePeriod();
        }
        if ((n & 2) != 0) {
            l2 = ((ApplicationEngine.Configuration)embeddedServer.engineConfig).getShutdownGracePeriod();
        }
        return embeddedServer.stopSuspend(l, l2, continuation2);
    }

    private final Application instantiateAndConfigureApplication(ClassLoader currentClassLoader) {
        Application application;
        if (this.recreateInstance || this.applicationInstance == null) {
            application = new Application(this.environment, this.rootConfig.getDevelopmentMode(), this.rootConfig.getRootPath(), this.monitor, this.rootConfig.getParentCoroutineContext(), new PropertyReference0Impl(this){

                public Object get() {
                    return ((EmbeddedServer)this.receiver).getEngine();
                }
            });
        } else {
            this.recreateInstance = true;
            Application application2 = this.applicationInstance;
            application = application2;
            Intrinsics.checkNotNull(application2);
        }
        Application newInstance2 = application;
        this.safeRaiseEvent(DefaultApplicationEventsKt.getApplicationStarting(), newInstance2);
        this.avoidingDoubleStartup(() -> EmbeddedServer.instantiateAndConfigureApplication$lambda$25(this, newInstance2, currentClassLoader));
        this.safeRaiseEvent(DefaultApplicationEventsKt.getApplicationStarted(), newInstance2);
        return newInstance2;
    }

    private final Function2<Application, ClassLoader, Unit> dynamicModule(String name) {
        return (arg_0, arg_1) -> EmbeddedServer.dynamicModule$lambda$26(this, name, arg_0, arg_1);
    }

    private final Function2<Application, ClassLoader, Unit> toDynamicModuleOrNull(Function1<? super Application, Unit> $this$toDynamicModuleOrNull) {
        Object $this$toDynamicModuleOrNull_u24lambda_u2427;
        if (!this.rootConfig.getDevelopmentMode()) {
            return null;
        }
        Function1<? super Application, Unit> module = $this$toDynamicModuleOrNull;
        Object object = $this$toDynamicModuleOrNull;
        try {
            $this$toDynamicModuleOrNull_u24lambda_u2427 = object;
            boolean bl = false;
            $this$toDynamicModuleOrNull_u24lambda_u2427 = Result.constructor-impl(ServerHostUtilsKt.methodName((Function)module));
        }
        catch (Throwable bl) {
            $this$toDynamicModuleOrNull_u24lambda_u2427 = Result.constructor-impl(ResultKt.createFailure(bl));
        }
        object = $this$toDynamicModuleOrNull_u24lambda_u2427;
        Throwable throwable = Result.exceptionOrNull-impl(object);
        if (throwable != null) {
            Object cause = $this$toDynamicModuleOrNull_u24lambda_u2427 = throwable;
            boolean bl = false;
            this.environment.getLog().debug("Module can't be loaded dynamically, auto-reloading won't work for this module", (Throwable)cause);
        }
        Throwable throwable2 = Result.exceptionOrNull-impl(object);
        if (throwable2 != null) {
            Throwable it = throwable2;
            boolean bl = false;
            return null;
        }
        String name = (String)object;
        return (arg_0, arg_1) -> EmbeddedServer.toDynamicModuleOrNull$lambda$30(this, name, module, arg_0, arg_1);
    }

    private final Function2<Application, ClassLoader, Unit> wrapWithDynamicModule(Function1<? super Application, Unit> $this$wrapWithDynamicModule) {
        Function1<? super Application, Unit> module = $this$wrapWithDynamicModule;
        return (arg_0, arg_1) -> EmbeddedServer.wrapWithDynamicModule$lambda$31(module, arg_0, arg_1);
    }

    private final void launchModuleByName(String name, ClassLoader currentClassLoader, Application newInstance2) {
        this.avoidingDoubleStartupFor(name, () -> EmbeddedServer.launchModuleByName$lambda$32(currentClassLoader, name, newInstance2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void avoidingDoubleStartup(Function0<Unit> block) {
        try {
            block.invoke();
        }
        finally {
            List<String> list = AutoReloadUtilsKt.getCurrentStartupModules().get();
            if (list != null) {
                List<String> it = list;
                boolean bl = false;
                if (it.isEmpty()) {
                    AutoReloadUtilsKt.getCurrentStartupModules().remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void avoidingDoubleStartupFor(String fqName2, Function0<Unit> block) {
        List modules;
        ThreadLocal<List<String>> threadLocal = AutoReloadUtilsKt.getCurrentStartupModules();
        List list = threadLocal.get();
        if (list == null) {
            boolean bl = false;
            List list2 = bl = (List)new ArrayList(1);
            threadLocal.set(list2);
            list = bl;
        }
        if (!(!(modules = list).contains(fqName2))) {
            boolean bl = false;
            String string = "Module startup is already in progress for function " + fqName2 + " (recursive module startup from module main?)";
            throw new IllegalStateException(string.toString());
        }
        modules.add((String)fqName2);
        try {
            block.invoke();
        }
        finally {
            modules.remove(fqName2);
        }
    }

    private final void cleanupWatcher() {
        EmbeddedServer embeddedServer = this;
        try {
            Unit unit;
            EmbeddedServer $this$cleanupWatcher_u24lambda_u2436 = embeddedServer;
            boolean bl = false;
            WatchService watchService = $this$cleanupWatcher_u24lambda_u2436.getWatcher();
            if (watchService != null) {
                watchService.close();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Object object = Result.constructor-impl(unit);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl(ResultKt.createFailure(throwable));
        }
    }

    private static final Unit _init_$lambda$0(ApplicationEngine.Configuration configuration) {
        Intrinsics.checkNotNullParameter(configuration, "<this>");
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final List modules_delegate$lambda$2(EmbeddedServer this$0) {
        Function1 p0;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = this$0.configModulesNames;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this$0.dynamicModule((String)((Object)p0)));
        }
        $this$map$iv = this$0.rootConfig.getModules$ktor_server_core();
        collection = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void module;
            p0 = (Function1)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Function2<Application, ClassLoader, Unit> function2 = this$0.toDynamicModuleOrNull((Function1<Application, Unit>)module);
            if (function2 == null) {
                function2 = this$0.wrapWithDynamicModule((Function1<Application, Unit>)module);
            }
            collection2.add(function2);
        }
        return CollectionsKt.plus(collection, (Iterable)((List)destination$iv$iv));
    }

    private static final WatchService watcher_delegate$lambda$3() {
        WatchService watchService;
        try {
            watchService = FileSystems.getDefault().newWatchService();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            watchService = null;
        }
        return watchService;
    }

    private static final Unit start$lambda$21(EmbeddedServer this$0) {
        EmbeddedServer.stop$default(this$0, 0L, 0L, 3, null);
        return Unit.INSTANCE;
    }

    private static final Unit instantiateAndConfigureApplication$lambda$25(EmbeddedServer this$0, Application $newInstance, ClassLoader $currentClassLoader) {
        Iterable $this$forEach$iv = this$0.getModules();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function2 module = (Function2)element$iv;
            boolean bl = false;
            module.invoke($newInstance, $currentClassLoader);
        }
        return Unit.INSTANCE;
    }

    private static final Unit dynamicModule$lambda$26(EmbeddedServer this$0, String $name, Application application, ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter(application, "<this>");
        Intrinsics.checkNotNullParameter(classLoader, "classLoader");
        Application application2 = application;
        this$0.launchModuleByName($name, classLoader, application2);
        return Unit.INSTANCE;
    }

    private static final Unit toDynamicModuleOrNull$lambda$30(EmbeddedServer this$0, String $name, Function1 $module, Application application, ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter(application, "<this>");
        Intrinsics.checkNotNullParameter(classLoader, "classLoader");
        Application application2 = application;
        try {
            this$0.launchModuleByName($name, classLoader, application2);
        }
        catch (ReloadingException cause) {
            application.getEnvironment().getLog().debug("Failed to load module '" + $name + "' by classpath reference, falling back to currently loaded value", cause);
            $module.invoke(application2);
        }
        return Unit.INSTANCE;
    }

    private static final Unit wrapWithDynamicModule$lambda$31(Function1 $module, Application application, ClassLoader it) {
        Intrinsics.checkNotNullParameter(application, "<this>");
        Intrinsics.checkNotNullParameter(it, "it");
        $module.invoke(application);
        return Unit.INSTANCE;
    }

    private static final Unit launchModuleByName$lambda$32(ClassLoader $currentClassLoader, String $name, Application $newInstance) {
        CallableUtilsKt.executeModuleFunction($currentClassLoader, $name, $newInstance);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Application access$currentApplication(EmbeddedServer $this) {
        return $this.currentApplication();
    }
}

