/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.ParametersBuilder;
import io.ktor.http.ParametersKt;
import io.ktor.http.QueryKt;
import io.ktor.http.URLBuilder;
import io.ktor.http.URLBuilderKt;
import io.ktor.http.URLParserException;
import io.ktor.http.URLParserKt;
import io.ktor.http.Url;
import io.ktor.util.StringValuesBuilder;
import io.ktor.util.StringValuesKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000N\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\u001a\u0015\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u0015\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0003\u0010\u0007\u001a&\u0010\f\u001a\u00020\u00022\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\b\n\u00a2\u0006\u0004\b\f\u0010\r\u001a\u0017\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u000e\u0010\u0004\u001a\u0015\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a\u0015\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0012\u001a\u0015\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000f\u0010\u0013\u001a\u0019\u0010\u0014\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0014\u0010\u0015\u001a\u0019\u0010\u0014\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0016\u001a/\u0010\u001d\u001a\u00020\t*\u00060\u0017j\u0002`\u00182\u0006\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001bH\u0000\u00a2\u0006\u0004\b\u001d\u0010\u001e\u001a-\u0010\u001d\u001a\u00020\t*\u00060\u0017j\u0002`\u00182\u0006\u0010\u0019\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001d\u0010!\u001a+\u0010&\u001a\u00020\t*\u00060\"j\u0002`#2\b\u0010$\u001a\u0004\u0018\u00010\u00002\b\u0010%\u001a\u0004\u0018\u00010\u0000H\u0000\u00a2\u0006\u0004\b&\u0010'\"\u0015\u0010*\u001a\u00020\u0000*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\"\u0015\u0010,\u001a\u00020\u0000*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b+\u0010)\"\u0015\u0010.\u001a\u00020\u0000*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b-\u0010)\"\u0015\u0010/\u001a\u00020\u001b*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b/\u00100\"\u0015\u00101\u001a\u00020\u001b*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b1\u00100\"\u0015\u0010/\u001a\u00020\u001b*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b/\u00102\"\u0015\u00101\u001a\u00020\u001b*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b1\u00102\u00a8\u00063"}, d2={"", "urlString", "Lio/ktor/http/Url;", "Url", "(Ljava/lang/String;)Lio/ktor/http/Url;", "Lio/ktor/http/URLBuilder;", "builder", "(Lio/ktor/http/URLBuilder;)Lio/ktor/http/Url;", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "block", "buildUrl", "(Lkotlin/jvm/functions/Function1;)Lio/ktor/http/Url;", "parseUrl", "URLBuilder", "(Ljava/lang/String;)Lio/ktor/http/URLBuilder;", "url", "(Lio/ktor/http/Url;)Lio/ktor/http/URLBuilder;", "(Lio/ktor/http/URLBuilder;)Lio/ktor/http/URLBuilder;", "takeFrom", "(Lio/ktor/http/URLBuilder;Lio/ktor/http/URLBuilder;)Lio/ktor/http/URLBuilder;", "(Lio/ktor/http/URLBuilder;Lio/ktor/http/Url;)Lio/ktor/http/URLBuilder;", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "encodedPath", "encodedQuery", "", "trailingQuery", "appendUrlFullPath", "(Ljava/lang/Appendable;Ljava/lang/String;Ljava/lang/String;Z)V", "Lio/ktor/http/ParametersBuilder;", "encodedQueryParameters", "(Ljava/lang/Appendable;Ljava/lang/String;Lio/ktor/http/ParametersBuilder;Z)V", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "encodedUser", "encodedPassword", "appendUserAndPassword", "(Ljava/lang/StringBuilder;Ljava/lang/String;Ljava/lang/String;)V", "getFullPath", "(Lio/ktor/http/Url;)Ljava/lang/String;", "fullPath", "getHostWithPort", "hostWithPort", "getHostWithPortIfSpecified", "hostWithPortIfSpecified", "isAbsolutePath", "(Lio/ktor/http/Url;)Z", "isRelativePath", "(Lio/ktor/http/URLBuilder;)Z", "ktor-http"})
@SourceDebugExtension(value={"SMAP\nURLUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 URLUtils.kt\nio/ktor/http/URLUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,226:1\n1#2:227\n1374#3:228\n1460#3,2:229\n1563#3:231\n1634#3,3:232\n1462#3,3:235\n*S KotlinDebug\n*F\n+ 1 URLUtils.kt\nio/ktor/http/URLUtilsKt\n*L\n171#1:228\n171#1:229,2\n172#1:231\n172#1:232,3\n171#1:235,3\n*E\n"})
public final class URLUtilsKt {
    @NotNull
    public static final Url Url(@NotNull String urlString) {
        Intrinsics.checkNotNullParameter(urlString, "urlString");
        return URLUtilsKt.URLBuilder(urlString).build();
    }

    @NotNull
    public static final Url Url(@NotNull URLBuilder builder) {
        Intrinsics.checkNotNullParameter(builder, "builder");
        return URLUtilsKt.takeFrom(new URLBuilder(null, null, 0, null, null, null, null, null, false, 511, null), builder).build();
    }

    @NotNull
    public static final Url buildUrl(@NotNull Function1<? super URLBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter(block, "block");
        URLBuilder uRLBuilder = new URLBuilder(null, null, 0, null, null, null, null, null, false, 511, null);
        block.invoke(uRLBuilder);
        return uRLBuilder.build();
    }

    @Nullable
    public static final Url parseUrl(@NotNull String urlString) {
        Url url2;
        Intrinsics.checkNotNullParameter(urlString, "urlString");
        try {
            URLBuilder uRLBuilder;
            URLBuilder it = uRLBuilder = URLUtilsKt.URLBuilder(urlString);
            boolean bl = false;
            URLBuilder uRLBuilder2 = ((CharSequence)it.getHost()).length() > 0 ? uRLBuilder : null;
            url2 = uRLBuilder2 != null ? uRLBuilder2.build() : null;
        }
        catch (URLParserException cause) {
            url2 = null;
        }
        return url2;
    }

    @NotNull
    public static final URLBuilder URLBuilder(@NotNull String urlString) {
        Intrinsics.checkNotNullParameter(urlString, "urlString");
        return URLParserKt.takeFrom(new URLBuilder(null, null, 0, null, null, null, null, null, false, 511, null), urlString);
    }

    @NotNull
    public static final URLBuilder URLBuilder(@NotNull Url url2) {
        Intrinsics.checkNotNullParameter(url2, "url");
        return URLUtilsKt.takeFrom(new URLBuilder(null, null, 0, null, null, null, null, null, false, 511, null), url2);
    }

    @NotNull
    public static final URLBuilder URLBuilder(@NotNull URLBuilder builder) {
        Intrinsics.checkNotNullParameter(builder, "builder");
        return URLUtilsKt.takeFrom(new URLBuilder(null, null, 0, null, null, null, null, null, false, 511, null), builder);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final URLBuilder takeFrom(@NotNull URLBuilder $this$takeFrom, @NotNull URLBuilder url2) {
        void $this$takeFrom_u24lambda_u241;
        ParametersBuilder parametersBuilder;
        Intrinsics.checkNotNullParameter($this$takeFrom, "<this>");
        Intrinsics.checkNotNullParameter(url2, "url");
        $this$takeFrom.setProtocolOrNull(url2.getProtocolOrNull());
        $this$takeFrom.setHost(url2.getHost());
        $this$takeFrom.setPort(url2.getPort());
        $this$takeFrom.setEncodedPathSegments(url2.getEncodedPathSegments());
        $this$takeFrom.setEncodedUser(url2.getEncodedUser());
        $this$takeFrom.setEncodedPassword(url2.getEncodedPassword());
        ParametersBuilder parametersBuilder2 = parametersBuilder = ParametersKt.ParametersBuilder$default(0, 1, null);
        URLBuilder uRLBuilder = $this$takeFrom;
        boolean bl = false;
        StringValuesKt.appendAll((StringValuesBuilder)$this$takeFrom_u24lambda_u241, url2.getEncodedParameters());
        uRLBuilder.setEncodedParameters(parametersBuilder);
        $this$takeFrom.setEncodedFragment(url2.getEncodedFragment());
        $this$takeFrom.setTrailingQuery(url2.getTrailingQuery());
        return $this$takeFrom;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final URLBuilder takeFrom(@NotNull URLBuilder $this$takeFrom, @NotNull Url url2) {
        void $this$takeFrom_u24lambda_u242;
        ParametersBuilder parametersBuilder;
        Intrinsics.checkNotNullParameter($this$takeFrom, "<this>");
        Intrinsics.checkNotNullParameter(url2, "url");
        $this$takeFrom.setProtocolOrNull(url2.getProtocolOrNull());
        $this$takeFrom.setHost(url2.getHost());
        $this$takeFrom.setPort(url2.getPort());
        URLBuilderKt.setEncodedPath($this$takeFrom, url2.getEncodedPath());
        $this$takeFrom.setEncodedUser(url2.getEncodedUser());
        $this$takeFrom.setEncodedPassword(url2.getEncodedPassword());
        ParametersBuilder parametersBuilder2 = parametersBuilder = ParametersKt.ParametersBuilder$default(0, 1, null);
        URLBuilder uRLBuilder = $this$takeFrom;
        boolean bl = false;
        $this$takeFrom_u24lambda_u242.appendAll(QueryKt.parseQueryString$default(url2.getEncodedQuery(), 0, 0, false, 6, null));
        uRLBuilder.setEncodedParameters(parametersBuilder);
        $this$takeFrom.setEncodedFragment(url2.getEncodedFragment());
        $this$takeFrom.setTrailingQuery(url2.getTrailingQuery());
        return $this$takeFrom;
    }

    @NotNull
    public static final String getFullPath(@NotNull Url $this$fullPath) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter($this$fullPath, "<this>");
        StringBuilder $this$_get_fullPath__u24lambda_u243 = stringBuilder = new StringBuilder();
        boolean bl = false;
        URLUtilsKt.appendUrlFullPath((Appendable)$this$_get_fullPath__u24lambda_u243, $this$fullPath.getEncodedPath(), $this$fullPath.getEncodedQuery(), $this$fullPath.getTrailingQuery());
        return stringBuilder.toString();
    }

    @NotNull
    public static final String getHostWithPort(@NotNull Url $this$hostWithPort) {
        Intrinsics.checkNotNullParameter($this$hostWithPort, "<this>");
        return $this$hostWithPort.getHost() + ':' + $this$hostWithPort.getPort();
    }

    @NotNull
    public static final String getHostWithPortIfSpecified(@NotNull Url $this$hostWithPortIfSpecified) {
        Intrinsics.checkNotNullParameter($this$hostWithPortIfSpecified, "<this>");
        int n = $this$hostWithPortIfSpecified.getSpecifiedPort();
        return n == 0 || n == $this$hostWithPortIfSpecified.getProtocol().getDefaultPort() ? $this$hostWithPortIfSpecified.getHost() : URLUtilsKt.getHostWithPort($this$hostWithPortIfSpecified);
    }

    public static final void appendUrlFullPath(@NotNull Appendable $this$appendUrlFullPath, @NotNull String encodedPath, @NotNull String encodedQuery, boolean trailingQuery) {
        Intrinsics.checkNotNullParameter($this$appendUrlFullPath, "<this>");
        Intrinsics.checkNotNullParameter(encodedPath, "encodedPath");
        Intrinsics.checkNotNullParameter(encodedQuery, "encodedQuery");
        if (!StringsKt.isBlank(encodedPath) && !StringsKt.startsWith$default(encodedPath, "/", false, 2, null)) {
            $this$appendUrlFullPath.append('/');
        }
        $this$appendUrlFullPath.append(encodedPath);
        if (((CharSequence)encodedQuery).length() > 0 || trailingQuery) {
            $this$appendUrlFullPath.append("?");
        }
        $this$appendUrlFullPath.append(encodedQuery);
    }

    /*
     * WARNING - void declaration
     */
    public static final void appendUrlFullPath(@NotNull Appendable $this$appendUrlFullPath, @NotNull String encodedPath, @NotNull ParametersBuilder encodedQueryParameters, boolean trailingQuery) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter($this$appendUrlFullPath, "<this>");
        Intrinsics.checkNotNullParameter(encodedPath, "encodedPath");
        Intrinsics.checkNotNullParameter(encodedQueryParameters, "encodedQueryParameters");
        if (!StringsKt.isBlank(encodedPath) && !StringsKt.startsWith$default(encodedPath, "/", false, 2, null)) {
            $this$appendUrlFullPath.append('/');
        }
        $this$appendUrlFullPath.append(encodedPath);
        if (!encodedQueryParameters.isEmpty() || trailingQuery) {
            $this$appendUrlFullPath.append("?");
        }
        Iterable iterable = encodedQueryParameters.entries();
        boolean $i$f$flatMap = false;
        void var6_6 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            String key2 = (String)entry.getKey();
            List value = (List)entry.getValue();
            if (value.isEmpty()) {
                list = CollectionsKt.listOf(TuplesKt.to(key2, null));
            } else {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = value;
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(TuplesKt.to(key2, it));
                }
                list = (List)destination$iv$iv2;
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        CollectionsKt.joinTo$default((List)destination$iv$iv, $this$appendUrlFullPath, "&", null, null, 0, null, URLUtilsKt::appendUrlFullPath$lambda$6, 60, null);
    }

    public static final boolean isAbsolutePath(@NotNull Url $this$isAbsolutePath) {
        Intrinsics.checkNotNullParameter($this$isAbsolutePath, "<this>");
        return Intrinsics.areEqual(CollectionsKt.firstOrNull($this$isAbsolutePath.getRawSegments()), "");
    }

    public static final boolean isRelativePath(@NotNull Url $this$isRelativePath) {
        Intrinsics.checkNotNullParameter($this$isRelativePath, "<this>");
        return !URLUtilsKt.isAbsolutePath($this$isRelativePath);
    }

    public static final boolean isAbsolutePath(@NotNull URLBuilder $this$isAbsolutePath) {
        Intrinsics.checkNotNullParameter($this$isAbsolutePath, "<this>");
        return Intrinsics.areEqual(CollectionsKt.firstOrNull($this$isAbsolutePath.getPathSegments()), "");
    }

    public static final boolean isRelativePath(@NotNull URLBuilder $this$isRelativePath) {
        Intrinsics.checkNotNullParameter($this$isRelativePath, "<this>");
        return !URLUtilsKt.isAbsolutePath($this$isRelativePath);
    }

    public static final void appendUserAndPassword(@NotNull StringBuilder $this$appendUserAndPassword, @Nullable String encodedUser, @Nullable String encodedPassword) {
        Intrinsics.checkNotNullParameter($this$appendUserAndPassword, "<this>");
        if (encodedUser == null) {
            return;
        }
        $this$appendUserAndPassword.append(encodedUser);
        if (encodedPassword != null) {
            $this$appendUserAndPassword.append(':');
            $this$appendUserAndPassword.append(encodedPassword);
        }
        $this$appendUserAndPassword.append("@");
    }

    private static final CharSequence appendUrlFullPath$lambda$6(Pair it) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter(it, "it");
        String key2 = (String)it.getFirst();
        if (it.getSecond() == null) {
            charSequence = key2;
        } else {
            String value = String.valueOf(it.getSecond());
            charSequence = key2 + '=' + value;
        }
        return charSequence;
    }
}

