/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.CookieDateBuilder;
import io.ktor.http.CookieUtilsKt;
import io.ktor.http.InvalidCookieDateException;
import io.ktor.http.StringLexer;
import io.ktor.util.date.GMTDate;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\n\u001a\u00020\t\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\b\u0010\b\u001a\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ-\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lio/ktor/http/CookieDateParser;", "", "<init>", "()V", "T", "", "source", "name", "field", "", "checkFieldNotNull", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)V", "", "requirement", "Lkotlin/Function0;", "msg", "checkRequirement", "(Ljava/lang/String;ZLkotlin/jvm/functions/Function0;)V", "Lio/ktor/util/date/GMTDate;", "parse", "(Ljava/lang/String;)Lio/ktor/util/date/GMTDate;", "ktor-http"})
@SourceDebugExtension(value={"SMAP\nCookieUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CookieUtils.kt\nio/ktor/http/CookieDateParser\n+ 2 CookieUtils.kt\nio/ktor/http/StringLexer\n*L\n1#1,349:1\n56#2,3:350\n*S KotlinDebug\n*F\n+ 1 CookieUtils.kt\nio/ktor/http/CookieDateParser\n*L\n294#1:350,3\n*E\n"})
public final class CookieDateParser {
    private final <T> void checkFieldNotNull(String source, String name, T field) {
        if (field == null) {
            throw new InvalidCookieDateException(source, "Could not find " + name);
        }
    }

    private final void checkRequirement(String source, boolean requirement, Function0<String> msg) {
        if (!requirement) {
            throw new InvalidCookieDateException(source, msg.invoke());
        }
    }

    @NotNull
    public final GMTDate parse(@NotNull String source) {
        Intrinsics.checkNotNullParameter(source, "source");
        StringLexer lexer = new StringLexer(source);
        CookieDateBuilder builder = new CookieDateBuilder();
        lexer.acceptWhile(CookieDateParser::parse$lambda$0);
        while (lexer.getHasRemaining()) {
            String token2;
            if (!lexer.test(CookieDateParser::parse$lambda$1)) continue;
            StringLexer this_$iv = lexer;
            boolean $i$f$capture = false;
            int start$iv = this_$iv.getIndex();
            StringLexer $this$parse_u24lambda_u243 = this_$iv;
            boolean bl = false;
            $this$parse_u24lambda_u243.acceptWhile(CookieDateParser::parse$lambda$3$lambda$2);
            Intrinsics.checkNotNullExpressionValue(this_$iv.getSource().substring(start$iv, this_$iv.getIndex()), "substring(...)");
            CookieUtilsKt.handleToken(builder, token2);
            lexer.acceptWhile(CookieDateParser::parse$lambda$4);
        }
        Object object = builder.getYear();
        Object object2 = new IntRange(70, 99);
        if (object != null && ((IntRange)object2).contains((Integer)object)) {
            Integer n = builder.getYear();
            Intrinsics.checkNotNull(n);
            builder.setYear(n + 1900);
        } else {
            object2 = new IntRange(0, 69);
            if (object != null && ((IntRange)object2).contains((Integer)object)) {
                Integer n = builder.getYear();
                Intrinsics.checkNotNull(n);
                builder.setYear(n + 2000);
            }
        }
        this.checkFieldNotNull(source, "day-of-month", builder.getDayOfMonth());
        this.checkFieldNotNull(source, "month", builder.getMonth());
        this.checkFieldNotNull(source, "year", builder.getYear());
        this.checkFieldNotNull(source, "time", builder.getHours());
        this.checkFieldNotNull(source, "time", builder.getMinutes());
        this.checkFieldNotNull(source, "time", builder.getSeconds());
        object = new IntRange(1, 31);
        object2 = builder.getDayOfMonth();
        this.checkRequirement(source, object2 != null && ((IntRange)object).contains((Integer)object2), CookieDateParser::parse$lambda$5);
        Integer n = builder.getYear();
        Intrinsics.checkNotNull(n);
        this.checkRequirement(source, n >= 1601, CookieDateParser::parse$lambda$6);
        Integer n2 = builder.getHours();
        Intrinsics.checkNotNull(n2);
        this.checkRequirement(source, n2 <= 23, CookieDateParser::parse$lambda$7);
        Integer n3 = builder.getMinutes();
        Intrinsics.checkNotNull(n3);
        this.checkRequirement(source, n3 <= 59, CookieDateParser::parse$lambda$8);
        Integer n4 = builder.getSeconds();
        Intrinsics.checkNotNull(n4);
        this.checkRequirement(source, n4 <= 59, CookieDateParser::parse$lambda$9);
        return builder.build();
    }

    private static final boolean parse$lambda$0(char it) {
        return CookieUtilsKt.isDelimiter(it);
    }

    private static final boolean parse$lambda$1(char it) {
        return CookieUtilsKt.isNonDelimiter(it);
    }

    private static final boolean parse$lambda$3$lambda$2(char it) {
        return CookieUtilsKt.isNonDelimiter(it);
    }

    private static final boolean parse$lambda$4(char it) {
        return CookieUtilsKt.isDelimiter(it);
    }

    private static final String parse$lambda$5() {
        return "day-of-month not in [1,31]";
    }

    private static final String parse$lambda$6() {
        return "year >= 1601";
    }

    private static final String parse$lambda$7() {
        return "hours > 23";
    }

    private static final String parse$lambda$8() {
        return "minutes > 59";
    }

    private static final String parse$lambda$9() {
        return "seconds > 59";
    }
}

