/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common.util;

import de.gematik.test.tiger.common.config.TigerConfigurationKeys;
import java.security.Provider;
import java.security.Security;
import lombok.Generated;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jsse.provider.BouncyCastleJsseProvider;
import org.bouncycastle.pqc.jcajce.provider.BouncyCastlePQCProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerSecurityProviderInitialiser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerSecurityProviderInitialiser.class);
    private static boolean isInitialised = false;

    public static synchronized void initialize() {
        if (!isInitialised) {
            Security.setProperty("ssl.KeyManagerFactory.algorithm", "PKIX");
            Security.removeProvider("BC");
            Security.insertProviderAt((Provider)new BouncyCastleProvider(), 1);
            Security.removeProvider("BCJSSE");
            Security.insertProviderAt((Provider)new BouncyCastleJsseProvider(), 2);
            System.setProperty("jdk.tls.namedGroups", String.join((CharSequence)",", TigerConfigurationKeys.TIGER_PROXY_DEFAULT_NAMED_GROUPS.getValueOrDefault()));
            Security.addProvider((Provider)new BouncyCastlePQCProvider());
            isInitialised = true;
        }
    }
}

