/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common.util;

import de.gematik.rbellogger.util.RbelSocketAddress;
import java.util.Arrays;
import lombok.Generated;

public final class TcpIpConnectionIdentifier {
    private final RbelSocketAddress sender;
    private final RbelSocketAddress receiver;
    private final boolean originalDirection;
    private final RbelSocketAddress sortedAddress1;
    private final RbelSocketAddress sortedAddress2;

    public TcpIpConnectionIdentifier(RbelSocketAddress sender, RbelSocketAddress receiver) {
        RbelSocketAddress normA = TcpIpConnectionIdentifier.normalize(sender);
        RbelSocketAddress normB = TcpIpConnectionIdentifier.normalize(receiver);
        if (TcpIpConnectionIdentifier.compareAddresses(normA, normB) < 0) {
            this.sortedAddress1 = normA;
            this.sortedAddress2 = normB;
            this.originalDirection = true;
        } else {
            this.sortedAddress1 = normB;
            this.sortedAddress2 = normA;
            this.originalDirection = false;
        }
        this.sender = sender;
        this.receiver = receiver;
    }

    private static RbelSocketAddress normalize(RbelSocketAddress address) {
        return address;
    }

    private static int compareAddresses(RbelSocketAddress a, RbelSocketAddress b) {
        if (a.getAddress() != null && b.getAddress() != null && a.getAddress().getIpAddress() != null && b.getAddress().getIpAddress() != null) {
            int ipCompare = Arrays.compare(a.getAddress().getIpAddress(), b.getAddress().getIpAddress());
            return ipCompare != 0 ? ipCompare : Integer.compare(a.getPort(), b.getPort());
        }
        if (a.getAddress().getHostname() != null && b.getAddress().getHostname() != null) {
            int ipCompare = a.getAddress().getHostname().compareTo(b.getAddress().getHostname());
            return ipCompare != 0 ? ipCompare : Integer.compare(a.getPort(), b.getPort());
        }
        return -1;
    }

    public boolean isSameDirectionAs(TcpIpConnectionIdentifier other) {
        return this.originalDirection == other.originalDirection;
    }

    public String printDirectionSymbol() {
        if (this.originalDirection) {
            return "->";
        }
        return "<-";
    }

    public TcpIpConnectionIdentifier reverse() {
        return new TcpIpConnectionIdentifier(this.receiver, this.sender);
    }

    public String toString() {
        return "{" + String.valueOf(this.sortedAddress1) + ", " + String.valueOf(this.sortedAddress2) + ", (" + this.printDirectionSymbol() + ")}";
    }

    @Generated
    public RbelSocketAddress sender() {
        return this.sender;
    }

    @Generated
    public RbelSocketAddress receiver() {
        return this.receiver;
    }

    @Generated
    public boolean originalDirection() {
        return this.originalDirection;
    }

    @Generated
    public RbelSocketAddress sortedAddress1() {
        return this.sortedAddress1;
    }

    @Generated
    public RbelSocketAddress sortedAddress2() {
        return this.sortedAddress2;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TcpIpConnectionIdentifier)) {
            return false;
        }
        TcpIpConnectionIdentifier other = (TcpIpConnectionIdentifier)o;
        RbelSocketAddress this$sortedAddress1 = this.sortedAddress1();
        RbelSocketAddress other$sortedAddress1 = other.sortedAddress1();
        if (this$sortedAddress1 == null ? other$sortedAddress1 != null : !((Object)this$sortedAddress1).equals(other$sortedAddress1)) {
            return false;
        }
        RbelSocketAddress this$sortedAddress2 = this.sortedAddress2();
        RbelSocketAddress other$sortedAddress2 = other.sortedAddress2();
        return !(this$sortedAddress2 == null ? other$sortedAddress2 != null : !((Object)this$sortedAddress2).equals(other$sortedAddress2));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RbelSocketAddress $sortedAddress1 = this.sortedAddress1();
        result = result * 59 + ($sortedAddress1 == null ? 43 : ((Object)$sortedAddress1).hashCode());
        RbelSocketAddress $sortedAddress2 = this.sortedAddress2();
        result = result * 59 + ($sortedAddress2 == null ? 43 : ((Object)$sortedAddress2).hashCode());
        return result;
    }
}

