/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common.pki;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.gematik.test.tiger.common.pki.TigerPkiIdentityLoader;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;

public class TigerPkiIdentityInformation {
    private List<String> filenames;
    private String password;
    private String alias;
    private TigerPkiIdentityLoader.StoreType storeType;
    @JsonIgnore
    private List<String> aliasesOrPasswords;
    @JsonIgnore
    private boolean useCompactFormat = false;

    @JsonIgnore
    public TigerPkiIdentityLoader.StoreType getOrGuessStoreType() {
        if (this.storeType != null) {
            return this.storeType;
        }
        return TigerPkiIdentityLoader.guessStoreType(this.filenames).orElseThrow(() -> new IllegalArgumentException("Unable to guess store type for filenames '" + String.valueOf(this.filenames) + "'"));
    }

    public String generateCompactFormat() {
        if (this.filenames == null) {
            return "";
        }
        return String.join((CharSequence)";", this.filenames) + (String)(this.aliasesOrPasswords.isEmpty() ? "" : ";" + String.join((CharSequence)";", this.aliasesOrPasswords)) + (String)(this.password != null ? ";" + this.password : "") + (String)(this.alias != null ? ";" + this.alias : "") + ";" + String.valueOf((Object)this.getOrGuessStoreType());
    }

    @Generated
    private static List<String> $default$aliasesOrPasswords() {
        return List.of();
    }

    @Generated
    public static TigerPkiIdentityInformationBuilder builder() {
        return new TigerPkiIdentityInformationBuilder();
    }

    @Generated
    public TigerPkiIdentityInformationBuilder toBuilder() {
        return new TigerPkiIdentityInformationBuilder().filenames(this.filenames).password(this.password).alias(this.alias).storeType(this.storeType).aliasesOrPasswords(this.aliasesOrPasswords).useCompactFormat(this.useCompactFormat);
    }

    @Generated
    public List<String> getFilenames() {
        return this.filenames;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getAlias() {
        return this.alias;
    }

    @Generated
    public TigerPkiIdentityLoader.StoreType getStoreType() {
        return this.storeType;
    }

    @Generated
    public List<String> getAliasesOrPasswords() {
        return this.aliasesOrPasswords;
    }

    @Generated
    public boolean isUseCompactFormat() {
        return this.useCompactFormat;
    }

    @Generated
    public void setFilenames(List<String> filenames) {
        this.filenames = filenames;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Generated
    public void setStoreType(TigerPkiIdentityLoader.StoreType storeType) {
        this.storeType = storeType;
    }

    @Generated
    public void setAliasesOrPasswords(List<String> aliasesOrPasswords) {
        this.aliasesOrPasswords = aliasesOrPasswords;
    }

    @Generated
    public void setUseCompactFormat(boolean useCompactFormat) {
        this.useCompactFormat = useCompactFormat;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TigerPkiIdentityInformation)) {
            return false;
        }
        TigerPkiIdentityInformation other = (TigerPkiIdentityInformation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUseCompactFormat() != other.isUseCompactFormat()) {
            return false;
        }
        List<String> this$filenames = this.getFilenames();
        List<String> other$filenames = other.getFilenames();
        if (this$filenames == null ? other$filenames != null : !((Object)this$filenames).equals(other$filenames)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        TigerPkiIdentityLoader.StoreType this$storeType = this.getStoreType();
        TigerPkiIdentityLoader.StoreType other$storeType = other.getStoreType();
        if (this$storeType == null ? other$storeType != null : !((Object)((Object)this$storeType)).equals((Object)other$storeType)) {
            return false;
        }
        List<String> this$aliasesOrPasswords = this.getAliasesOrPasswords();
        List<String> other$aliasesOrPasswords = other.getAliasesOrPasswords();
        return !(this$aliasesOrPasswords == null ? other$aliasesOrPasswords != null : !((Object)this$aliasesOrPasswords).equals(other$aliasesOrPasswords));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TigerPkiIdentityInformation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUseCompactFormat() ? 79 : 97);
        List<String> $filenames = this.getFilenames();
        result = result * 59 + ($filenames == null ? 43 : ((Object)$filenames).hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        TigerPkiIdentityLoader.StoreType $storeType = this.getStoreType();
        result = result * 59 + ($storeType == null ? 43 : ((Object)((Object)$storeType)).hashCode());
        List<String> $aliasesOrPasswords = this.getAliasesOrPasswords();
        result = result * 59 + ($aliasesOrPasswords == null ? 43 : ((Object)$aliasesOrPasswords).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TigerPkiIdentityInformation(filenames=" + String.valueOf(this.getFilenames()) + ", password=" + this.getPassword() + ", alias=" + this.getAlias() + ", storeType=" + String.valueOf((Object)this.getStoreType()) + ", aliasesOrPasswords=" + String.valueOf(this.getAliasesOrPasswords()) + ", useCompactFormat=" + this.isUseCompactFormat() + ")";
    }

    @Generated
    public TigerPkiIdentityInformation() {
        this.aliasesOrPasswords = TigerPkiIdentityInformation.$default$aliasesOrPasswords();
    }

    @ConstructorProperties(value={"filenames", "password", "alias", "storeType", "aliasesOrPasswords", "useCompactFormat"})
    @Generated
    public TigerPkiIdentityInformation(List<String> filenames, String password, String alias, TigerPkiIdentityLoader.StoreType storeType, List<String> aliasesOrPasswords, boolean useCompactFormat) {
        this.filenames = filenames;
        this.password = password;
        this.alias = alias;
        this.storeType = storeType;
        this.aliasesOrPasswords = aliasesOrPasswords;
        this.useCompactFormat = useCompactFormat;
    }

    @Generated
    public static class TigerPkiIdentityInformationBuilder {
        @Generated
        private List<String> filenames;
        @Generated
        private String password;
        @Generated
        private String alias;
        @Generated
        private TigerPkiIdentityLoader.StoreType storeType;
        @Generated
        private boolean aliasesOrPasswords$set;
        @Generated
        private List<String> aliasesOrPasswords$value;
        @Generated
        private boolean useCompactFormat;

        @Generated
        TigerPkiIdentityInformationBuilder() {
        }

        @Generated
        public TigerPkiIdentityInformationBuilder filenames(List<String> filenames) {
            this.filenames = filenames;
            return this;
        }

        @Generated
        public TigerPkiIdentityInformationBuilder password(String password) {
            this.password = password;
            return this;
        }

        @Generated
        public TigerPkiIdentityInformationBuilder alias(String alias) {
            this.alias = alias;
            return this;
        }

        @Generated
        public TigerPkiIdentityInformationBuilder storeType(TigerPkiIdentityLoader.StoreType storeType) {
            this.storeType = storeType;
            return this;
        }

        @JsonIgnore
        @Generated
        public TigerPkiIdentityInformationBuilder aliasesOrPasswords(List<String> aliasesOrPasswords) {
            this.aliasesOrPasswords$value = aliasesOrPasswords;
            this.aliasesOrPasswords$set = true;
            return this;
        }

        @JsonIgnore
        @Generated
        public TigerPkiIdentityInformationBuilder useCompactFormat(boolean useCompactFormat) {
            this.useCompactFormat = useCompactFormat;
            return this;
        }

        @Generated
        public TigerPkiIdentityInformation build() {
            List<String> aliasesOrPasswords$value = this.aliasesOrPasswords$value;
            if (!this.aliasesOrPasswords$set) {
                aliasesOrPasswords$value = TigerPkiIdentityInformation.$default$aliasesOrPasswords();
            }
            return new TigerPkiIdentityInformation(this.filenames, this.password, this.alias, this.storeType, aliasesOrPasswords$value, this.useCompactFormat);
        }

        @Generated
        public String toString() {
            return "TigerPkiIdentityInformation.TigerPkiIdentityInformationBuilder(filenames=" + String.valueOf(this.filenames) + ", password=" + this.password + ", alias=" + this.alias + ", storeType=" + String.valueOf((Object)this.storeType) + ", aliasesOrPasswords$value=" + String.valueOf(this.aliasesOrPasswords$value) + ", useCompactFormat=" + this.useCompactFormat + ")";
        }
    }
}

