/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common.pki;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.gematik.test.tiger.common.TokenSubstituteHelper;
import de.gematik.test.tiger.common.config.TigerConfigurationException;
import de.gematik.test.tiger.common.config.TigerConfigurationLoader;
import de.gematik.test.tiger.common.pki.TigerPkiIdentity;
import de.gematik.test.tiger.common.pki.TigerPkiIdentityInformation;
import de.gematik.test.tiger.common.pki.TigerPkiIdentityLoader;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

@JsonDeserialize(using=TigerPkiIdentityDeserializer.class)
@JsonSerialize(using=TigerPkiIdentitySerializer.class)
public class TigerConfigurationPkiIdentity
extends TigerPkiIdentity {
    private TigerPkiIdentityInformation fileLoadingInformation;

    public TigerConfigurationPkiIdentity(String informationString) {
        super(informationString);
        this.fileLoadingInformation = TigerPkiIdentityLoader.parseInformationString(informationString);
    }

    public TigerConfigurationPkiIdentity(TigerPkiIdentityInformation fileLoadingInformation) {
        super(fileLoadingInformation);
        this.fileLoadingInformation = fileLoadingInformation;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TigerConfigurationPkiIdentity)) {
            return false;
        }
        TigerConfigurationPkiIdentity other = (TigerConfigurationPkiIdentity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TigerPkiIdentityInformation this$fileLoadingInformation = this.getFileLoadingInformation();
        TigerPkiIdentityInformation other$fileLoadingInformation = other.getFileLoadingInformation();
        return !(this$fileLoadingInformation == null ? other$fileLoadingInformation != null : !((Object)this$fileLoadingInformation).equals(other$fileLoadingInformation));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TigerConfigurationPkiIdentity;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TigerPkiIdentityInformation $fileLoadingInformation = this.getFileLoadingInformation();
        result = result * 59 + ($fileLoadingInformation == null ? 43 : ((Object)$fileLoadingInformation).hashCode());
        return result;
    }

    @Generated
    public TigerPkiIdentityInformation getFileLoadingInformation() {
        return this.fileLoadingInformation;
    }

    @Generated
    public void setFileLoadingInformation(TigerPkiIdentityInformation fileLoadingInformation) {
        this.fileLoadingInformation = fileLoadingInformation;
    }

    @Override
    @Generated
    public String toString() {
        return "TigerConfigurationPkiIdentity(fileLoadingInformation=" + String.valueOf(this.getFileLoadingInformation()) + ")";
    }

    public static class TigerPkiIdentitySerializer
    extends JsonSerializer<TigerConfigurationPkiIdentity> {
        public void serialize(TigerConfigurationPkiIdentity value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (value.getFileLoadingInformation() != null && value.getFileLoadingInformation().isUseCompactFormat()) {
                gen.writeString(value.getFileLoadingInformation().generateCompactFormat());
                return;
            }
            serializers.findValueSerializer(TigerPkiIdentityInformation.class).serialize((Object)value.getFileLoadingInformation(), gen, serializers);
        }
    }

    public static class TigerPkiIdentityDeserializer
    extends JsonDeserializer<TigerConfigurationPkiIdentity> {
        public TigerConfigurationPkiIdentity deserialize(JsonParser jsonParser, DeserializationContext ctxt) {
            try {
                JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
                if (node.isTextual()) {
                    String substitutedValue = TigerPkiIdentityDeserializer.replacePlaceholders(ctxt, node.asText());
                    return new TigerConfigurationPkiIdentity(substitutedValue);
                }
                if (node.isObject()) {
                    TigerPkiIdentityInformation pkiLoadingInformation = new TigerPkiIdentityInformation();
                    pkiLoadingInformation.setFilenames(List.of(TigerPkiIdentityDeserializer.findField(node, "filename", ctxt).or(() -> TigerPkiIdentityDeserializer.findField(node, "fileName", ctxt)).orElseThrow(() -> new TigerConfigurationException("Missing filename in TigerConfigurationPkiIdentity"))));
                    TigerPkiIdentityDeserializer.findField(node, "password", ctxt).ifPresent(pkiLoadingInformation::setPassword);
                    TigerPkiIdentityDeserializer.findField(node, "storeType", ctxt).or(() -> TigerPkiIdentityDeserializer.findField(node, "storetype", ctxt)).flatMap(TigerPkiIdentityLoader.StoreType::findStoreTypeForString).ifPresent(pkiLoadingInformation::setStoreType);
                    TigerPkiIdentityDeserializer.findField(node, "alias", ctxt).ifPresent(pkiLoadingInformation::setAlias);
                    return new TigerConfigurationPkiIdentity(pkiLoadingInformation);
                }
                throw new IOException("Unsupported YAML structure for TigerConfigurationPkiIdentity");
            }
            catch (IOException e) {
                throw new TigerConfigurationException("Error while deserializing from JSON: " + e.getMessage(), e);
            }
        }

        private static Optional<String> findField(JsonNode node, String fieldname, DeserializationContext ctxt) {
            if (node.hasNonNull(fieldname) && node.get(fieldname).isTextual()) {
                return Optional.of(TigerPkiIdentityDeserializer.replacePlaceholders(ctxt, node.get(fieldname).asText()));
            }
            return Optional.empty();
        }

        private static String replacePlaceholders(DeserializationContext ctxt, String text) {
            return TokenSubstituteHelper.substitute(text, (TigerConfigurationLoader)ctxt.getAttribute((Object)"tigerConfiguration"));
        }
    }
}

