/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common.jexl;

import de.gematik.test.tiger.common.exceptions.TigerJexlException;
import de.gematik.test.tiger.common.jexl.InlineJexlMethods;
import de.gematik.test.tiger.common.jexl.InlineJexlToolbox;
import de.gematik.test.tiger.common.jexl.TigerJexlContext;
import de.gematik.test.tiger.common.jexl.TigerJexlContextDecorator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import lombok.Generated;
import org.apache.commons.jexl3.JexlArithmetic;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.introspection.JexlPermissions;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerJexlExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerJexlExecutor.class);
    private static final Map<String, Object> NAMESPACE_MAP = new HashMap<String, Object>();
    private static final List<TigerJexlContextDecorator> CONTEXT_DECORATORS = new ArrayList<TigerJexlContextDecorator>();
    private static boolean activateJexlDebugging = false;
    private static BiFunction<String, TigerJexlContext, List<String>> expressionPreMapper = (exp, ctx) -> List.of(exp);

    public static void initialize() {
    }

    private static void registerAdditionalInlineMethods() {
        Set annotatedTypes = new Reflections("de.gematik.test.tiger.common.jexl", new Scanner[0]).getTypesAnnotatedWith(InlineJexlMethods.class);
        annotatedTypes.forEach(type -> {
            String namespacePrefix = type.getAnnotation(InlineJexlMethods.class).namespacePrefix();
            NAMESPACE_MAP.put(namespacePrefix, type);
        });
    }

    public static boolean matchesAsJexlExpression(Object element, String jexlExpression) {
        return TigerJexlExecutor.createNewExecutor().matchesAsJexlExpressionInternal(element, jexlExpression);
    }

    public static boolean matchesAsJexlExpression(Object element, String jexlExpression, Optional<String> keyInParentElement) {
        return TigerJexlExecutor.matchesAsJexlExpression(jexlExpression, new TigerJexlContext().withKey(keyInParentElement.orElse(null)).withCurrentElement(element));
    }

    public static boolean matchesAsJexlExpression(String jexlExpression, TigerJexlContext context) {
        return TigerJexlExecutor.createNewExecutor().matchesAsJexlExpressionInternal(jexlExpression, context);
    }

    public static Optional<Object> evaluateJexlExpression(String jexlExpression, TigerJexlContext context) {
        List<Object> resultList = TigerJexlExecutor.createNewExecutor().evaluateJexlExpressionInternal(jexlExpression, context);
        if (resultList.size() > 1) {
            throw new TigerJexlException("Evaluated '" + jexlExpression + "' and got more then one result. Expected one ore zero results.");
        }
        if (resultList.size() == 1) {
            return Optional.ofNullable(resultList.get(0));
        }
        return Optional.empty();
    }

    public static void addContextDecorator(TigerJexlContextDecorator decorator) {
        CONTEXT_DECORATORS.add(decorator);
    }

    public static TigerJexlExecutor createNewExecutor() {
        return new TigerJexlExecutor();
    }

    public static TigerJexlContext buildJexlMapContext(Object element, Optional<String> key) {
        TigerJexlContext mapContext = new TigerJexlContext();
        CONTEXT_DECORATORS.forEach(decorator -> decorator.decorate(element, key, mapContext));
        return mapContext;
    }

    private static void tigerJexlMapDecorator(Object element, Optional<String> key, TigerJexlContext context) {
        context.put("element", element);
        if (element != null) {
            context.put("type", (Object)element.getClass().getSimpleName());
            context.put("content", (Object)TigerJexlExecutor.getContent(element));
        }
    }

    private static String getContent(Object element) {
        return element.toString();
    }

    private static JexlEngine getJexlEngine() {
        JexlBuilder jexlBuilder = new JexlBuilder().namespaces(NAMESPACE_MAP).permissions(JexlPermissions.UNRESTRICTED).strict(true);
        jexlBuilder.options().setStrictArithmetic(false);
        return jexlBuilder.create();
    }

    public static void registerAdditionalNamespace(String namespace, Object value) {
        NAMESPACE_MAP.put(namespace, value);
    }

    public static void deregisterNamespace(String namespace) {
        NAMESPACE_MAP.remove(namespace);
    }

    private boolean matchesAsJexlExpressionInternal(Object element, String jexlExpression) {
        return this.matchesAsJexlExpressionInternal(jexlExpression, new TigerJexlContext().withCurrentElement(element));
    }

    private boolean matchesAsJexlExpressionInternal(String jexlExpression, TigerJexlContext context) {
        boolean result = TigerJexlExecutor.createNewExecutor().evaluateJexlExpressionInternal(jexlExpression, context).stream().filter(Boolean.class::isInstance).map(Boolean.class::cast).reduce(Boolean.FALSE, Boolean::logicalOr);
        if (result && activateJexlDebugging) {
            this.printDebugMessage(context.getCurrentElement(), jexlExpression);
        }
        return result;
    }

    private List<Object> evaluateJexlExpressionInternal(String jexlExpression, TigerJexlContext externalContext) {
        try {
            TigerJexlContext contextMap = TigerJexlExecutor.buildJexlMapContext(externalContext.getCurrentElement(), Optional.ofNullable(externalContext.getKey()));
            contextMap.putAll(NAMESPACE_MAP);
            contextMap.putAll(externalContext);
            return this.buildExpressions(jexlExpression, contextMap).stream().map(expression -> {
                Object result = expression.evaluate((JexlContext)contextMap);
                if (activateJexlDebugging) {
                    log.debug("Evaluated JEXL '{}' to '{}'", (Object)jexlExpression, result);
                }
                return result;
            }).toList();
        }
        catch (RuntimeException e) {
            if (e instanceof JexlException && e.getCause() instanceof JexlArithmetic.NullOperand) {
                return List.of();
            }
            if (e instanceof JexlException && !(e.getCause() instanceof NoSuchElementException)) {
                throw new TigerJexlException("Error while parsing expression '" + jexlExpression + "'", e);
            }
            log.debug("Error during Jexl-Evaluation", (Throwable)e);
            return List.of();
        }
    }

    protected void printDebugMessage(Object element, String jexlExpression) {
        log.trace("Found match: '{}' matches '{}'", element, (Object)jexlExpression);
    }

    private List<JexlExpression> buildExpressions(String jexlExpression, TigerJexlContext mapContext) {
        return expressionPreMapper.apply(jexlExpression, mapContext).stream().map(arg_0 -> ((JexlEngine)TigerJexlExecutor.getJexlEngine()).createExpression(arg_0)).toList();
    }

    public JexlScript buildScript(String jexlScript) {
        try {
            return TigerJexlExecutor.getJexlEngine().createScript(jexlScript);
        }
        catch (RuntimeException e) {
            throw new TigerJexlException("Error while parsing script '" + jexlScript + "'", e);
        }
    }

    @Generated
    private TigerJexlExecutor() {
    }

    @Generated
    public static void setActivateJexlDebugging(boolean activateJexlDebugging) {
        TigerJexlExecutor.activateJexlDebugging = activateJexlDebugging;
    }

    @Generated
    public static boolean isActivateJexlDebugging() {
        return activateJexlDebugging;
    }

    @Generated
    public static void setExpressionPreMapper(BiFunction<String, TigerJexlContext, List<String>> expressionPreMapper) {
        TigerJexlExecutor.expressionPreMapper = expressionPreMapper;
    }

    static {
        NAMESPACE_MAP.put(null, InlineJexlToolbox.class);
        TigerJexlExecutor.registerAdditionalInlineMethods();
        CONTEXT_DECORATORS.add(TigerJexlExecutor::tigerJexlMapDecorator);
    }
}

