/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common.config;

import de.gematik.test.tiger.common.config.TigerConfigurationSource;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.stream.Stream;

public class TigerConfigurationSourcesManager {
    private ConcurrentSkipListSet<TigerConfigurationSource> loadedSources = new ConcurrentSkipListSet();

    public void reset() {
        this.loadedSources.clear();
    }

    public Stream<TigerConfigurationSource> getSortedStream() {
        return this.loadedSources.stream();
    }

    public List<TigerConfigurationSource> getSortedListReversed() {
        return this.loadedSources.stream().sorted(Comparator.reverseOrder()).toList();
    }

    public void addNewSource(TigerConfigurationSource source) {
        boolean success = this.loadedSources.add(source);
        if (!success) {
            TigerConfigurationSource exisitingSource = this.loadedSources.stream().filter(src -> src.getPrecedence() == source.getPrecedence()).findFirst().orElseThrow();
            exisitingSource.putAll(source);
        }
    }

    public boolean removeSource(TigerConfigurationSource source) {
        return this.loadedSources.remove(source);
    }
}

