/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import de.gematik.test.tiger.common.config.ConfigurationValuePrecedence;
import de.gematik.test.tiger.common.config.TigerConfigurationKey;
import de.gematik.test.tiger.common.config.TigerConfigurationKeyString;
import de.gematik.test.tiger.common.config.TigerConfigurationLoader;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.ClassUtils;

public class TigerConfigurationSource
implements Comparable<TigerConfigurationSource> {
    protected final ConfigurationValuePrecedence precedence;
    private final Map<TigerConfigurationKey, String> values;
    private final TigerConfigurationLoader configurationLoader;

    public TigerConfigurationSource(ConfigurationValuePrecedence precedence, Map<TigerConfigurationKey, String> values, TigerConfigurationLoader configurationLoader) {
        this.precedence = precedence;
        this.configurationLoader = configurationLoader;
        this.values = new HashMap<TigerConfigurationKey, String>();
        if (values != null) {
            this.values.putAll(values);
        }
    }

    public TigerConfigurationSource(ConfigurationValuePrecedence precedence, TigerConfigurationLoader configurationLoader) {
        this.precedence = precedence;
        this.values = new HashMap<TigerConfigurationKey, String>();
        this.configurationLoader = configurationLoader;
    }

    public TigerConfigurationSource copy() {
        return TigerConfigurationSource.builder().precedence(this.precedence).values(new HashMap<TigerConfigurationKey, String>(this.values)).build();
    }

    public synchronized Map<TigerConfigurationKey, String> addValuesToMap(Map<TigerConfigurationKey, String> loadedAndSortedProperties) {
        HashMap<TigerConfigurationKey, String> finalValues = new HashMap<TigerConfigurationKey, String>();
        finalValues.putAll(loadedAndSortedProperties);
        finalValues.putAll(this.values);
        return finalValues;
    }

    public synchronized Map<TigerConfigurationKey, String> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    public synchronized void putValue(TigerConfigurationKey baseKey, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof Map) {
            Map asMap = (Map)value;
            asMap.forEach((subKey, entryValue) -> {
                TigerConfigurationKey combinedKey = new TigerConfigurationKey(baseKey);
                combinedKey.add((String)subKey);
                this.putValue(combinedKey, entryValue);
            });
        } else if (value instanceof List) {
            List asList = (List)value;
            int counter = 0;
            for (Object entry : asList) {
                TigerConfigurationKey newList = new TigerConfigurationKey(baseKey);
                newList.add(TigerConfigurationKeyString.wrapAsKey(Integer.toString(counter++)));
                this.putValue(newList, entry);
            }
        } else if (ClassUtils.isPrimitiveOrWrapper(value.getClass()) || value instanceof String || value instanceof Enum) {
            this.values.put(baseKey, value.toString());
        } else if (value instanceof JsonNode) {
            JsonNode jsonNode = (JsonNode)value;
            if (jsonNode.isObject()) {
                for (Map.Entry field : jsonNode.properties()) {
                    this.putValue(new TigerConfigurationKey(baseKey, (String)field.getKey()), field.getValue());
                }
            } else if (jsonNode.isArray()) {
                for (int i = 0; i < jsonNode.size(); ++i) {
                    this.putValue(new TigerConfigurationKey(baseKey, Integer.toString(i)), jsonNode.get(i));
                }
            } else if (jsonNode instanceof BinaryNode) {
                BinaryNode binaryNode = (BinaryNode)jsonNode;
                this.putValue(new TigerConfigurationKey(baseKey), Base64.getEncoder().encodeToString(binaryNode.binaryValue()));
            } else if (jsonNode.isTextual()) {
                this.putValue(new TigerConfigurationKey(baseKey), jsonNode.textValue());
            } else if (jsonNode.isValueNode() && !jsonNode.isNull()) {
                this.putValue(new TigerConfigurationKey(baseKey), jsonNode.toString());
            }
        } else {
            JsonNode treeView = this.configurationLoader.getObjectMapper().valueToTree(value);
            this.putValue(new TigerConfigurationKey(baseKey), treeView);
        }
    }

    public synchronized void removeValue(TigerConfigurationKey key) {
        this.values.remove(key);
    }

    public synchronized boolean containsKey(TigerConfigurationKey key) {
        return this.values.containsKey(key);
    }

    public synchronized String getValue(TigerConfigurationKey key) {
        return this.values.get(key);
    }

    public void putAll(TigerConfigurationSource other) {
        this.values.putAll(other.values);
    }

    @Override
    public int compareTo(TigerConfigurationSource other) {
        if (other == null) {
            throw new NullPointerException();
        }
        return Integer.compare(this.precedence.getValue(), other.getPrecedence().getValue());
    }

    @Generated
    public static TigerConfigurationSourceBuilder builder() {
        return new TigerConfigurationSourceBuilder();
    }

    @Generated
    public ConfigurationValuePrecedence getPrecedence() {
        return this.precedence;
    }

    @Generated
    public TigerConfigurationLoader getConfigurationLoader() {
        return this.configurationLoader;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TigerConfigurationSource)) {
            return false;
        }
        TigerConfigurationSource other = (TigerConfigurationSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ConfigurationValuePrecedence this$precedence = this.getPrecedence();
        ConfigurationValuePrecedence other$precedence = other.getPrecedence();
        if (this$precedence == null ? other$precedence != null : !((Object)((Object)this$precedence)).equals((Object)other$precedence)) {
            return false;
        }
        Map<TigerConfigurationKey, String> this$values = this.getValues();
        Map<TigerConfigurationKey, String> other$values = other.getValues();
        if (this$values == null ? other$values != null : !((Object)this$values).equals(other$values)) {
            return false;
        }
        TigerConfigurationLoader this$configurationLoader = this.getConfigurationLoader();
        TigerConfigurationLoader other$configurationLoader = other.getConfigurationLoader();
        return !(this$configurationLoader == null ? other$configurationLoader != null : !this$configurationLoader.equals(other$configurationLoader));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TigerConfigurationSource;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConfigurationValuePrecedence $precedence = this.getPrecedence();
        result = result * 59 + ($precedence == null ? 43 : ((Object)((Object)$precedence)).hashCode());
        Map<TigerConfigurationKey, String> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        TigerConfigurationLoader $configurationLoader = this.getConfigurationLoader();
        result = result * 59 + ($configurationLoader == null ? 43 : $configurationLoader.hashCode());
        return result;
    }

    @Generated
    public static class TigerConfigurationSourceBuilder {
        @Generated
        private ConfigurationValuePrecedence precedence;
        @Generated
        private Map<TigerConfigurationKey, String> values;
        @Generated
        private TigerConfigurationLoader configurationLoader;

        @Generated
        TigerConfigurationSourceBuilder() {
        }

        @Generated
        public TigerConfigurationSourceBuilder precedence(ConfigurationValuePrecedence precedence) {
            this.precedence = precedence;
            return this;
        }

        @Generated
        public TigerConfigurationSourceBuilder values(Map<TigerConfigurationKey, String> values) {
            this.values = values;
            return this;
        }

        @Generated
        public TigerConfigurationSourceBuilder configurationLoader(TigerConfigurationLoader configurationLoader) {
            this.configurationLoader = configurationLoader;
            return this;
        }

        @Generated
        public TigerConfigurationSource build() {
            return new TigerConfigurationSource(this.precedence, this.values, this.configurationLoader);
        }

        @Generated
        public String toString() {
            return "TigerConfigurationSource.TigerConfigurationSourceBuilder(precedence=" + String.valueOf((Object)this.precedence) + ", values=" + String.valueOf(this.values) + ", configurationLoader=" + String.valueOf(this.configurationLoader) + ")";
        }
    }
}

