/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common.config;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.gematik.test.tiger.common.TokenSubstituteHelper;
import de.gematik.test.tiger.common.config.ConfigurationValuePrecedence;
import de.gematik.test.tiger.common.config.DeprecatedKeysUsageChecker;
import de.gematik.test.tiger.common.config.TigerConfigurationException;
import de.gematik.test.tiger.common.config.TigerConfigurationKey;
import de.gematik.test.tiger.common.config.TigerConfigurationKeyString;
import de.gematik.test.tiger.common.config.TigerConfigurationObjectMapperBuilder;
import de.gematik.test.tiger.common.config.TigerConfigurationSource;
import de.gematik.test.tiger.common.config.TigerConfigurationSourcesManager;
import de.gematik.test.tiger.common.data.config.ConfigurationFileType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerConfigurationLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerConfigurationLoader.class);
    public static final String TIGER_CONFIGURATION_ATTRIBUTE_KEY = "tigerConfiguration";
    private final TigerConfigurationSourcesManager sourcesManager = new TigerConfigurationSourcesManager();
    private ObjectMapper objectMapper;

    public TigerConfigurationLoader() {
        this.initialize();
    }

    private static String mapConflictResolver(String e1, String e2, String propertySourceName) {
        if (e1.equals(e2)) {
            return e1;
        }
        throw new TigerConfigurationException("Found two conflicting " + propertySourceName + " with values '" + e1 + "' and '" + e2 + "'. Resolve this conflict manually!");
    }

    public void reset() {
        this.sourcesManager.reset();
        this.initializeObjectMapper();
    }

    public void initialize() {
        if (this.objectMapper == null) {
            this.initializeObjectMapper();
        }
    }

    private void initializeObjectMapper() {
        TigerConfigurationObjectMapperBuilder builder = new TigerConfigurationObjectMapperBuilder(this);
        this.objectMapper = builder.retrieveLenientObjectMapper();
    }

    public String readString(String key) {
        return this.readStringOptional(key).orElseThrow(() -> new TigerConfigurationException("Could not find value for '" + key + "'"));
    }

    public String readString(String key, String defaultValue) {
        return this.readStringOptional(key).orElse(defaultValue);
    }

    public Optional<String> readStringOptional(String key) {
        TigerConfigurationKey splittedKey = new TigerConfigurationKey(TokenSubstituteHelper.substitute(key, this));
        return this.readStringOptional(splittedKey);
    }

    public Optional<String> readStringOptional(TigerConfigurationKey key) {
        return this.sourcesManager.getSortedStream().filter(source -> source.containsKey(key)).map(source -> source.getValue(key)).findFirst();
    }

    public <T> Optional<T> instantiateConfigurationBean(Class<T> configurationBeanClass, String ... baseKeys) {
        return this.instantiateConfigurationBean(configurationBeanClass, this.objectMapper, baseKeys);
    }

    private <T> Optional<T> instantiateConfigurationBean(Class<T> configurationBeanClass, ObjectMapper objectMapper, String ... baseKeys) {
        this.initialize();
        JsonNode targetTree = this.convertToTreeUnresolved();
        TigerConfigurationKey configurationKey = new TigerConfigurationKey(baseKeys);
        for (TigerConfigurationKeyString key : configurationKey) {
            Optional<TreeNode> value = this.findByKey((TreeNode)targetTree, key);
            if (value.isEmpty()) {
                return Optional.empty();
            }
            targetTree = value.get();
        }
        try {
            return Optional.of(objectMapper.treeToValue((TreeNode)targetTree, configurationBeanClass));
        }
        catch (JacksonException e) {
            log.debug("Error while converting the following tree: {}", (Object)objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)targetTree));
            Throwable ex = e;
            while (ex.getCause() != null) {
                ex = ex.getCause();
            }
            throw new TigerConfigurationException("Error while reading configuration for class " + configurationBeanClass.getName() + " with base-keys " + Arrays.toString(baseKeys) + " and root cause '" + ex.getMessage() + "'", e);
        }
    }

    private Optional<TreeNode> findByKey(TreeNode node, TigerConfigurationKeyString key) {
        Iterator fields = node.fieldNames();
        return Stream.iterate(fields, Iterator::hasNext, UnaryOperator.identity()).map(Iterator::next).filter(field -> TigerConfigurationKeyString.wrapAsKey(field).equals(key)).findAny().map(arg_0 -> ((TreeNode)node).get(arg_0));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T instantiateConfigurationBean(TypeReference<T> configurationBeanType, String ... baseKeys) {
        this.initialize();
        JsonNode targetTree = this.convertToTreeUnresolved();
        TigerConfigurationKey configurationKey = new TigerConfigurationKey(baseKeys);
        for (TigerConfigurationKeyString key : configurationKey) {
            if (targetTree.get(key.getValue()) == null) {
                return (T)this.objectMapper.readValue("[]", configurationBeanType);
            }
            targetTree = targetTree.get(key.getValue());
        }
        try (JsonParser jsonParser = this.objectMapper.treeAsTokens((TreeNode)targetTree);){
            Object object = jsonParser.readValueAs(configurationBeanType);
            return (T)object;
        }
        catch (JacksonException e) {
            log.debug("Error while converting the following tree: {}", (Object)this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)targetTree));
            throw new TigerConfigurationException("Error while reading configuration for class " + configurationBeanType.getType().getTypeName() + " with base-keys " + Arrays.toString(baseKeys), e);
        }
    }

    public void readFromYaml(String yamlSource, String ... baseKeys) {
        this.readFromYaml(yamlSource, ConfigurationValuePrecedence.ADDITIONAL_YAML, baseKeys);
    }

    public void readFromYaml(String yamlSource, ConfigurationValuePrecedence precedence, String ... baseKeys) {
        this.readConfigurationFile(yamlSource, precedence, ConfigurationFileType.YAML, baseKeys);
    }

    public void readConfigurationFile(String yamlSource, ConfigurationValuePrecedence precedence, ConfigurationFileType configurationFileType, String ... baseKeys) {
        this.initialize();
        Object values = configurationFileType.loadFromString(yamlSource);
        TigerConfigurationSource configurationSource = TigerConfigurationSource.builder().configurationLoader(this).precedence(precedence).build();
        configurationSource.putValue(new TigerConfigurationKey(baseKeys), values);
        DeprecatedKeysUsageChecker.checkForDeprecatedKeys(configurationSource);
        this.sourcesManager.addNewSource(configurationSource);
    }

    public boolean readBoolean(String key) {
        return BooleanUtils.toBoolean((String)this.readString(key));
    }

    public boolean readBoolean(String key, boolean defValue) {
        return this.readStringOptional(key).map(BooleanUtils::toBoolean).orElse(defValue);
    }

    public Optional<Boolean> readBooleanOptional(String key) {
        return this.readStringOptional(key).map(BooleanUtils::toBoolean);
    }

    public void loadEnvironmentVariables() {
        this.sourcesManager.getSortedStream().filter(source -> source.getPrecedence() == ConfigurationValuePrecedence.ENV).forEach(this.sourcesManager::removeSource);
        this.sourcesManager.addNewSource(TigerConfigurationSource.builder().configurationLoader(this).values(System.getenv().entrySet().stream().collect(Collectors.toMap(entry -> new TigerConfigurationKey((String)entry.getKey()), Map.Entry::getValue, (e1, e2) -> TigerConfigurationLoader.mapConflictResolver(e1, e2, "environment variables")))).precedence(ConfigurationValuePrecedence.ENV).build());
    }

    public void loadSystemProperties() {
        this.sourcesManager.getSortedStream().filter(source -> source.getPrecedence() == ConfigurationValuePrecedence.PROPERTIES).forEach(this.sourcesManager::removeSource);
        this.sourcesManager.addNewSource(TigerConfigurationSource.builder().configurationLoader(this).values(System.getProperties().entrySet().stream().collect(Collectors.toMap(entry -> new TigerConfigurationKey(entry.getKey().toString()), entry -> entry.getValue().toString(), (e1, e2) -> TigerConfigurationLoader.mapConflictResolver(e1, e2, "system properties")))).precedence(ConfigurationValuePrecedence.PROPERTIES).build());
    }

    public Map<TigerConfigurationKey, String> retrieveMap(TigerConfigurationKey reference) {
        Map<TigerConfigurationKey, String> map = this.retrieveMapUnresolved();
        this.replacePlaceholders(map, reference);
        return map;
    }

    public Map<TigerConfigurationKey, String> retrieveMapUnresolved() {
        Map<TigerConfigurationKey, String> loadedAndSortedProperties = new HashMap<TigerConfigurationKey, String>();
        for (TigerConfigurationSource configurationSource : this.sourcesManager.getSortedListReversed()) {
            loadedAndSortedProperties = configurationSource.addValuesToMap(loadedAndSortedProperties);
        }
        return loadedAndSortedProperties;
    }

    private JsonNode convertToTreeUnresolved() {
        return this.convertMapToTree(this.retrieveMapUnresolved());
    }

    private JsonNode convertMapToTree(Map<TigerConfigurationKey, String> map) {
        ObjectNode result = new ObjectNode(this.objectMapper.getNodeFactory());
        for (Map.Entry<TigerConfigurationKey, String> entry : map.entrySet()) {
            this.createAndReturnDeepPath(entry.getKey(), result).put(((TigerConfigurationKeyString)entry.getKey().get(entry.getKey().size() - 1)).getValue(), entry.getValue());
        }
        return this.mapObjectsToArrayWhereApplicable((JsonNode)result, this.objectMapper.getNodeFactory());
    }

    private void replacePlaceholders(Map<TigerConfigurationKey, String> loadedAndSortedProperties, TigerConfigurationKey reference) {
        Map<TigerConfigurationKey, String> updatedValues = loadedAndSortedProperties.entrySet().stream().filter(entry -> ((String)entry.getValue()).contains("${") && ((String)entry.getValue()).contains("}")).filter(entry -> ((TigerConfigurationKey)entry.getKey()).isBelow(reference)).map(entry -> Pair.of((Object)((TigerConfigurationKey)entry.getKey()), (Object)TokenSubstituteHelper.substitute((String)entry.getValue(), this))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        loadedAndSortedProperties.putAll(updatedValues);
    }

    private JsonNode mapObjectsToArrayWhereApplicable(JsonNode value, JsonNodeFactory nodeFactory) {
        if (value instanceof ObjectNode) {
            ObjectNode asObjectNode = (ObjectNode)value;
            if (this.isArray(asObjectNode)) {
                return new ArrayNode(nodeFactory, StreamSupport.stream(Spliterators.spliteratorUnknownSize(value.fields(), 16), false).sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).map(node -> this.mapObjectsToArrayWhereApplicable((JsonNode)node, nodeFactory)).toList());
            }
            return new ObjectNode(nodeFactory, StreamSupport.stream(Spliterators.spliteratorUnknownSize(asObjectNode.fields(), 16), false).map(entry -> Pair.of((Object)((String)entry.getKey()), (Object)this.mapObjectsToArrayWhereApplicable((JsonNode)entry.getValue(), nodeFactory))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }
        return value;
    }

    private boolean isArray(ObjectNode value) {
        Spliterator stringSpliterator = Spliterators.spliteratorUnknownSize(value.fieldNames(), 16);
        if (StreamSupport.stream(stringSpliterator, false).anyMatch(s -> !NumberUtils.isParsable((String)s))) {
            return false;
        }
        List<Integer> keys = StreamSupport.stream(stringSpliterator, false).mapToInt(Integer::parseInt).sorted().boxed().toList();
        int i = 0;
        for (Integer key : keys) {
            if (key == i++) continue;
            return false;
        }
        return true;
    }

    private ObjectNode createAndReturnDeepPath(List<TigerConfigurationKeyString> keys, ObjectNode position) {
        if (keys.size() > 1) {
            for (TigerConfigurationKeyString key : keys.subList(0, keys.size() - 1)) {
                String homogenizedKey = this.homogenizeKeysInMapAndReturnCorrectedKey(position, key);
                if (!position.has(homogenizedKey)) {
                    position.putObject(homogenizedKey);
                }
                if (!(position.get(homogenizedKey) instanceof ObjectNode)) continue;
                position = (ObjectNode)position.get(homogenizedKey);
            }
        }
        return position;
    }

    private String homogenizeKeysInMapAndReturnCorrectedKey(ObjectNode position, TigerConfigurationKeyString key) {
        Iterator it = position.fieldNames();
        while (it.hasNext()) {
            String toBeReplacedKey = (String)it.next();
            if (key.getValue().equals(toBeReplacedKey) || !key.getValue().equalsIgnoreCase(toBeReplacedKey)) continue;
            if (!toBeReplacedKey.equals(toBeReplacedKey.toLowerCase())) {
                return toBeReplacedKey;
            }
            JsonNode leaf = position.remove(toBeReplacedKey);
            position.set(key.getValue(), leaf);
            return key.getValue();
        }
        return key.getValue();
    }

    public Map<String, String> readMap(String ... baseKeys) {
        TigerConfigurationKey reference = new TigerConfigurationKey(baseKeys);
        return this.retrieveMap(reference).entrySet().stream().filter(entry -> ((TigerConfigurationKey)entry.getKey()).isBelow(reference)).collect(Collectors.toMap(entry -> ((TigerConfigurationKey)entry.getKey()).subtractFromBeginning(reference).downsampleKey(), Map.Entry::getValue));
    }

    public List<String> readList(String ... baseKeys) {
        TigerConfigurationKey reference = new TigerConfigurationKey(baseKeys);
        return this.retrieveMap(reference).entrySet().stream().filter(entry -> ((TigerConfigurationKey)entry.getKey()).isBelow(reference)).map(Map.Entry::getValue).toList();
    }

    public Map<String, String> readMapWithCaseSensitiveKeys(String ... baseKeys) {
        return this.readMapWithCaseSensitiveKeys(new TigerConfigurationKey(baseKeys));
    }

    public Map<String, String> readMapWithCaseSensitiveKeys(TigerConfigurationKey reference) {
        return this.retrieveMap(reference).entrySet().stream().filter(entry -> ((TigerConfigurationKey)entry.getKey()).isBelow(reference)).collect(Collectors.toMap(entry -> ((TigerConfigurationKey)entry.getKey()).subtractFromBeginning(reference).downsampleKeyCaseSensitive(), Map.Entry::getValue));
    }

    public List<TigerConfigurationSource> listSources() {
        return this.sourcesManager.getSortedListReversed();
    }

    public void putValue(String key, Object value) {
        this.putValue(key, value, ConfigurationValuePrecedence.RUNTIME_EXPORT);
    }

    public void putValue(String key, Object value, ConfigurationValuePrecedence precedence) {
        this.putValue(new TigerConfigurationKey(key), value, precedence);
    }

    public void putValue(TigerConfigurationKey key, Object value, ConfigurationValuePrecedence precedence) {
        if (value == null) {
            throw new TigerConfigurationException("Trying to store null-value. Only non-values are allowed!");
        }
        TigerConfigurationSource configurationSource = this.sourcesManager.getSortedStream().filter(source -> source.getPrecedence() == precedence).findAny().orElseGet(() -> this.generateNewConfigurationSource(precedence));
        configurationSource.putValue(key, value);
    }

    private TigerConfigurationSource generateNewConfigurationSource(ConfigurationValuePrecedence precedence) {
        TigerConfigurationSource newSource = new TigerConfigurationSource(precedence, this);
        this.sourcesManager.addNewSource(newSource);
        return newSource;
    }

    public void addConfigurationSource(TigerConfigurationSource configurationSource) {
        this.sourcesManager.addNewSource(configurationSource);
    }

    public boolean removeConfigurationSource(TigerConfigurationSource configurationSource) {
        return this.sourcesManager.removeSource(configurationSource);
    }

    @Generated
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }
}

