/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common.config;

import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class TigerConfigurationKeyString {
    private static final List<Character> FORBIDDEN_CHARACTERS = List.of(Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('|'));
    private final String value;

    public static TigerConfigurationKeyString wrapAsKey(String value) {
        for (Character c : FORBIDDEN_CHARACTERS) {
            value = value.replace(c.charValue(), '_');
        }
        return new TigerConfigurationKeyString(value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof String) {
            String asString = (String)o;
            return this.value.equalsIgnoreCase(asString);
        }
        if (o instanceof TigerConfigurationKeyString) {
            TigerConfigurationKeyString asTigerString = (TigerConfigurationKeyString)o;
            return this.value != null ? this.value.equalsIgnoreCase(asTigerString.value) : asTigerString.value == null;
        }
        return false;
    }

    public int hashCode() {
        return this.value != null ? this.value.toLowerCase().hashCode() : 0;
    }

    public String asLowerCase() {
        return this.value.toLowerCase();
    }

    public String asString() {
        return this.value;
    }

    public boolean isNotEmptyKey() {
        return StringUtils.isNotEmpty((CharSequence)this.value);
    }

    @ConstructorProperties(value={"value"})
    @Generated
    public TigerConfigurationKeyString(String value) {
        this.value = value;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public String toString() {
        return "TigerConfigurationKeyString(value=" + this.getValue() + ")";
    }
}

