/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

public class RingBufferHashMap<K, V> {
    private final LinkedHashMap<K, V> map = new LinkedHashMap();
    private final int size;

    public RingBufferHashMap(int size) {
        this.size = size;
    }

    public synchronized Optional<V> get(K key) {
        return Optional.ofNullable(this.map.get(key));
    }

    public synchronized void remove(K key) {
        this.map.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized V getOrPutDefault(K key, Supplier<V> defaultValue) {
        try {
            Object object = this.map.computeIfAbsent(key, k -> defaultValue.get());
            return (V)object;
        }
        finally {
            this.deleteOldestEntryOnOverflow();
        }
    }

    private synchronized void deleteOldestEntryOnOverflow() {
        if (this.map.size() > this.size) {
            Iterator<Map.Entry<K, V>> iterator = this.map.entrySet().iterator();
            iterator.next();
            iterator.remove();
        }
    }

    public synchronized List<Map.Entry<K, V>> entries() {
        return new ArrayList<Map.Entry<K, V>>(this.map.entrySet());
    }

    public synchronized Set<K> keys() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public int size() {
        return this.map.size();
    }

    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    public synchronized void put(K key, V value) {
        this.map.put(key, value);
        this.deleteOldestEntryOnOverflow();
    }

    public void clear() {
        this.map.clear();
    }

    public String toString() {
        return this.map.toString();
    }
}

