/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.util;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.gematik.rbellogger.util.RbelInternetAddress;
import de.gematik.rbellogger.util.RbelInternetAddressParser;
import de.gematik.test.tiger.exceptions.RbelHostnameFormatException;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonSerialize(using=RbelHostnameSerializer.class)
@JsonDeserialize(using=RbelHostnameDeserializer.class)
public class RbelSocketAddress
implements Serializable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelSocketAddress.class);
    private final RbelInternetAddress address;
    private final int port;

    public RbelSocketAddress(RbelInternetAddress address, int port) {
        this.address = address;
        this.port = port;
    }

    public static Optional<RbelSocketAddress> fromString(String value) {
        try {
            if (StringUtils.isBlank((CharSequence)value)) {
                return Optional.empty();
            }
            if (value.startsWith("[") && value.contains("]")) {
                return RbelSocketAddress.parseIpv6WithBracketing(value);
            }
            if (value.contains(":")) {
                return RbelSocketAddress.parseUnbracketed(value);
            }
            return Optional.ofNullable(RbelSocketAddress.builder().address(RbelInternetAddressParser.parseInetAddress(value)).build());
        }
        catch (Exception e) {
            throw new RbelHostnameFormatException("Unable to parse hostname: '" + value + "'", e);
        }
    }

    private static Optional<RbelSocketAddress> parseUnbracketed(String value) {
        int lastColon = value.lastIndexOf(":");
        String hostname = value.substring(0, lastColon);
        int port = Integer.parseInt(value.substring(lastColon + 1));
        return Optional.ofNullable(RbelSocketAddress.builder().address(RbelInternetAddressParser.parseInetAddress(hostname)).port(port).build());
    }

    private static Optional<RbelSocketAddress> parseIpv6WithBracketing(String value) {
        int closingBracket = value.indexOf(93);
        String hostname = value.substring(1, closingBracket);
        int port = 0;
        if (closingBracket + 1 < value.length() && value.charAt(closingBracket + 1) == ':') {
            port = Integer.parseInt(value.substring(closingBracket + 2));
        }
        return Optional.ofNullable(RbelSocketAddress.builder().address(RbelInternetAddressParser.parseInetAddress(hostname)).port(port).build());
    }

    public static RbelSocketAddress create(SocketAddress clientAddress) {
        if (clientAddress == null) {
            return null;
        }
        if (clientAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)clientAddress;
            if (inetSocketAddress.getAddress() != null) {
                return new RbelSocketAddress(RbelInternetAddress.fromInetAddress(inetSocketAddress.getAddress()), inetSocketAddress.getPort());
            }
            if (inetSocketAddress.getHostString() != null) {
                RbelInternetAddress inetAddress = RbelInternetAddressParser.parseInetAddress(inetSocketAddress.getHostString());
                return new RbelSocketAddress(inetAddress, inetSocketAddress.getPort());
            }
        }
        throw new RbelHostnameFormatException("Unable to parse socket address: '" + String.valueOf(clientAddress) + "' - only InetSocketAddress supported");
    }

    public SocketAddress asSocketAddress() {
        return this.address.toInetAddress().map(adr -> new InetSocketAddress((InetAddress)adr, this.port)).orElseGet(() -> InetSocketAddress.createUnresolved(this.address.printValidHostname(), this.port));
    }

    public static Optional<RbelSocketAddress> generateFromUrl(String url) {
        if (StringUtils.isEmpty((CharSequence)url)) {
            return Optional.empty();
        }
        try {
            URI uri = new URI(url);
            if (StringUtils.isEmpty((CharSequence)uri.getHost())) {
                return Optional.empty();
            }
            if (uri.getPort() > 0) {
                return Optional.of(RbelSocketAddress.create(uri.getHost(), uri.getPort()));
            }
            if ("http".equals(uri.getScheme())) {
                return Optional.of(RbelSocketAddress.create(uri.getHost(), 80));
            }
            if ("https".equals(uri.getScheme())) {
                return Optional.of(RbelSocketAddress.create(uri.getHost(), 443));
            }
            return Optional.of(RbelSocketAddress.create(uri.getHost(), 0));
        }
        catch (Exception e) {
            log.debug("Error while trying to parse URL '{}'", (Object)url, (Object)e);
            return Optional.empty();
        }
    }

    public static RbelSocketAddress create(String address, int port) {
        return new RbelSocketAddress(RbelInternetAddressParser.parseInetAddress(address), port);
    }

    @JsonProperty
    public String toString() {
        if (this.port > 0) {
            return this.printHostname() + ":" + this.port;
        }
        return this.printHostname();
    }

    public String printHostname() {
        return this.address.printValidHostname();
    }

    public boolean isLoopbackAddress() {
        try {
            return this.address.toInetAddress().map(InetAddress::isLoopbackAddress).orElse(false);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Generated
    public static RbelSocketAddressBuilder builder() {
        return new RbelSocketAddressBuilder();
    }

    @Generated
    public RbelInternetAddress getAddress() {
        return this.address;
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelSocketAddress)) {
            return false;
        }
        RbelSocketAddress other = (RbelSocketAddress)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        RbelInternetAddress this$address = this.getAddress();
        RbelInternetAddress other$address = other.getAddress();
        return !(this$address == null ? other$address != null : !((Object)this$address).equals(other$address));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RbelSocketAddress;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        RbelInternetAddress $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        return result;
    }

    @Generated
    public static class RbelSocketAddressBuilder {
        @Generated
        private RbelInternetAddress address;
        @Generated
        private int port;

        @Generated
        RbelSocketAddressBuilder() {
        }

        @Generated
        public RbelSocketAddressBuilder address(RbelInternetAddress address) {
            this.address = address;
            return this;
        }

        @Generated
        public RbelSocketAddressBuilder port(int port) {
            this.port = port;
            return this;
        }

        @Generated
        public RbelSocketAddress build() {
            return new RbelSocketAddress(this.address, this.port);
        }

        @Generated
        public String toString() {
            return "RbelSocketAddress.RbelSocketAddressBuilder(address=" + String.valueOf(this.address) + ", port=" + this.port + ")";
        }
    }

    public static class RbelHostnameDeserializer
    extends JsonDeserializer<RbelSocketAddress> {
        public RbelSocketAddress deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return RbelSocketAddress.fromString(p.getValueAsString()).orElse(null);
        }
    }

    public static class RbelHostnameSerializer
    extends JsonSerializer<RbelSocketAddress> {
        public void serialize(RbelSocketAddress value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(value.toString());
        }
    }
}

