/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.util;

import de.gematik.rbellogger.util.RbelInternetAddress;
import java.net.InetAddress;
import java.net.UnknownHostException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class RbelInternetAddressParser {
    private static String cachedLoopbackHostname;

    private static String getLoopbackHostname(InetAddress address) {
        if (cachedLoopbackHostname == null) {
            cachedLoopbackHostname = address.getHostName();
        }
        return cachedLoopbackHostname;
    }

    public static RbelInternetAddress parseInetAddress(String addressString) {
        if (addressString == null || addressString.trim().isEmpty()) {
            throw new IllegalArgumentException("Address string cannot be null or empty.");
        }
        int slashIndex = addressString.indexOf(47);
        if (slashIndex != -1) {
            return RbelInternetAddressParser.parseJavaHostnameAddressScheme(addressString, slashIndex);
        }
        return RbelInternetAddressParser.parseRegularHostname(addressString);
    }

    private static boolean isLikelyIpAddress(String input) {
        if (input == null || input.isEmpty()) {
            return false;
        }
        char first = input.charAt(0);
        return Character.isDigit(first) || input.contains(":");
    }

    private static RbelInternetAddress parseRegularHostname(String addressString) {
        try {
            InetAddress inetAddress = InetAddress.getByName(addressString);
            byte[] ipBytes = inetAddress.getAddress();
            String hostname = RbelInternetAddressParser.computeHostname(addressString, inetAddress);
            return new RbelInternetAddress(hostname, ipBytes);
        }
        catch (UnknownHostException e) {
            return new RbelInternetAddress(addressString, null);
        }
    }

    private static String computeHostname(String addressString, InetAddress inetAddress) {
        String hostname = RbelInternetAddressParser.isLikelyIpAddress(addressString) ? (inetAddress.isLoopbackAddress() ? RbelInternetAddressParser.getLoopbackHostname(inetAddress) : null) : inetAddress.getHostName();
        return hostname;
    }

    private static RbelInternetAddress parseJavaHostnameAddressScheme(String addressString, int slashIndex) {
        String hostname = addressString.substring(0, slashIndex);
        String ipAddress = addressString.substring(slashIndex + 1);
        try {
            byte[] ipBytes = InetAddress.getByName(ipAddress).getAddress();
            return new RbelInternetAddress(StringUtils.isEmpty((CharSequence)hostname) ? ipAddress : hostname, ipBytes);
        }
        catch (UnknownHostException e) {
            return new RbelInternetAddress(hostname, null);
        }
    }

    @Generated
    private RbelInternetAddressParser() {
    }
}

