/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.util;

import java.beans.ConstructorProperties;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public final class RbelInternetAddress {
    private final String hostname;
    private final byte[] ipAddress;

    public static RbelInternetAddress fromInetAddress(InetAddress ipAddress) {
        return new RbelInternetAddress(ipAddress.getHostName(), ipAddress.getAddress());
    }

    public String toString() {
        if (this.ipAddress != null) {
            if (StringUtils.isBlank((CharSequence)this.hostname)) {
                return InetAddress.getByAddress(this.ipAddress).getHostAddress();
            }
            return this.hostname + "/" + InetAddress.getByAddress(this.ipAddress).getHostAddress();
        }
        return this.hostname;
    }

    public String printValidHostname() {
        if (this.hostname != null) {
            return this.hostname;
        }
        if (this.ipAddress != null) {
            return InetAddress.getByAddress(this.ipAddress).getHostAddress();
        }
        return "<unknown-host>";
    }

    public Optional<InetAddress> toInetAddress() {
        try {
            if (this.ipAddress != null) {
                return Optional.of(InetAddress.getByAddress(this.ipAddress));
            }
            return Optional.ofNullable(InetAddress.getByName(this.hostname));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Generated
    public byte[] getIpAddress() {
        return this.ipAddress;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelInternetAddress)) {
            return false;
        }
        RbelInternetAddress other = (RbelInternetAddress)o;
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        return Arrays.equals(this.getIpAddress(), other.getIpAddress());
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        result = result * 59 + Arrays.hashCode(this.getIpAddress());
        return result;
    }

    @ConstructorProperties(value={"hostname", "ipAddress"})
    @Generated
    public RbelInternetAddress(String hostname, byte[] ipAddress) {
        this.hostname = hostname;
        this.ipAddress = ipAddress;
    }
}

