/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.gematik.test.tiger.common.config.DuplicateMapKeysForbiddenConstructor;
import de.gematik.test.tiger.common.config.TigerConfigurationException;
import de.gematik.test.tiger.common.config.TigerConfigurationKey;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.representer.Representer;

public class TigerSerializationUtil {
    private static final ObjectMapper objMapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);

    private TigerSerializationUtil() {
    }

    public static JSONObject yamlToJsonObject(String yamlStr) {
        Yaml yaml = new Yaml((BaseConstructor)new DuplicateMapKeysForbiddenConstructor());
        Map map = (Map)yaml.load(yamlStr);
        return new JSONObject(map);
    }

    public static <T> T fromJson(String jsonFile, Class<T> targetClass) {
        try {
            return (T)objMapper.readValue(jsonFile, targetClass);
        }
        catch (IOException e) {
            throw new TigerConfigurationException("Failed to convert given JSON string to object of class " + targetClass.getName() + "!", e);
        }
    }

    public static String toJson(Object value) {
        try {
            return objMapper.writerWithDefaultPrettyPrinter().writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new TigerConfigurationException("Failed to convert given object to JSON!", e);
        }
    }

    public static Map<String, String> toMap(Object value, String ... baseKeys) {
        return TigerSerializationUtil.recursiveMapDumping(new JSONObject(TigerSerializationUtil.toJson(value)), new TigerConfigurationKey(baseKeys)).entrySet().stream().collect(Collectors.toMap((? super T e) -> ((TigerConfigurationKey)e.getKey()).downsampleKey(), Map.Entry::getValue));
    }

    private static Map<TigerConfigurationKey, String> recursiveMapDumping(JSONObject jsonObject, TigerConfigurationKey baseKey) {
        HashMap<TigerConfigurationKey, String> result = new HashMap<TigerConfigurationKey, String>();
        for (String key : jsonObject.keySet()) {
            Object value = jsonObject.get(key);
            if (value instanceof JSONObject) {
                JSONObject asJsonObject = (JSONObject)value;
                result.putAll(TigerSerializationUtil.recursiveMapDumping(asJsonObject, new TigerConfigurationKey(baseKey, key)));
                continue;
            }
            if (value instanceof JSONArray) {
                JSONArray asJsonArray = (JSONArray)value;
                result.putAll(TigerSerializationUtil.recursiveMapDumping(asJsonArray, new TigerConfigurationKey(baseKey, key)));
                continue;
            }
            result.put(new TigerConfigurationKey(baseKey, key), value.toString());
        }
        return result;
    }

    private static Map<TigerConfigurationKey, String> recursiveMapDumping(JSONArray value, TigerConfigurationKey baseKey) {
        HashMap<TigerConfigurationKey, String> result = new HashMap<TigerConfigurationKey, String>();
        int index = 0;
        for (Object entry : value) {
            String key = Integer.toString(index);
            if (entry instanceof JSONObject) {
                JSONObject asJsonObject = (JSONObject)entry;
                result.putAll(TigerSerializationUtil.recursiveMapDumping(asJsonObject, new TigerConfigurationKey(baseKey, key)));
            } else if (entry instanceof JSONArray) {
                JSONArray asJsonArray = (JSONArray)entry;
                result.putAll(TigerSerializationUtil.recursiveMapDumping(asJsonArray, new TigerConfigurationKey(baseKey, key)));
            } else if (entry != null) {
                result.put(new TigerConfigurationKey(baseKey, key), entry.toString());
            }
            ++index;
        }
        return result;
    }

    public static String toNestedYaml(Map<String, String> flatMap) {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml((BaseConstructor)new DuplicateMapKeysForbiddenConstructor(), new Representer(dumperOptions));
        return yaml.dump(TigerSerializationUtil.convertFlatToNestedMap(flatMap));
    }

    public static Map<String, Object> convertFlatToNestedMap(Map<String, String> flatMap) {
        TreeMap<String, String> withSortedKeys = new TreeMap<String, String>(flatMap);
        TreeMap<String, Object> nestedMap = new TreeMap<String, Object>();
        for (Map.Entry<String, String> entry : withSortedKeys.entrySet()) {
            TigerSerializationUtil.addToNestedMap(nestedMap, entry);
        }
        return nestedMap;
    }

    private static void addToNestedMap(Map<String, Object> nestedMap, Map.Entry<String, String> entry) {
        String[] keys = entry.getKey().split("\\.");
        Map currentMap = nestedMap;
        for (int i = 0; i < keys.length - 1; ++i) {
            String key = keys[i];
            Object currentValue = currentMap.computeIfAbsent((String)key, k1 -> new TreeMap());
            if (!(currentValue instanceof Map)) {
                String remainingKey = String.join((CharSequence)".", Arrays.copyOfRange(keys, i, keys.length));
                currentMap.put(remainingKey, entry.getValue());
                return;
            }
            currentMap = (Map)currentValue;
        }
        currentMap.put((String)keys[keys.length - 1], (Object)entry.getValue());
    }
}

