/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common.data.config.tigerproxy;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class TigerRouteAuthenticationConfiguration
implements Serializable {
    private String username;
    private String password;
    private String bearerToken;

    public Optional<String> toAuthorizationHeaderValue() {
        if (StringUtils.isNotEmpty((CharSequence)this.bearerToken)) {
            return Optional.of("Bearer " + this.bearerToken);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.username) && StringUtils.isNotEmpty((CharSequence)this.password)) {
            return Optional.of("Basic " + Base64.getEncoder().encodeToString((this.username + ":" + this.password).getBytes(StandardCharsets.US_ASCII)));
        }
        return Optional.empty();
    }

    @Generated
    public static TigerRouteAuthenticationConfigurationBuilder builder() {
        return new TigerRouteAuthenticationConfigurationBuilder();
    }

    @Generated
    public TigerRouteAuthenticationConfigurationBuilder toBuilder() {
        return new TigerRouteAuthenticationConfigurationBuilder().username(this.username).password(this.password).bearerToken(this.bearerToken);
    }

    @Generated
    public TigerRouteAuthenticationConfiguration() {
    }

    @ConstructorProperties(value={"username", "password", "bearerToken"})
    @Generated
    private TigerRouteAuthenticationConfiguration(String username, String password, String bearerToken) {
        this.username = username;
        this.password = password;
        this.bearerToken = bearerToken;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getBearerToken() {
        return this.bearerToken;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setBearerToken(String bearerToken) {
        this.bearerToken = bearerToken;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TigerRouteAuthenticationConfiguration)) {
            return false;
        }
        TigerRouteAuthenticationConfiguration other = (TigerRouteAuthenticationConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$bearerToken = this.getBearerToken();
        String other$bearerToken = other.getBearerToken();
        return !(this$bearerToken == null ? other$bearerToken != null : !this$bearerToken.equals(other$bearerToken));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TigerRouteAuthenticationConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $bearerToken = this.getBearerToken();
        result = result * 59 + ($bearerToken == null ? 43 : $bearerToken.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TigerRouteAuthenticationConfiguration(username=" + this.getUsername() + ", password=" + this.getPassword() + ", bearerToken=" + this.getBearerToken() + ")";
    }

    @Generated
    public static class TigerRouteAuthenticationConfigurationBuilder {
        @Generated
        private String username;
        @Generated
        private String password;
        @Generated
        private String bearerToken;

        @Generated
        TigerRouteAuthenticationConfigurationBuilder() {
        }

        @Generated
        public TigerRouteAuthenticationConfigurationBuilder username(String username) {
            this.username = username;
            return this;
        }

        @Generated
        public TigerRouteAuthenticationConfigurationBuilder password(String password) {
            this.password = password;
            return this;
        }

        @Generated
        public TigerRouteAuthenticationConfigurationBuilder bearerToken(String bearerToken) {
            this.bearerToken = bearerToken;
            return this;
        }

        @Generated
        public TigerRouteAuthenticationConfiguration build() {
            return new TigerRouteAuthenticationConfiguration(this.username, this.password, this.bearerToken);
        }

        @Generated
        public String toString() {
            return "TigerRouteAuthenticationConfiguration.TigerRouteAuthenticationConfigurationBuilder(username=" + this.username + ", password=" + this.password + ", bearerToken=" + this.bearerToken + ")";
        }
    }
}

