/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common.data.config.tigerproxy;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.gematik.test.tiger.common.data.config.tigerproxy.TigerProxyType;
import de.gematik.test.tiger.common.exceptions.TigerUnknownProtocolException;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ForwardProxyInfo {
    private String hostname;
    private Integer port;
    private TigerProxyType type;
    private String username;
    private String password;
    private List<String> noProxyHosts;

    public TigerProxyType getProxyProtocol(String proxyProtocol) {
        if (proxyProtocol.equalsIgnoreCase("http")) {
            return TigerProxyType.HTTP;
        }
        if (proxyProtocol.equalsIgnoreCase("https")) {
            return TigerProxyType.HTTPS;
        }
        throw new TigerUnknownProtocolException("Protocol of type " + proxyProtocol + " not specified for proxies");
    }

    public int calculateProxyPort() {
        if (this.port == null || this.port == -1) {
            if (this.type == TigerProxyType.HTTP) {
                return 80;
            }
            if (this.type == TigerProxyType.HTTPS) {
                return 443;
            }
            return -1;
        }
        return this.port;
    }

    public static String mapProxyPort(String proxyPort, TigerProxyType type) {
        if (proxyPort == null || proxyPort.equals("null") || proxyPort.equals("-1")) {
            if (type == TigerProxyType.HTTP) {
                return "80";
            }
            if (type == TigerProxyType.HTTPS) {
                return "443";
            }
        }
        return proxyPort;
    }

    @Generated
    private static TigerProxyType $default$type() {
        return TigerProxyType.HTTP;
    }

    @Generated
    public static ForwardProxyInfoBuilder builder() {
        return new ForwardProxyInfoBuilder();
    }

    @ConstructorProperties(value={"hostname", "port", "type", "username", "password", "noProxyHosts"})
    @Generated
    public ForwardProxyInfo(String hostname, Integer port, TigerProxyType type, String username, String password, List<String> noProxyHosts) {
        this.hostname = hostname;
        this.port = port;
        this.type = type;
        this.username = username;
        this.password = password;
        this.noProxyHosts = noProxyHosts;
    }

    @Generated
    public ForwardProxyInfo() {
        this.type = ForwardProxyInfo.$default$type();
    }

    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public TigerProxyType getType() {
        return this.type;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public List<String> getNoProxyHosts() {
        return this.noProxyHosts;
    }

    @Generated
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @Generated
    public void setPort(Integer port) {
        this.port = port;
    }

    @Generated
    public void setType(TigerProxyType type) {
        this.type = type;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setNoProxyHosts(List<String> noProxyHosts) {
        this.noProxyHosts = noProxyHosts;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ForwardProxyInfo)) {
            return false;
        }
        ForwardProxyInfo other = (ForwardProxyInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        TigerProxyType this$type = this.getType();
        TigerProxyType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        List<String> this$noProxyHosts = this.getNoProxyHosts();
        List<String> other$noProxyHosts = other.getNoProxyHosts();
        return !(this$noProxyHosts == null ? other$noProxyHosts != null : !((Object)this$noProxyHosts).equals(other$noProxyHosts));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ForwardProxyInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        TigerProxyType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        List<String> $noProxyHosts = this.getNoProxyHosts();
        result = result * 59 + ($noProxyHosts == null ? 43 : ((Object)$noProxyHosts).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ForwardProxyInfo(hostname=" + this.getHostname() + ", port=" + this.getPort() + ", type=" + String.valueOf((Object)this.getType()) + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", noProxyHosts=" + String.valueOf(this.getNoProxyHosts()) + ")";
    }

    @Generated
    public static class ForwardProxyInfoBuilder {
        @Generated
        private String hostname;
        @Generated
        private Integer port;
        @Generated
        private boolean type$set;
        @Generated
        private TigerProxyType type$value;
        @Generated
        private String username;
        @Generated
        private String password;
        @Generated
        private List<String> noProxyHosts;

        @Generated
        ForwardProxyInfoBuilder() {
        }

        @Generated
        public ForwardProxyInfoBuilder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        @Generated
        public ForwardProxyInfoBuilder port(Integer port) {
            this.port = port;
            return this;
        }

        @Generated
        public ForwardProxyInfoBuilder type(TigerProxyType type) {
            this.type$value = type;
            this.type$set = true;
            return this;
        }

        @Generated
        public ForwardProxyInfoBuilder username(String username) {
            this.username = username;
            return this;
        }

        @Generated
        public ForwardProxyInfoBuilder password(String password) {
            this.password = password;
            return this;
        }

        @Generated
        public ForwardProxyInfoBuilder noProxyHosts(List<String> noProxyHosts) {
            this.noProxyHosts = noProxyHosts;
            return this;
        }

        @Generated
        public ForwardProxyInfo build() {
            TigerProxyType type$value = this.type$value;
            if (!this.type$set) {
                type$value = ForwardProxyInfo.$default$type();
            }
            return new ForwardProxyInfo(this.hostname, this.port, type$value, this.username, this.password, this.noProxyHosts);
        }

        @Generated
        public String toString() {
            return "ForwardProxyInfo.ForwardProxyInfoBuilder(hostname=" + this.hostname + ", port=" + this.port + ", type$value=" + String.valueOf((Object)this.type$value) + ", username=" + this.username + ", password=" + this.password + ", noProxyHosts=" + String.valueOf(this.noProxyHosts) + ")";
        }
    }
}

