/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common.pki;

import de.gematik.test.tiger.common.pki.TigerPkiIdentityInformation;
import de.gematik.test.tiger.common.pki.TigerPkiIdentityLoader;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public class TigerPkiIdentity {
    private X509Certificate certificate;
    private PrivateKey privateKey;
    private Optional<String> keyId = Optional.empty();
    private final List<X509Certificate> certificateChain = new ArrayList<X509Certificate>();

    public TigerPkiIdentity(X509Certificate certificate, PrivateKey privateKey) {
        this.certificate = certificate;
        this.privateKey = privateKey;
        this.keyId = Optional.empty();
    }

    public TigerPkiIdentity(String fileLoadingInformation) {
        this(TigerPkiIdentityLoader.parseInformationString(fileLoadingInformation));
    }

    public TigerPkiIdentity(TigerPkiIdentityInformation fileLoadingInformation) {
        TigerPkiIdentity identity = TigerPkiIdentityLoader.loadIdentity(fileLoadingInformation);
        this.setCertificate(identity.getCertificate());
        this.setPrivateKey(identity.getPrivateKey());
        this.setKeyId(identity.getKeyId());
        this.certificateChain.addAll(identity.getCertificateChain());
    }

    public TigerPkiIdentity addCertificateToCertificateChain(X509Certificate newChainCertificate) {
        this.certificateChain.add(newChainCertificate);
        return this;
    }

    public KeyStore toKeyStoreWithPassword(String password) {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null);
            Certificate[] keystoreEntryChain = new Certificate[this.certificateChain.size() + 1];
            keystoreEntryChain[0] = this.getCertificate();
            for (int i = 0; i < this.certificateChain.size(); ++i) {
                keystoreEntryChain[i + 1] = this.certificateChain.get(i);
            }
            char[] passwordCharArray = password == null ? null : password.toCharArray();
            keyStore.setEntry("entry", new KeyStore.PrivateKeyEntry(this.getPrivateKey(), keystoreEntryChain), new KeyStore.PasswordProtection(passwordCharArray));
            return keyStore;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new TigerPkiIdentityLoader.TigerPkiIdentityLoaderException("Error while creating keystore", e);
        }
    }

    public List<X509Certificate> buildChainWithCertificate() {
        ArrayList<X509Certificate> certificateWithChain = new ArrayList<X509Certificate>();
        certificateWithChain.add(this.getCertificate());
        certificateWithChain.addAll(this.certificateChain);
        return certificateWithChain;
    }

    @Generated
    public static TigerPkiIdentityBuilder builder() {
        return new TigerPkiIdentityBuilder();
    }

    @Generated
    public X509Certificate getCertificate() {
        return this.certificate;
    }

    @Generated
    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Generated
    public Optional<String> getKeyId() {
        return this.keyId;
    }

    @Generated
    public List<X509Certificate> getCertificateChain() {
        return this.certificateChain;
    }

    @Generated
    public void setCertificate(X509Certificate certificate) {
        this.certificate = certificate;
    }

    @Generated
    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    @Generated
    public void setKeyId(Optional<String> keyId) {
        this.keyId = keyId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TigerPkiIdentity)) {
            return false;
        }
        TigerPkiIdentity other = (TigerPkiIdentity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        X509Certificate this$certificate = this.getCertificate();
        X509Certificate other$certificate = other.getCertificate();
        if (this$certificate == null ? other$certificate != null : !((Object)this$certificate).equals(other$certificate)) {
            return false;
        }
        PrivateKey this$privateKey = this.getPrivateKey();
        PrivateKey other$privateKey = other.getPrivateKey();
        if (this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey)) {
            return false;
        }
        Optional<String> this$keyId = this.getKeyId();
        Optional<String> other$keyId = other.getKeyId();
        if (this$keyId == null ? other$keyId != null : !((Object)this$keyId).equals(other$keyId)) {
            return false;
        }
        List<X509Certificate> this$certificateChain = this.getCertificateChain();
        List<X509Certificate> other$certificateChain = other.getCertificateChain();
        return !(this$certificateChain == null ? other$certificateChain != null : !((Object)this$certificateChain).equals(other$certificateChain));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TigerPkiIdentity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        X509Certificate $certificate = this.getCertificate();
        result = result * 59 + ($certificate == null ? 43 : ((Object)$certificate).hashCode());
        PrivateKey $privateKey = this.getPrivateKey();
        result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
        Optional<String> $keyId = this.getKeyId();
        result = result * 59 + ($keyId == null ? 43 : ((Object)$keyId).hashCode());
        List<X509Certificate> $certificateChain = this.getCertificateChain();
        result = result * 59 + ($certificateChain == null ? 43 : ((Object)$certificateChain).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TigerPkiIdentity(certificate=" + String.valueOf(this.getCertificate()) + ", privateKey=" + String.valueOf(this.getPrivateKey()) + ", keyId=" + String.valueOf(this.getKeyId()) + ", certificateChain=" + String.valueOf(this.getCertificateChain()) + ")";
    }

    @Generated
    public TigerPkiIdentity() {
    }

    @ConstructorProperties(value={"certificate", "privateKey", "keyId"})
    @Generated
    public TigerPkiIdentity(X509Certificate certificate, PrivateKey privateKey, Optional<String> keyId) {
        this.certificate = certificate;
        this.privateKey = privateKey;
        this.keyId = keyId;
    }

    @Generated
    public TigerPkiIdentity withKeyId(Optional<String> keyId) {
        return this.keyId == keyId ? this : new TigerPkiIdentity(this.certificate, this.privateKey, keyId);
    }

    @Generated
    public static class TigerPkiIdentityBuilder {
        @Generated
        private X509Certificate certificate;
        @Generated
        private PrivateKey privateKey;
        @Generated
        private Optional<String> keyId;

        @Generated
        TigerPkiIdentityBuilder() {
        }

        @Generated
        public TigerPkiIdentityBuilder certificate(X509Certificate certificate) {
            this.certificate = certificate;
            return this;
        }

        @Generated
        public TigerPkiIdentityBuilder privateKey(PrivateKey privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        @Generated
        public TigerPkiIdentityBuilder keyId(Optional<String> keyId) {
            this.keyId = keyId;
            return this;
        }

        @Generated
        public TigerPkiIdentity build() {
            return new TigerPkiIdentity(this.certificate, this.privateKey, this.keyId);
        }

        @Generated
        public String toString() {
            return "TigerPkiIdentity.TigerPkiIdentityBuilder(certificate=" + String.valueOf(this.certificate) + ", privateKey=" + String.valueOf(this.privateKey) + ", keyId=" + String.valueOf(this.keyId) + ")";
        }
    }
}

