/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common.data.config;

import de.gematik.test.tiger.common.config.DuplicateMapKeysForbiddenConstructor;
import de.gematik.test.tiger.common.config.TigerConfigurationException;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.StringReader;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;

public enum ConfigurationFileType {
    YAML(ConfigurationFileType::loadYamlFile),
    ENV(ConfigurationFileType::loadPropertiesFile),
    PROPERTY(ConfigurationFileType::loadPropertiesFile);

    private final Function<String, Object> loaderFunction;

    private static Object loadYamlFile(String str) {
        return new Yaml((BaseConstructor)new DuplicateMapKeysForbiddenConstructor()).load(str);
    }

    private static Map<String, String> loadPropertiesFile(String str) {
        try {
            Properties properties = new Properties();
            properties.load(new StringReader(str));
            return properties.entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), e -> e.getValue().toString()));
        }
        catch (IOException e2) {
            throw new TigerConfigurationException("Error while loading properties file", e2);
        }
    }

    public Object loadFromString(String source) {
        return this.loaderFunction.apply(source);
    }

    @ConstructorProperties(value={"loaderFunction"})
    @Generated
    private ConfigurationFileType(Function<String, Object> loaderFunction) {
        this.loaderFunction = loaderFunction;
    }
}

