/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common.config;

import de.gematik.test.tiger.common.config.ConfigurationValuePrecedence;
import de.gematik.test.tiger.common.config.TigerConfigurationException;
import de.gematik.test.tiger.common.config.TigerConfigurationKey;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;

public class TigerTypedConfigurationKey<T> {
    private final TigerConfigurationKey key;
    private final Optional<T> defaultValue;
    private final Function<String, T> typeConstructor;

    public TigerTypedConfigurationKey(String key, Class<T> type) {
        this(key, type, null);
    }

    public TigerTypedConfigurationKey(String key, Class<T> type, T defaultValue) {
        this(new TigerConfigurationKey(key), type, defaultValue);
    }

    public TigerTypedConfigurationKey(TigerConfigurationKey key, Class<T> type) {
        this(key, type, null);
    }

    public TigerTypedConfigurationKey(TigerConfigurationKey key, Class<T> type, T defaultValue) {
        this.key = key;
        this.typeConstructor = type.isArray() ? s -> {
            String[] split = s.split(",");
            Object[] array = (Object[])Array.newInstance(type.getComponentType(), split.length);
            for (int i = 0; i < split.length; ++i) {
                try {
                    Array.set(array, i, ((Class)type.componentType()).getConstructor(String.class).newInstance(split[i].trim()));
                    continue;
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new TigerConfigurationException("Exception while retrieving value for key " + key.downsampleKey() + " and type " + String.valueOf(type), e);
                }
            }
            return array;
        } : s -> {
            try {
                return type.getConstructor(String.class).newInstance(s);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new TigerConfigurationException("Exception while retrieving value for key " + key.downsampleKey() + " and type " + String.valueOf(type), e);
            }
        };
        this.defaultValue = Optional.ofNullable(defaultValue);
    }

    public Optional<T> getValue() {
        return TigerGlobalConfiguration.readStringOptional(this.key.downsampleKey()).map(this::getInstance);
    }

    public Optional<T> getValueWithoutResolving() {
        return TigerGlobalConfiguration.readStringWithoutResolving(this.key.downsampleKey()).map(this::getInstance);
    }

    public T getValueOrDefault() {
        return this.getValue().or(() -> this.defaultValue).orElseThrow();
    }

    private T getInstance(String s) {
        return this.typeConstructor.apply(s);
    }

    public void putValue(T value) {
        TigerGlobalConfiguration.putValue(this.key.downsampleKey(), value);
    }

    public void putValue(T value, ConfigurationValuePrecedence precedence) {
        TigerGlobalConfiguration.putValue(this.key.downsampleKey(), value, precedence);
    }

    public void clearValue() {
        TigerGlobalConfiguration.deleteFromAllSources(this.key);
    }

    public void setAsSystemProperty(T value) {
        System.setProperty(this.key.downsampleKey(), value.toString());
    }

    public void clearSystemProperty() {
        System.clearProperty(this.key.downsampleKey());
    }

    @Generated
    public TigerConfigurationKey getKey() {
        return this.key;
    }
}

