/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common.config;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.cfg.ContextAttributes;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import de.gematik.test.tiger.common.TokenSubstituteHelper;
import de.gematik.test.tiger.common.config.TigerConfigurationLoader;
import de.gematik.test.tiger.zion.config.TigerSkipEvaluation;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TigerConfigurationObjectMapperBuilder {
    private final JsonMapper objectMapper;

    public TigerConfigurationObjectMapperBuilder(TigerConfigurationLoader configurationLoader) {
        SimpleModule skipEvaluationModule = new SimpleModule();
        skipEvaluationModule.addDeserializer(String.class, (JsonDeserializer)new SkipEvaluationDeserializer(configurationLoader));
        this.objectMapper = (JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true)).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).propertyNamingStrategy(PropertyNamingStrategies.LOWER_CASE)).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS})).addModule((Module)new JavaTimeModule())).addModule((Module)new AllowDelayedPrimitiveResolvementModule(configurationLoader))).addModule((Module)skipEvaluationModule)).defaultAttributes(ContextAttributes.getEmpty().withSharedAttributes(Map.of("tigerConfiguration", configurationLoader)))).build();
    }

    public ObjectMapper retrieveLenientObjectMapper() {
        return this.objectMapper;
    }

    public static class SkipEvaluationDeserializer
    extends JsonDeserializer<String>
    implements ContextualDeserializer {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(SkipEvaluationDeserializer.class);
        private final TigerConfigurationLoader configurationLoader;
        private boolean skipEvaluation;

        public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
            this.skipEvaluation = property != null && property.getAnnotation(TigerSkipEvaluation.class) != null;
            return new SkipEvaluationDeserializer(this.configurationLoader, this.skipEvaluation);
        }

        public String deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            String valueAsString = jsonParser.getValueAsString();
            if (this.skipEvaluation) {
                return valueAsString;
            }
            return TokenSubstituteHelper.substitute(valueAsString, this.configurationLoader);
        }

        @ConstructorProperties(value={"configurationLoader"})
        @Generated
        public SkipEvaluationDeserializer(TigerConfigurationLoader configurationLoader) {
            this.configurationLoader = configurationLoader;
        }

        @ConstructorProperties(value={"configurationLoader", "skipEvaluation"})
        @Generated
        public SkipEvaluationDeserializer(TigerConfigurationLoader configurationLoader, boolean skipEvaluation) {
            this.configurationLoader = configurationLoader;
            this.skipEvaluation = skipEvaluation;
        }
    }

    private static class AllowDelayedPrimitiveResolvementModule
    extends Module {
        private TigerConfigurationLoader tigerConfigurationLoader;

        public String getModuleName() {
            return "fallback provider";
        }

        public Version version() {
            return Version.unknownVersion();
        }

        public void setupModule(Module.SetupContext setupContext) {
            setupContext.addDeserializationProblemHandler((DeserializationProblemHandler)new ClazzFallbackConverter(this.tigerConfigurationLoader));
        }

        @ConstructorProperties(value={"tigerConfigurationLoader"})
        @Generated
        public AllowDelayedPrimitiveResolvementModule(TigerConfigurationLoader tigerConfigurationLoader) {
            this.tigerConfigurationLoader = tigerConfigurationLoader;
        }
    }

    private static class ClazzFallbackConverter
    extends DeserializationProblemHandler {
        TigerConfigurationLoader tigerConfigurationLoader;

        public Object handleWeirdStringValue(DeserializationContext ctxt, Class<?> targetType, String valueToConvert, String failureMsg) throws IOException {
            if (valueToConvert.contains("!{") || valueToConvert.contains("${")) {
                String substitute = TokenSubstituteHelper.substitute(valueToConvert, this.tigerConfigurationLoader);
                if (!substitute.equals(valueToConvert)) {
                    TextNode replacedTextNode = ctxt.getNodeFactory().textNode(substitute);
                    return ctxt.readTreeAsValue((JsonNode)replacedTextNode, targetType);
                }
                return this.returnTigerSpecificFallbackValue(ctxt, targetType, valueToConvert, failureMsg);
            }
            return super.handleWeirdStringValue(ctxt, targetType, valueToConvert, failureMsg);
        }

        Object returnTigerSpecificFallbackValue(DeserializationContext ctxt, Class<?> targetType, String valueToConvert, String failureMsg) throws IOException {
            if (targetType.equals(Boolean.class) || targetType.equals(Integer.class) || targetType.equals(Long.class) || targetType.equals(Character.class) || targetType.equals(Double.class) || targetType.equals(Float.class) || targetType.equals(Byte.class) || targetType.equals(Short.class)) {
                return null;
            }
            if (targetType.equals(Boolean.TYPE)) {
                return false;
            }
            if (targetType.equals(Integer.TYPE)) {
                return -1;
            }
            if (targetType.equals(Long.TYPE)) {
                return -1L;
            }
            if (targetType.equals(Double.TYPE)) {
                return -1.0;
            }
            if (targetType.equals(Float.TYPE)) {
                return Float.valueOf(-1.0f);
            }
            if (targetType.equals(Short.TYPE)) {
                return (short)-1;
            }
            if (targetType.equals(Character.TYPE)) {
                return Character.valueOf(' ');
            }
            if (targetType.equals(Byte.TYPE)) {
                return (byte)-1;
            }
            return super.handleWeirdStringValue(ctxt, targetType, valueToConvert, failureMsg);
        }

        @ConstructorProperties(value={"tigerConfigurationLoader"})
        @Generated
        public ClazzFallbackConverter(TigerConfigurationLoader tigerConfigurationLoader) {
            this.tigerConfigurationLoader = tigerConfigurationLoader;
        }
    }
}

