/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common;

import de.gematik.test.tiger.common.config.TigerConfigurationLoader;
import de.gematik.test.tiger.common.exceptions.TigerJexlException;
import de.gematik.test.tiger.common.jexl.TigerJexlContext;
import de.gematik.test.tiger.common.jexl.TigerJexlExecutor;
import java.util.Deque;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.BiFunction;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.lang3.tuple.Pair;

public final class TokenSubstituteHelper {
    private static final Deque<Pair<Character, ReplacerFunction>> REPLACER_ORDER = new ConcurrentLinkedDeque<Pair<Character, ReplacerFunction>>();
    private static final int MAXIMUM_NUMBER_OF_REPLACEMENTS = 1000;
    private static BiFunction<String, TigerConfigurationLoader, Optional<String>> resolve = (key, config) -> config.readStringOptional((String)key);

    private static Optional<String> replaceWithConfigurationValue(String str, TigerConfigurationLoader source, Optional<TigerJexlContext> ctx) {
        if (ctx.isPresent() && ctx.get().has(str)) {
            return ctx.map(c -> c.get(str).toString());
        }
        if (str.contains("{") || str.contains("}")) {
            return Optional.empty();
        }
        Optional<String> fallbackValue = Optional.of(str).filter(s -> s.contains("|")).map(s -> Optional.of(s.split("\\|", 2)).filter(split -> ((String[])split).length == 2).map(split -> split[1]).orElse(""));
        Optional<String> key = Optional.of(str).map(s -> s.split("\\|")[0]);
        return key.flatMap(k -> resolve.apply((String)k, source)).or(() -> key.flatMap(k -> ctx.map(context -> context.get((String)k)).map(Object::toString))).or(() -> ctx.map(context -> context.get(str)).map(Object::toString)).or(() -> fallbackValue);
    }

    public static String substitute(String value, TigerConfigurationLoader source) {
        return TokenSubstituteHelper.substitute(value, source, Optional.empty());
    }

    public static String substitute(String value, TigerConfigurationLoader source, @NonNull Optional<TigerJexlContext> context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        String result = value;
        boolean keepOnReplacing = true;
        int iterationsLeft = 1000;
        if (value == null) {
            return null;
        }
        while (keepOnReplacing) {
            keepOnReplacing = false;
            for (Pair<Character, ReplacerFunction> replacer : REPLACER_ORDER) {
                Optional<String> replacedOptional = TokenSubstituteHelper.replacePlaceholderWithGivenIntro(result, ((Character)replacer.getKey()).charValue(), (ReplacerFunction)replacer.getValue(), source, context);
                if (!replacedOptional.isPresent()) continue;
                result = replacedOptional.get();
                keepOnReplacing = true;
            }
            if (iterationsLeft-- > 0) continue;
            break;
        }
        return result;
    }

    private static Optional<String> replacePlaceholderWithGivenIntro(String str, char intro, ReplacerFunction placeholderResolver, TigerConfigurationLoader source, Optional<TigerJexlContext> context) {
        String tokenStr = intro + "{";
        int varIdx = str.indexOf(tokenStr);
        while (varIdx != -1) {
            int endVar = str.indexOf(125, varIdx);
            if (endVar == -1) {
                return Optional.empty();
            }
            String placeholderString = str.substring(varIdx + tokenStr.length(), endVar);
            Optional<String> valueOptional = placeholderResolver.replace(placeholderString, source, context);
            if (valueOptional.isPresent()) {
                return Optional.of(str.substring(0, varIdx) + valueOptional.get() + str.substring(endVar + 1));
            }
            varIdx = str.indexOf(tokenStr, varIdx + 1);
        }
        return Optional.empty();
    }

    public static Deque<Pair<Character, ReplacerFunction>> getReplacerOrder() {
        return REPLACER_ORDER;
    }

    @Generated
    private TokenSubstituteHelper() {
    }

    @Generated
    public static BiFunction<String, TigerConfigurationLoader, Optional<String>> getResolve() {
        return resolve;
    }

    @Generated
    public static void setResolve(BiFunction<String, TigerConfigurationLoader, Optional<String>> resolve) {
        TokenSubstituteHelper.resolve = resolve;
    }

    static {
        REPLACER_ORDER.add((Pair<Character, ReplacerFunction>)Pair.of((Object)Character.valueOf('$'), TokenSubstituteHelper::replaceWithConfigurationValue));
        REPLACER_ORDER.add((Pair<Character, ReplacerFunction>)Pair.of((Object)Character.valueOf('!'), (str, source, ctx) -> {
            try {
                return TigerJexlExecutor.evaluateJexlExpression(str, ctx.orElseGet(TigerJexlContext::new)).map(Object::toString);
            }
            catch (RuntimeException e) {
                if (e instanceof TigerJexlException && e.getCause() instanceof JexlException && e.getCause().getMessage().contains("parsing error in '{'")) {
                    return Optional.empty();
                }
                throw e;
            }
        }));
    }

    public static interface ReplacerFunction {
        public Optional<String> replace(String var1, TigerConfigurationLoader var2, Optional<TigerJexlContext> var3);
    }
}

