/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.util;

import de.gematik.rbellogger.util.GlobalServerMap;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;
import oshi.software.os.InternetProtocolStats;
import oshi.software.os.OperatingSystem;

public class PortToProcessMapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PortToProcessMapper.class);

    private PortToProcessMapper() {
        throw new IllegalStateException("PortToProcessMapper class");
    }

    public static ConcurrentMap<Integer, Long> getProcessIdsForPort(int port) {
        PortToProcessMapper.getConnectionsToAndFromPort(port).forEach(PortToProcessMapper::fillMapWithValues);
        return GlobalServerMap.getPortToProcessId();
    }

    private static void fillMapWithValues(InternetProtocolStats.IPConnection connection) {
        if (GlobalServerMap.getProcessIdToBundledServerName().containsKey(connection.getowningProcessId())) {
            GlobalServerMap.mapPortToProcessIds(connection.getLocalPort(), connection.getowningProcessId());
            GlobalServerMap.mapPortToProcessIds(connection.getForeignPort(), connection.getowningProcessId());
        }
    }

    public static List<InternetProtocolStats.IPConnection> getConnectionsToAndFromPort(int port) {
        SystemInfo si = new SystemInfo();
        OperatingSystem os = si.getOperatingSystem();
        InternetProtocolStats ipStats = os.getInternetProtocolStats();
        return ipStats.getConnections().stream().filter(c -> c.getLocalPort() == port || c.getForeignPort() == port).toList();
    }
}

