/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common.pki;

import de.gematik.rbellogger.util.CryptoLoader;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.common.pki.TigerPkiIdentity;
import de.gematik.test.tiger.common.pki.TigerPkiIdentityInformation;
import de.gematik.test.tiger.common.util.TigerSecurityProviderInitialiser;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerPkiIdentityLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerPkiIdentityLoader.class);
    private static final String CLASSPATH_PREFIX = "classpath:";
    private static final List<String> DEFAULT_KEYSTORE_PASSWORDS = List.of("00", "123456", "gematik", "changeit", "12345678", "1234567890", "password", "qwerty", "123456789", "12345", "abcdef", "111111", "1234567", "password1", "letmein", "admin", "welcome", "iloveyou", "sunshine", "abc123", "trustno1", "123123", "monkey", "dragon");

    public static TigerPkiIdentity loadRbelPkiIdentity(String information) {
        return TigerPkiIdentityLoader.guessStringPartsAndTryToLoadIdentity(information);
    }

    public static TigerPkiIdentity loadRbelPkiIdentityWithGuessedPassword(File file) {
        Pair keystore = Pair.of((Object)file.getAbsolutePath(), (Object)FileUtils.readFileToByteArray((File)file));
        List<String> keystorePasswords = TigerPkiIdentityLoader.getAllKeystorePasswords();
        List<String> filenameList = List.of((String)keystore.getLeft());
        StoreType storeType = TigerPkiIdentityLoader.guessStoreType(filenameList).orElseThrow();
        for (String password : keystorePasswords) {
            try {
                return TigerPkiIdentityLoader.loadKeystoreFrom(TigerPkiIdentityInformation.builder().filenames(filenameList).storeType(storeType).password(password).build());
            }
            catch (TigerPkiIdentityLoaderException tigerPkiIdentityLoaderException) {
            }
        }
        throw new TigerPkiIdentityLoaderException("Unable to decrypt file %s with any of these keystore passwords: %s".formatted(file.getName(), keystorePasswords));
    }

    static List<String> getAllKeystorePasswords() {
        ArrayList<String> keystorePasswords = new ArrayList<String>(DEFAULT_KEYSTORE_PASSWORDS);
        List<String> additionalPasswords = TigerGlobalConfiguration.readList("tiger", "lib", "additionalKeyStorePasswords");
        keystorePasswords.addAll(additionalPasswords);
        return keystorePasswords;
    }

    private static TigerPkiIdentity guessStringPartsAndTryToLoadIdentity(String information) {
        TigerPkiIdentityInformation identityInformation = TigerPkiIdentityLoader.parseInformationString(information);
        return TigerPkiIdentityLoader.loadIdentity(identityInformation);
    }

    public static TigerPkiIdentityInformation parseInformationString(String information) {
        TigerPkiIdentityInformation identityInformation = new TigerPkiIdentityInformation();
        identityInformation.setUseCompactFormat(true);
        List<String> informationSplits = Stream.of(information.split(";")).map(String::trim).toList();
        identityInformation.setStoreType(TigerPkiIdentityLoader.extractStoreType(informationSplits).or(() -> TigerPkiIdentityLoader.guessStoreType(informationSplits)).orElseThrow(() -> new TigerPkiIdentityLoaderException("Unable to determine store-type for input '" + information + "'!")));
        List<Pair<String, byte[]>> fileNamesAndContent = TigerPkiIdentityLoader.extractFileNames(informationSplits);
        identityInformation.setFilenames(fileNamesAndContent.stream().map(Pair::getLeft).toList());
        if (fileNamesAndContent.isEmpty() || !identityInformation.getStoreType().isKeystore() && fileNamesAndContent.size() < 2) {
            throw new IllegalArgumentException("Could not find file information in parameters (maybe the files could not be found?)! (" + information + ")");
        }
        if (identityInformation.getStoreType().isKeystore()) {
            identityInformation.setPassword(TigerPkiIdentityLoader.guessPasswordField(informationSplits, identityInformation.getFilenames(), identityInformation.getStoreType()).orElse(null));
        }
        return identityInformation;
    }

    public static TigerPkiIdentity loadIdentity(TigerPkiIdentityInformation identityInformation) {
        if (identityInformation.getOrGuessStoreType().isKeystore()) {
            if (identityInformation.getPassword() != null) {
                return TigerPkiIdentityLoader.loadKeystoreFrom(identityInformation);
            }
            return TigerPkiIdentityLoader.getAllKeystorePasswords().stream().map(password -> {
                try {
                    return TigerPkiIdentityLoader.loadKeystoreFrom(identityInformation.toBuilder().password((String)password).build());
                }
                catch (Exception e) {
                    return null;
                }
            }).filter(Objects::nonNull).findFirst().orElseThrow(() -> new TigerPkiIdentityLoaderException("No valid password found and could not be guessed for source '" + identityInformation.getFilenames().get(0) + "'"));
        }
        return TigerPkiIdentityLoader.loadCertKeyPair(identityInformation);
    }

    private static Optional<String> guessPasswordField(List<String> informationSplits, List<String> fileNames, StoreType storeType) {
        return informationSplits.stream().filter(part -> !fileNames.contains(part)).filter(part -> !storeType.name().equalsIgnoreCase((String)part) && storeType.getNames().stream().noneMatch(s -> s.equalsIgnoreCase((String)part))).findAny();
    }

    private static TigerPkiIdentity loadCertKeyPair(TigerPkiIdentityInformation identityInformation) {
        byte[] data0 = TigerPkiIdentityLoader.forceReadDataFromLocation(identityInformation.getFilenames().get(0));
        byte[] data1 = TigerPkiIdentityLoader.forceReadDataFromLocation(identityInformation.getFilenames().get(1));
        if (identityInformation.getStoreType() == StoreType.PKCS1) {
            try {
                return CryptoLoader.getIdentityFromPemAndPkcs1(data0, data1);
            }
            catch (Exception e) {
                return CryptoLoader.getIdentityFromPemAndPkcs1(data1, data0);
            }
        }
        try {
            return CryptoLoader.getIdentityFromPemAndPkcs8(data0, data1);
        }
        catch (Exception e) {
            return CryptoLoader.getIdentityFromPemAndPkcs8(data1, data0);
        }
    }

    private static List<Pair<String, byte[]>> extractFileNames(List<String> informationSplits) {
        return informationSplits.stream().map(part -> Pair.of((Object)part, TigerPkiIdentityLoader.readDataFromLocation(part))).filter(pair -> ((Optional)pair.getValue()).isPresent()).map(pair -> Pair.of((Object)((String)pair.getLeft()), (Object)((byte[])((Optional)pair.getRight()).get()))).toList();
    }

    private static Optional<StoreType> extractStoreType(List<String> informationSplits) {
        return informationSplits.stream().map(StoreType::findStoreTypeForString).filter(Optional::isPresent).map(Optional::get).findAny();
    }

    public static Optional<StoreType> guessStoreType(List<String> informationSplits) {
        return informationSplits.stream().flatMap(part -> Stream.of(part.split("\\."))).map(StoreType::findStoreTypeForString).filter(Optional::isPresent).map(Optional::get).findAny();
    }

    private static TigerPkiIdentity loadKeystoreFrom(TigerPkiIdentityInformation identityInformation) {
        String sourceUri = identityInformation.getFilenames().get(0);
        ByteArrayInputStream keystoreInputStream = TigerPkiIdentityLoader.readDataFromLocation(sourceUri).map(ByteArrayInputStream::new).orElseThrow(() -> new TigerPkiIdentityLoaderException("Unable to load keystore from '" + sourceUri + "'!"));
        try {
            KeyStore ks = KeyStore.getInstance(identityInformation.getOrGuessStoreType().name());
            ks.load(keystoreInputStream, identityInformation.getPassword().toCharArray());
            TigerPkiIdentity result = new TigerPkiIdentity();
            Iterator<String> it = ks.aliases().asIterator();
            while (it.hasNext()) {
                String alias = it.next();
                if (ks.isKeyEntry(alias)) {
                    result.setCertificate((X509Certificate)ks.getCertificate(alias));
                    result.setPrivateKey((PrivateKey)ks.getKey(alias, identityInformation.getPassword().toCharArray()));
                    Certificate[] certificateChain = ks.getCertificateChain(alias);
                    for (int i = 1; i < certificateChain.length; ++i) {
                        result.addCertificateToCertificateChain((X509Certificate)certificateChain[i]);
                    }
                    continue;
                }
                result.addCertificateToCertificateChain((X509Certificate)ks.getCertificate(alias));
            }
            if (result.getPrivateKey() == null) {
                throw new TigerPkiIdentityLoaderException("Error while loading keystore from '" + sourceUri + "': No matching entry found!");
            }
            return result;
        }
        catch (Exception e) {
            throw new TigerPkiIdentityLoaderException("Error while loading keystore from '" + sourceUri + "' with password '" + identityInformation.getPassword() + "'", e);
        }
    }

    private static byte[] forceReadDataFromLocation(String entityLocation) {
        return TigerPkiIdentityLoader.readDataFromLocation(entityLocation).orElseThrow(() -> new TigerPkiIdentityLoaderException("Unable to load data from location '" + entityLocation + "'!"));
    }

    private static Optional<byte[]> readDataFromLocation(String entityLocation) {
        if (StringUtils.isEmpty((CharSequence)entityLocation)) {
            throw new IllegalArgumentException("Trying to load data from empty location! (value is '" + entityLocation + "')");
        }
        String normalizedEntityLocation = FilenameUtils.separatorsToSystem((String)entityLocation);
        if (!entityLocation.startsWith(CLASSPATH_PREFIX) && new File(normalizedEntityLocation).exists()) {
            try {
                return Optional.ofNullable(FileUtils.readFileToByteArray((File)new File(normalizedEntityLocation)));
            }
            catch (IOException e) {
                return Optional.empty();
            }
        }
        if (entityLocation.startsWith(CLASSPATH_PREFIX)) {
            return TigerPkiIdentityLoader.loadResourceData(normalizedEntityLocation.replaceFirst(CLASSPATH_PREFIX, ""));
        }
        return TigerPkiIdentityLoader.loadResourceData(normalizedEntityLocation);
    }

    private static Optional<byte[]> loadResourceData(String name) {
        Optional<byte[]> optional;
        block8: {
            InputStream rawStream = TigerPkiIdentityLoader.class.getClassLoader().getResourceAsStream(name);
            try {
                optional = Optional.ofNullable(rawStream.readAllBytes());
                if (rawStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (rawStream != null) {
                        try {
                            rawStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return Optional.empty();
                }
            }
            rawStream.close();
        }
        return optional;
    }

    static {
        TigerSecurityProviderInitialiser.initialize();
    }

    public static enum StoreType {
        PKCS12(true, "P12"),
        JKS(true, new String[0]),
        BKS(true, new String[0]),
        PKCS8(false, new String[0]),
        PKCS1(false, new String[0]);

        private final List<String> names;
        private final boolean isKeystore;

        private StoreType(boolean isKeystore, String ... alternateNames) {
            ArrayList<String> namesList = new ArrayList<String>(List.of(alternateNames));
            namesList.add(this.name());
            this.names = Collections.unmodifiableList(namesList);
            this.isKeystore = isKeystore;
        }

        static Optional<StoreType> findStoreTypeForString(String value) {
            for (StoreType type : StoreType.values()) {
                for (String candidateName : type.getNames()) {
                    if (!candidateName.equalsIgnoreCase(value)) continue;
                    return Optional.of(type);
                }
            }
            return Optional.empty();
        }

        @Generated
        public List<String> getNames() {
            return this.names;
        }

        @Generated
        public boolean isKeystore() {
            return this.isKeystore;
        }
    }

    public static class TigerPkiIdentityLoaderException
    extends RuntimeException {
        public TigerPkiIdentityLoaderException(String message, Exception e) {
            super(message, e);
        }

        public TigerPkiIdentityLoaderException(String message) {
            super(message);
        }
    }
}

