/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common.pki;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.gematik.test.tiger.common.pki.TigerPkiIdentityLoader;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;

public class TigerPkiIdentityInformation {
    private List<String> filenames;
    private String password;
    private TigerPkiIdentityLoader.StoreType storeType;
    @JsonIgnore
    private boolean useCompactFormat = false;

    @JsonIgnore
    public TigerPkiIdentityLoader.StoreType getOrGuessStoreType() {
        if (this.storeType != null) {
            return this.storeType;
        }
        return TigerPkiIdentityLoader.guessStoreType(this.filenames).orElseThrow(() -> new IllegalArgumentException("Unable to guess store type for filenames '" + this.filenames + "'"));
    }

    public String generateCompactFormat() {
        if (this.filenames == null) {
            return "";
        }
        return String.join((CharSequence)";", this.filenames) + ";" + this.password + ";" + this.getOrGuessStoreType();
    }

    @Generated
    public static TigerPkiIdentityInformationBuilder builder() {
        return new TigerPkiIdentityInformationBuilder();
    }

    @Generated
    public TigerPkiIdentityInformationBuilder toBuilder() {
        return new TigerPkiIdentityInformationBuilder().filenames(this.filenames).password(this.password).storeType(this.storeType).useCompactFormat(this.useCompactFormat);
    }

    @Generated
    public List<String> getFilenames() {
        return this.filenames;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public TigerPkiIdentityLoader.StoreType getStoreType() {
        return this.storeType;
    }

    @Generated
    public boolean isUseCompactFormat() {
        return this.useCompactFormat;
    }

    @Generated
    public void setFilenames(List<String> filenames) {
        this.filenames = filenames;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setStoreType(TigerPkiIdentityLoader.StoreType storeType) {
        this.storeType = storeType;
    }

    @JsonIgnore
    @Generated
    public void setUseCompactFormat(boolean useCompactFormat) {
        this.useCompactFormat = useCompactFormat;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TigerPkiIdentityInformation)) {
            return false;
        }
        TigerPkiIdentityInformation other = (TigerPkiIdentityInformation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUseCompactFormat() != other.isUseCompactFormat()) {
            return false;
        }
        List<String> this$filenames = this.getFilenames();
        List<String> other$filenames = other.getFilenames();
        if (this$filenames == null ? other$filenames != null : !((Object)this$filenames).equals(other$filenames)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        TigerPkiIdentityLoader.StoreType this$storeType = this.getStoreType();
        TigerPkiIdentityLoader.StoreType other$storeType = other.getStoreType();
        return !(this$storeType == null ? other$storeType != null : !((Object)((Object)this$storeType)).equals((Object)other$storeType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TigerPkiIdentityInformation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUseCompactFormat() ? 79 : 97);
        List<String> $filenames = this.getFilenames();
        result = result * 59 + ($filenames == null ? 43 : ((Object)$filenames).hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        TigerPkiIdentityLoader.StoreType $storeType = this.getStoreType();
        result = result * 59 + ($storeType == null ? 43 : ((Object)((Object)$storeType)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TigerPkiIdentityInformation(filenames=" + this.getFilenames() + ", password=" + this.getPassword() + ", storeType=" + this.getStoreType() + ", useCompactFormat=" + this.isUseCompactFormat() + ")";
    }

    @Generated
    public TigerPkiIdentityInformation() {
    }

    @ConstructorProperties(value={"filenames", "password", "storeType", "useCompactFormat"})
    @Generated
    public TigerPkiIdentityInformation(List<String> filenames, String password, TigerPkiIdentityLoader.StoreType storeType, boolean useCompactFormat) {
        this.filenames = filenames;
        this.password = password;
        this.storeType = storeType;
        this.useCompactFormat = useCompactFormat;
    }

    @Generated
    public static class TigerPkiIdentityInformationBuilder {
        @Generated
        private List<String> filenames;
        @Generated
        private String password;
        @Generated
        private TigerPkiIdentityLoader.StoreType storeType;
        @Generated
        private boolean useCompactFormat;

        @Generated
        TigerPkiIdentityInformationBuilder() {
        }

        @Generated
        public TigerPkiIdentityInformationBuilder filenames(List<String> filenames) {
            this.filenames = filenames;
            return this;
        }

        @Generated
        public TigerPkiIdentityInformationBuilder password(String password) {
            this.password = password;
            return this;
        }

        @Generated
        public TigerPkiIdentityInformationBuilder storeType(TigerPkiIdentityLoader.StoreType storeType) {
            this.storeType = storeType;
            return this;
        }

        @JsonIgnore
        @Generated
        public TigerPkiIdentityInformationBuilder useCompactFormat(boolean useCompactFormat) {
            this.useCompactFormat = useCompactFormat;
            return this;
        }

        @Generated
        public TigerPkiIdentityInformation build() {
            return new TigerPkiIdentityInformation(this.filenames, this.password, this.storeType, this.useCompactFormat);
        }

        @Generated
        public String toString() {
            return "TigerPkiIdentityInformation.TigerPkiIdentityInformationBuilder(filenames=" + this.filenames + ", password=" + this.password + ", storeType=" + this.storeType + ", useCompactFormat=" + this.useCompactFormat + ")";
        }
    }
}

