/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common.jexl;

import de.gematik.test.tiger.common.config.TigerConfigurationKey;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.jexl3.JexlContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerJexlContext
extends TreeMap<String, Object>
implements JexlContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerJexlContext.class);
    public static final String CURRENT_ELEMENT_MARKER = "currentElement";
    public static final String ROOT_ELEMENT_MARKER = "rootElement";
    public static final String REMAINING_PATH_FROM_REQUEST = "remainingPathToMatch";
    private static final String RBELPATH_FALLBACK_MARKER = "rbelPathFallback";
    public static final String KEY_ELEMENT_MARKER = "key";
    private static final Set<String> DEFAULT_KEYS = Set.of("currentElement".toLowerCase(), "rootElement".toLowerCase(), "remainingPathToMatch".toLowerCase(), "key".toLowerCase());

    public TigerJexlContext(Map<String, Object> initialMap) {
        this();
        this.putAll(initialMap);
    }

    public TigerJexlContext() {
        super(Comparator.nullsFirst(Comparator.naturalOrder()));
    }

    public TigerJexlContext withCurrentElement(Object o) {
        TigerJexlContext context = new TigerJexlContext(this);
        context.put(CURRENT_ELEMENT_MARKER, o);
        return context;
    }

    public TigerJexlContext withRootElement(Object o) {
        TigerJexlContext context = new TigerJexlContext(this);
        context.put(ROOT_ELEMENT_MARKER, o);
        return context;
    }

    public TigerJexlContext withKey(String key) {
        TigerJexlContext context = new TigerJexlContext(this);
        context.put(KEY_ELEMENT_MARKER, (Object)key);
        return context;
    }

    public TigerJexlContext withShouldIgnoreEmptyRbelPaths(boolean value) {
        TigerJexlContext context = new TigerJexlContext(this);
        context.put(RBELPATH_FALLBACK_MARKER, (Object)value);
        return context;
    }

    public TigerJexlContext with(String key, String value) {
        TigerJexlContext context = new TigerJexlContext(this);
        context.put(key, (Object)value);
        return context;
    }

    public void set(String name, Object value) {
        this.put(name, value);
    }

    @Override
    public Object put(String name, Object value) {
        return super.put(TigerJexlContext.canonicalize(name), value);
    }

    private static String canonicalize(String name) {
        if (name == null) {
            return null;
        }
        return new TigerConfigurationKey(name).downsampleKey();
    }

    public boolean has(String name) {
        return super.containsKey(TigerJexlContext.canonicalize(name));
    }

    public Object get(String name) {
        return super.get(TigerJexlContext.canonicalize(name));
    }

    public Optional<Object> getOptional(String name) {
        return Optional.ofNullable(this.get(name));
    }

    public Object getCurrentElement() {
        return this.getOptional(CURRENT_ELEMENT_MARKER).orElseGet(() -> this.get(ROOT_ELEMENT_MARKER));
    }

    public Object getRootElement() {
        return this.getOptional(ROOT_ELEMENT_MARKER).orElseGet(() -> this.get(CURRENT_ELEMENT_MARKER));
    }

    public boolean shouldIgnoreEmptyRbelPaths() {
        return this.getOptional(RBELPATH_FALLBACK_MARKER).filter(Boolean.class::isInstance).map(Boolean.class::cast).orElse(Boolean.FALSE);
    }

    public String getKey() {
        Object result;
        if (super.containsKey(KEY_ELEMENT_MARKER) && (result = super.get(KEY_ELEMENT_MARKER)) != null) {
            return result.toString();
        }
        return null;
    }

    public TigerJexlContext cloneContext() {
        return new TigerJexlContext(this);
    }

    public Map<String, Object> allNonStandardValues() {
        return this.entrySet().stream().filter(e -> !DEFAULT_KEYS.contains(((String)e.getKey()).toLowerCase())).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

