/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common.config;

import de.gematik.test.tiger.common.config.AbstractTigerConfigurationSource;
import de.gematik.test.tiger.common.config.SourceType;
import de.gematik.test.tiger.common.config.TigerConfigurationKey;
import de.gematik.test.tiger.common.config.TigerTemplateSource;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class BasicTigerConfigurationSource
extends AbstractTigerConfigurationSource {
    private final Map<TigerConfigurationKey, String> values;

    public BasicTigerConfigurationSource(SourceType sourceType, Map<TigerConfigurationKey, String> values) {
        super(sourceType);
        this.values = new HashMap<TigerConfigurationKey, String>(values);
    }

    public BasicTigerConfigurationSource(SourceType sourceType) {
        super(sourceType);
        this.values = new HashMap<TigerConfigurationKey, String>();
    }

    @Override
    public AbstractTigerConfigurationSource copy() {
        return BasicTigerConfigurationSource.builder().sourceType(this.sourceType).values(new HashMap<TigerConfigurationKey, String>(this.values)).build();
    }

    @Override
    public synchronized Map<TigerConfigurationKey, String> applyTemplatesAndAddValuesToMap(List<TigerTemplateSource> loadedTemplates, Map<TigerConfigurationKey, String> loadedAndSortedProperties) {
        HashMap<TigerConfigurationKey, String> finalValues = new HashMap<TigerConfigurationKey, String>();
        finalValues.putAll(loadedAndSortedProperties);
        finalValues.putAll(this.values);
        List appliedTemplates = loadedTemplates.stream().map(template -> template.applyToApplicablesAndReturnAppliedTemplateKeys(this, finalValues)).flatMap(Collection::stream).toList();
        appliedTemplates.forEach(finalValues::remove);
        return finalValues;
    }

    @Override
    public synchronized Map<TigerConfigurationKey, String> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    @Override
    public synchronized void putValue(TigerConfigurationKey key, String value) {
        this.values.put(key, value);
    }

    @Override
    public synchronized void removeValue(TigerConfigurationKey key) {
        this.values.remove(key);
    }

    @Override
    public synchronized boolean containsKey(TigerConfigurationKey key) {
        return this.values.containsKey(key);
    }

    @Override
    public synchronized String getValue(TigerConfigurationKey key) {
        return this.values.get(key);
    }

    @Override
    public void putAll(AbstractTigerConfigurationSource other) {
        if (!(other instanceof BasicTigerConfigurationSource)) {
            throw new IllegalArgumentException("Cannot merge different source types");
        }
        BasicTigerConfigurationSource otherBasicSource = (BasicTigerConfigurationSource)other;
        this.values.putAll(otherBasicSource.values);
    }

    @Generated
    public static BasicTigerConfigurationSourceBuilder builder() {
        return new BasicTigerConfigurationSourceBuilder();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BasicTigerConfigurationSource)) {
            return false;
        }
        BasicTigerConfigurationSource other = (BasicTigerConfigurationSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<TigerConfigurationKey, String> this$values = this.getValues();
        Map<TigerConfigurationKey, String> other$values = other.getValues();
        return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BasicTigerConfigurationSource;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<TigerConfigurationKey, String> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        return result;
    }

    @Generated
    public static class BasicTigerConfigurationSourceBuilder {
        @Generated
        private SourceType sourceType;
        @Generated
        private Map<TigerConfigurationKey, String> values;

        @Generated
        BasicTigerConfigurationSourceBuilder() {
        }

        @Generated
        public BasicTigerConfigurationSourceBuilder sourceType(SourceType sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Generated
        public BasicTigerConfigurationSourceBuilder values(Map<TigerConfigurationKey, String> values) {
            this.values = values;
            return this;
        }

        @Generated
        public BasicTigerConfigurationSource build() {
            return new BasicTigerConfigurationSource(this.sourceType, this.values);
        }

        @Generated
        public String toString() {
            return "BasicTigerConfigurationSource.BasicTigerConfigurationSourceBuilder(sourceType=" + this.sourceType + ", values=" + this.values + ")";
        }
    }
}

