/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common.config;

import de.gematik.test.tiger.common.config.AbstractTigerConfigurationSource;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.stream.Stream;

public class TigerConfigurationSourcesManager {
    private ConcurrentSkipListSet<AbstractTigerConfigurationSource> loadedSources = new ConcurrentSkipListSet();

    public void reset() {
        this.loadedSources.clear();
    }

    public Stream<AbstractTigerConfigurationSource> getSortedStream() {
        return this.loadedSources.stream();
    }

    public List<AbstractTigerConfigurationSource> getSortedListReversed() {
        return this.loadedSources.stream().sorted(Comparator.reverseOrder()).toList();
    }

    public void addNewSource(AbstractTigerConfigurationSource source) {
        boolean success = this.loadedSources.add(source);
        if (!success) {
            AbstractTigerConfigurationSource exisitingSource = this.loadedSources.stream().filter(src -> src.getSourceType() == source.getSourceType()).findFirst().orElseThrow();
            exisitingSource.putAll(source);
        }
    }

    public boolean removeSource(AbstractTigerConfigurationSource source) {
        return this.loadedSources.remove(source);
    }
}

