/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common.toolschecker;

import de.gematik.test.tiger.common.config.TigerConfigurationKeys;
import de.gematik.test.tiger.common.toolschecker.DependencyCheckResult;
import lombok.Generated;

public class DependencyToolsChecker {
    public DependencyCheckResult areNecessaryDependenciesAvailable() {
        if (Boolean.FALSE.equals(TigerConfigurationKeys.TRAFFIC_VISUALIZATION_ACTIVE.getValueOrDefault())) {
            return new DependencyCheckResult(true, "");
        }
        if (this.isItWindows()) {
            return new DependencyCheckResult(true, "");
        }
        if (this.hasLsof()) {
            return new DependencyCheckResult(true, "");
        }
        return new DependencyCheckResult(false, "missing required 'lsof' command in your operating system");
    }

    protected boolean hasLsof() {
        Process process = Runtime.getRuntime().exec("which lsof");
        int exitCode = process.waitFor();
        return exitCode == 0;
    }

    private boolean isItWindows() {
        return System.getProperty("os.name").toLowerCase().contains("win");
    }

    @Generated
    public DependencyToolsChecker() {
    }
}

