/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common.jexl;

import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;

public class InlineJexlToolbox {
    public static String file(String filename) {
        return Files.readString(Path.of(filename, new String[0]));
    }

    public String resolve(String value) {
        return TigerGlobalConfiguration.resolvePlaceholders(value);
    }

    public String getValue(String variableName) {
        return TigerGlobalConfiguration.readString(variableName, null);
    }

    public String sha256(String value) {
        return value != null ? Hex.encodeHexString((byte[])DigestUtils.sha256((String)value)) : null;
    }

    public String sha512(String value) {
        return value != null ? Hex.encodeHexString((byte[])DigestUtils.sha512((String)value)) : null;
    }

    public String sha512Base64(String value) {
        return value != null ? Base64.encodeBase64String((byte[])DigestUtils.sha512((String)value)) : null;
    }

    public String md5(String value) {
        return value != null ? Hex.encodeHexString((byte[])DigestUtils.md5((String)value)) : null;
    }

    public String md5Base64(String value) {
        return value != null ? Base64.encodeBase64String((byte[])DigestUtils.md5((String)value)) : null;
    }

    public String base64Encode(String value) {
        return value != null ? Base64.encodeBase64String((byte[])value.getBytes(StandardCharsets.UTF_8)) : null;
    }

    public String base64UrlEncode(String value) {
        return value != null ? Base64.encodeBase64URLSafeString((byte[])value.getBytes(StandardCharsets.UTF_8)) : null;
    }

    public String base64Decode(String value) {
        return value != null ? new String(Base64.decodeBase64((String)value)) : null;
    }

    public String randomHex(int size) {
        return RandomStringUtils.random((int)size, (String)"abcdef9876543210");
    }

    public String urlEncoded(String value) {
        return value != null ? URLEncoder.encode(value, StandardCharsets.UTF_8) : null;
    }

    public String subStringAfter(String value, String token) {
        return value != null && token != null ? StringUtils.substringAfter((String)value, (String)token) : null;
    }

    public String subStringBefore(String value, String token) {
        return value != null && token != null ? StringUtils.substringBefore((String)value, (String)token) : null;
    }

    public String sha256Base64(String value) {
        return value != null ? Base64.encodeBase64String((byte[])DigestUtils.sha256((String)value)) : null;
    }

    public long currentTimestamp() {
        return Instant.now().getEpochSecond();
    }

    public String currentLocalDate() {
        return LocalDate.now().toString();
    }

    public String currentLocalDateTime() {
        return LocalDateTime.now().toString();
    }

    public String currentZonedDateTime() {
        return ZonedDateTime.now().toString();
    }

    public String lowerCase(String value) {
        return value != null ? value.toLowerCase() : null;
    }

    public String upperCase(String value) {
        return value != null ? value.toUpperCase() : null;
    }
}

