/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common.config;

import de.gematik.test.tiger.common.config.AbstractTigerConfigurationSource;
import de.gematik.test.tiger.common.config.SourceType;
import de.gematik.test.tiger.common.config.TigerConfigurationKey;
import de.gematik.test.tiger.common.config.TigerTemplateSource;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.LongConsumer;
import lombok.Generated;

public class TigerThreadScopedConfigurationSource
extends AbstractTigerConfigurationSource {
    private final Map<Long, Map<TigerConfigurationKey, String>> threadIdToValuesMap = new ConcurrentHashMap<Long, Map<TigerConfigurationKey, String>>();

    public TigerThreadScopedConfigurationSource() {
        super(SourceType.THREAD_CONTEXT);
    }

    @Override
    public Map<TigerConfigurationKey, String> applyTemplatesAndAddValuesToMap(List<TigerTemplateSource> loadedTemplates, Map<TigerConfigurationKey, String> loadedAndSortedProperties) {
        HashMap<TigerConfigurationKey, String> finalValues = new HashMap<TigerConfigurationKey, String>();
        finalValues.putAll(loadedAndSortedProperties);
        finalValues.putAll(this.getValues());
        loadedTemplates.stream().map(template -> template.applyToApplicablesAndReturnAppliedTemplateKeys(this, finalValues)).flatMap(Collection::stream).forEach(finalValues::remove);
        return finalValues;
    }

    @Override
    public Map<TigerConfigurationKey, String> getValues() {
        long threadId = Thread.currentThread().getId();
        if (this.threadIdToValuesMap.containsKey(threadId)) {
            return this.threadIdToValuesMap.get(threadId);
        }
        return Map.of();
    }

    @Override
    public void putValue(TigerConfigurationKey key, String value) {
        this.executeWithCurrentThreadMap(threadId -> this.threadIdToValuesMap.get(threadId).put(key, value));
    }

    @Override
    public void removeValue(TigerConfigurationKey key) {
        this.executeWithCurrentThreadMap(threadId -> this.threadIdToValuesMap.get(threadId).remove(key));
    }

    @Override
    public boolean containsKey(TigerConfigurationKey key) {
        return this.retrieveFromCurrentThreadMap(m -> m.containsKey(key));
    }

    @Override
    public String getValue(TigerConfigurationKey key) {
        return this.retrieveFromCurrentThreadMap(m -> (String)m.get(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T retrieveFromCurrentThreadMap(Function<Map<TigerConfigurationKey, String>, T> retriever) {
        long threadId = Thread.currentThread().getId();
        Map<Long, Map<TigerConfigurationKey, String>> map = this.threadIdToValuesMap;
        synchronized (map) {
            this.threadIdToValuesMap.computeIfAbsent(threadId, thid -> new ConcurrentHashMap());
            return retriever.apply(this.threadIdToValuesMap.get(threadId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeWithCurrentThreadMap(LongConsumer threadIdConsumer) {
        long threadId = Thread.currentThread().getId();
        Map<Long, Map<TigerConfigurationKey, String>> map = this.threadIdToValuesMap;
        synchronized (map) {
            this.threadIdToValuesMap.computeIfAbsent(threadId, thid -> new ConcurrentHashMap());
            threadIdConsumer.accept(threadId);
        }
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TigerThreadScopedConfigurationSource)) {
            return false;
        }
        TigerThreadScopedConfigurationSource other = (TigerThreadScopedConfigurationSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<Long, Map<TigerConfigurationKey, String>> this$threadIdToValuesMap = this.threadIdToValuesMap;
        Map<Long, Map<TigerConfigurationKey, String>> other$threadIdToValuesMap = other.threadIdToValuesMap;
        return !(this$threadIdToValuesMap == null ? other$threadIdToValuesMap != null : !((Object)this$threadIdToValuesMap).equals(other$threadIdToValuesMap));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TigerThreadScopedConfigurationSource;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<Long, Map<TigerConfigurationKey, String>> $threadIdToValuesMap = this.threadIdToValuesMap;
        result = result * 59 + ($threadIdToValuesMap == null ? 43 : ((Object)$threadIdToValuesMap).hashCode());
        return result;
    }
}

