/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common.config;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.cfg.ContextAttributes;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import de.gematik.test.tiger.common.TokenSubstituteHelper;
import de.gematik.test.tiger.common.config.AbstractTigerConfigurationSource;
import de.gematik.test.tiger.common.config.BasicTigerConfigurationSource;
import de.gematik.test.tiger.common.config.DeprecatedKeysForbiddenUsageChecker;
import de.gematik.test.tiger.common.config.DuplicateMapKeysForbiddenConstructor;
import de.gematik.test.tiger.common.config.SourceType;
import de.gematik.test.tiger.common.config.TigerConfigurationException;
import de.gematik.test.tiger.common.config.TigerConfigurationKey;
import de.gematik.test.tiger.common.config.TigerConfigurationKeyString;
import de.gematik.test.tiger.common.config.TigerConfigurationSourcesManager;
import de.gematik.test.tiger.common.config.TigerTemplateSource;
import de.gematik.test.tiger.common.config.TigerThreadScopedConfigurationSource;
import de.gematik.test.tiger.zion.config.TigerSkipEvaluation;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;

public class TigerConfigurationLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerConfigurationLoader.class);
    public static final String TIGER_CONFIGURATION_ATTRIBUTE_KEY = "tigerConfiguration";
    private final TigerConfigurationSourcesManager sourcesManager = new TigerConfigurationSourcesManager();
    private ObjectMapper objectMapper;
    private ObjectMapper strictObjectMapper;
    private List<TigerTemplateSource> loadedTemplates;

    public TigerConfigurationLoader() {
        this.initialize();
    }

    private static boolean parseBoolean(String rawValue) {
        return "1".equals(rawValue) || Boolean.parseBoolean(rawValue);
    }

    private static String mapConflictResolver(String e1, String e2, String propertySourceName) {
        if (e1.equals(e2)) {
            return e1;
        }
        throw new TigerConfigurationException("Found two conflicting " + propertySourceName + " with values '" + e1 + "' and '" + e2 + "'. Resolve this conflict manually!");
    }

    public static Map<TigerConfigurationKey, String> addYamlToMap(Object value, TigerConfigurationKey baseKeys, Map<TigerConfigurationKey, String> valueMap) {
        if (value instanceof Map) {
            Map asMap = (Map)value;
            asMap.forEach((key, value1) -> {
                TigerConfigurationKey newList = new TigerConfigurationKey(baseKeys);
                newList.add((String)key);
                TigerConfigurationLoader.addYamlToMap(value1, newList, valueMap);
            });
        } else if (value instanceof List) {
            List asList = (List)value;
            int counter = 0;
            for (Object entry : asList) {
                TigerConfigurationKey newList = new TigerConfigurationKey(baseKeys);
                newList.add(TigerConfigurationKeyString.wrapAsKey(Integer.toString(counter++)));
                TigerConfigurationLoader.addYamlToMap(entry, newList, valueMap);
            }
        } else if (value != null) {
            valueMap.put(baseKeys, value.toString());
        }
        return valueMap;
    }

    public void reset() {
        this.sourcesManager.reset();
        this.loadedTemplates.clear();
        this.initializeObjectMapper();
    }

    public void initialize() {
        if (this.objectMapper == null) {
            this.initializeObjectMapper();
        }
        if (this.loadedTemplates == null) {
            this.loadedTemplates = new ArrayList<TigerTemplateSource>();
        }
    }

    private void initializeObjectMapper() {
        SimpleModule skipEvaluationModule = new SimpleModule();
        skipEvaluationModule.addDeserializer(String.class, (JsonDeserializer)new SkipEvaluationDeserializer(this));
        this.objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true)).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).propertyNamingStrategy(PropertyNamingStrategies.LOWER_CASE)).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS})).addModule((Module)new JavaTimeModule())).addModule((Module)new AllowDelayedPrimitiveResolvementModule(this))).addModule((Module)skipEvaluationModule)).defaultAttributes(ContextAttributes.getEmpty().withSharedAttributes(Map.of(TIGER_CONFIGURATION_ATTRIBUTE_KEY, this)))).build();
        this.strictObjectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true)).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).propertyNamingStrategy(PropertyNamingStrategies.LOWER_CASE)).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS})).addModule((Module)new JavaTimeModule())).addModule((Module)new AllowDelayedPrimitiveResolvementModule(this))).addModule((Module)skipEvaluationModule)).defaultAttributes(ContextAttributes.getEmpty().withSharedAttributes(Map.of(TIGER_CONFIGURATION_ATTRIBUTE_KEY, this)))).build();
    }

    public String readString(String key) {
        return this.readStringOptional(key).orElseThrow(() -> new TigerConfigurationException("Could not find value for '" + key + "'"));
    }

    public String readString(String key, String defaultValue) {
        return this.readStringOptional(key).orElse(defaultValue);
    }

    public Optional<String> readStringOptional(String key) {
        TigerConfigurationKey splittedKey = new TigerConfigurationKey(TokenSubstituteHelper.substitute(key, this));
        return this.readStringOptional(splittedKey);
    }

    public Optional<String> readStringOptional(TigerConfigurationKey key) {
        return this.sourcesManager.getSortedStream().filter(source -> source.containsKey(key)).map(source -> source.getValue(key)).findFirst();
    }

    public <T> Optional<T> instantiateConfigurationBean(Class<T> configurationBeanClass, String ... baseKeys) {
        return this.instantiateConfigurationBean(configurationBeanClass, this.objectMapper, baseKeys);
    }

    public <T> Optional<T> instantiateConfigurationBeanStrict(Class<T> configurationBeanClass, String ... baseKeys) {
        return this.instantiateConfigurationBean(configurationBeanClass, this.strictObjectMapper, baseKeys);
    }

    private <T> Optional<T> instantiateConfigurationBean(Class<T> configurationBeanClass, ObjectMapper objectMapper, String ... baseKeys) {
        this.initialize();
        JsonNode targetTree = this.convertToTreeUnresolved();
        TigerConfigurationKey configurationKey = new TigerConfigurationKey(baseKeys);
        for (TigerConfigurationKeyString key : configurationKey) {
            if (targetTree.get(key.getValue()) == null) {
                return Optional.empty();
            }
            targetTree = targetTree.get(key.getValue());
        }
        try {
            return Optional.of(objectMapper.treeToValue((TreeNode)targetTree, configurationBeanClass));
        }
        catch (JacksonException e) {
            log.debug("Error while converting the following tree: {}", (Object)objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)targetTree));
            Throwable ex = e;
            while (ex.getCause() != null) {
                ex = ex.getCause();
            }
            throw new TigerConfigurationException("Error while reading configuration for class " + configurationBeanClass.getName() + " with base-keys " + Arrays.toString(baseKeys) + " and root cause '" + ex.getMessage() + "'", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T instantiateConfigurationBean(TypeReference<T> configurationBeanType, String ... baseKeys) {
        this.initialize();
        JsonNode targetTree = this.convertToTreeUnresolved();
        TigerConfigurationKey configurationKey = new TigerConfigurationKey(baseKeys);
        for (TigerConfigurationKeyString key : configurationKey) {
            if (targetTree.get(key.getValue()) == null) {
                return (T)this.objectMapper.readValue("[]", configurationBeanType);
            }
            targetTree = targetTree.get(key.getValue());
        }
        try (JsonParser jsonParser = this.objectMapper.treeAsTokens((TreeNode)targetTree);){
            Object object = jsonParser.readValueAs(configurationBeanType);
            return (T)object;
        }
        catch (JacksonException e) {
            log.debug("Error while converting the following tree: {}", (Object)this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)targetTree));
            throw new TigerConfigurationException("Error while reading configuration for class " + configurationBeanType.getType().getTypeName() + " with base-keys " + Arrays.toString(baseKeys), e);
        }
    }

    public void readFromYaml(String yamlSource, String ... baseKeys) {
        this.readFromYaml(yamlSource, SourceType.ADDITIONAL_YAML, baseKeys);
    }

    public void readFromYaml(String yamlSource, SourceType sourceType, String ... baseKeys) {
        this.initialize();
        Yaml yaml = new Yaml((BaseConstructor)new DuplicateMapKeysForbiddenConstructor());
        HashMap<TigerConfigurationKey, String> valueMap = new HashMap<TigerConfigurationKey, String>();
        TigerConfigurationLoader.addYamlToMap(yaml.load(yamlSource), new TigerConfigurationKey(baseKeys), valueMap);
        DeprecatedKeysForbiddenUsageChecker.checkForDeprecatedKeys(valueMap);
        this.sourcesManager.addNewSource(BasicTigerConfigurationSource.builder().values(valueMap).sourceType(sourceType).basePath(new TigerConfigurationKey(baseKeys)).build());
    }

    public boolean readBoolean(String key) {
        return TigerConfigurationLoader.parseBoolean(this.readString(key));
    }

    public boolean readBoolean(String key, boolean defValue) {
        return this.readStringOptional(key).map(TigerConfigurationLoader::parseBoolean).orElse(defValue);
    }

    public Optional<Boolean> readBooleanOptional(String key) {
        return this.readStringOptional(key).map(TigerConfigurationLoader::parseBoolean);
    }

    public void readTemplates(String templatesYaml, String ... baseKeys) {
        Object v;
        Map asMap;
        Yaml yaml = new Yaml((BaseConstructor)new DuplicateMapKeysForbiddenConstructor());
        Object loadedYaml = yaml.load(templatesYaml);
        if (!(loadedYaml instanceof Map && (asMap = (Map)loadedYaml).containsKey("templates") && (v = asMap.get("templates")) instanceof List)) {
            throw new TigerConfigurationException("Error while loading templates: Expected templates-nodes with list of templates");
        }
        List aslist = (List)v;
        aslist.stream().filter(Map.class::isInstance).map(Map.class::cast).filter(m -> m.containsKey("templateName")).forEach(m -> this.loadedTemplates.add(TigerTemplateSource.builder().templateName(m.get("templateName").toString()).targetPath(new TigerConfigurationKey(baseKeys)).values(TigerConfigurationLoader.addYamlToMap(m, new TigerConfigurationKey(), new HashMap<TigerConfigurationKey, String>())).build()));
    }

    public void loadEnvironmentVariables() {
        this.sourcesManager.getSortedStream().filter(source -> source.getSourceType() == SourceType.ENV).forEach(this.sourcesManager::removeSource);
        this.sourcesManager.addNewSource(BasicTigerConfigurationSource.builder().basePath(new TigerConfigurationKey()).values(System.getenv().entrySet().stream().collect(Collectors.toMap(entry -> new TigerConfigurationKey((String)entry.getKey()), Map.Entry::getValue, (e1, e2) -> TigerConfigurationLoader.mapConflictResolver(e1, e2, "environment variables")))).sourceType(SourceType.ENV).build());
    }

    public void loadSystemProperties() {
        this.sourcesManager.getSortedStream().filter(source -> source.getSourceType() == SourceType.PROPERTIES).forEach(this.sourcesManager::removeSource);
        this.sourcesManager.addNewSource(BasicTigerConfigurationSource.builder().basePath(new TigerConfigurationKey()).values(System.getProperties().entrySet().stream().collect(Collectors.toMap(entry -> new TigerConfigurationKey(entry.getKey().toString()), entry -> entry.getValue().toString(), (e1, e2) -> TigerConfigurationLoader.mapConflictResolver(e1, e2, "system properties")))).sourceType(SourceType.PROPERTIES).build());
    }

    public Map<TigerConfigurationKey, String> retrieveMap(TigerConfigurationKey reference) {
        Map<TigerConfigurationKey, String> map = this.retrieveMapUnresolved();
        this.replacePlaceholders(map, reference);
        return map;
    }

    public Map<TigerConfigurationKey, String> retrieveMapUnresolved() {
        Map<TigerConfigurationKey, String> loadedAndSortedProperties = new HashMap<TigerConfigurationKey, String>();
        for (AbstractTigerConfigurationSource configurationSource : this.sourcesManager.getSortedListReversed()) {
            loadedAndSortedProperties = configurationSource.applyTemplatesAndAddValuesToMap(this.loadedTemplates, loadedAndSortedProperties);
        }
        return loadedAndSortedProperties;
    }

    private JsonNode convertToTreeUnresolved() {
        return this.convertMapToTree(this.retrieveMapUnresolved());
    }

    private JsonNode convertMapToTree(Map<TigerConfigurationKey, String> map) {
        ObjectNode result = new ObjectNode(this.objectMapper.getNodeFactory());
        for (Map.Entry<TigerConfigurationKey, String> entry : map.entrySet()) {
            this.createAndReturnDeepPath(entry.getKey(), result).put(((TigerConfigurationKeyString)entry.getKey().get(entry.getKey().size() - 1)).getValue(), entry.getValue());
        }
        return this.mapObjectsToArrayWhereApplicable((JsonNode)result, this.objectMapper.getNodeFactory());
    }

    private void replacePlaceholders(Map<TigerConfigurationKey, String> loadedAndSortedProperties, TigerConfigurationKey reference) {
        Map<TigerConfigurationKey, String> updatedValues = loadedAndSortedProperties.entrySet().stream().filter(entry -> ((String)entry.getValue()).contains("${") && ((String)entry.getValue()).contains("}")).filter(entry -> ((TigerConfigurationKey)entry.getKey()).isBelow(reference)).map(entry -> Pair.of((Object)((TigerConfigurationKey)entry.getKey()), (Object)TokenSubstituteHelper.substitute((String)entry.getValue(), this))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        loadedAndSortedProperties.putAll(updatedValues);
    }

    private JsonNode mapObjectsToArrayWhereApplicable(JsonNode value, JsonNodeFactory nodeFactory) {
        if (value instanceof ObjectNode) {
            ObjectNode asObjectNode = (ObjectNode)value;
            if (this.isArray(asObjectNode)) {
                return new ArrayNode(nodeFactory, StreamSupport.stream(Spliterators.spliteratorUnknownSize(value.fields(), 16), false).sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).map(node -> this.mapObjectsToArrayWhereApplicable((JsonNode)node, nodeFactory)).toList());
            }
            return new ObjectNode(nodeFactory, StreamSupport.stream(Spliterators.spliteratorUnknownSize(asObjectNode.fields(), 16), false).map(entry -> Pair.of((Object)((String)entry.getKey()), (Object)this.mapObjectsToArrayWhereApplicable((JsonNode)entry.getValue(), nodeFactory))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }
        return value;
    }

    private boolean isArray(ObjectNode value) {
        Spliterator stringSpliterator = Spliterators.spliteratorUnknownSize(value.fieldNames(), 16);
        if (StreamSupport.stream(stringSpliterator, false).anyMatch(s -> !NumberUtils.isParsable((String)s))) {
            return false;
        }
        List<Integer> keys = StreamSupport.stream(stringSpliterator, false).mapToInt(Integer::parseInt).sorted().boxed().toList();
        int i = 0;
        for (Integer key : keys) {
            if (key == i++) continue;
            return false;
        }
        return true;
    }

    private ObjectNode createAndReturnDeepPath(List<TigerConfigurationKeyString> keys, ObjectNode position) {
        if (keys.size() > 1) {
            for (TigerConfigurationKeyString key : keys.subList(0, keys.size() - 1)) {
                String homogenizedKey = this.homogenizeKeysInMapAndReturnCorrectedKey(position, key);
                if (!position.has(homogenizedKey)) {
                    position.putObject(homogenizedKey);
                }
                if (!(position.get(homogenizedKey) instanceof ObjectNode)) continue;
                position = (ObjectNode)position.get(homogenizedKey);
            }
        }
        return position;
    }

    private String homogenizeKeysInMapAndReturnCorrectedKey(ObjectNode position, TigerConfigurationKeyString key) {
        Iterator it = position.fieldNames();
        while (it.hasNext()) {
            String toBeReplacedKey = (String)it.next();
            if (key.getValue().equals(toBeReplacedKey) || !key.getValue().equalsIgnoreCase(toBeReplacedKey)) continue;
            if (!toBeReplacedKey.equals(toBeReplacedKey.toLowerCase())) {
                return toBeReplacedKey;
            }
            JsonNode leaf = position.remove(toBeReplacedKey);
            position.set(key.getValue(), leaf);
            return key.getValue();
        }
        return key.getValue();
    }

    public Map<String, String> readMap(String ... baseKeys) {
        TigerConfigurationKey reference = new TigerConfigurationKey(baseKeys);
        return this.retrieveMap(reference).entrySet().stream().filter(entry -> ((TigerConfigurationKey)entry.getKey()).isBelow(reference)).collect(Collectors.toMap(entry -> ((TigerConfigurationKey)entry.getKey()).subtractFromBeginning(reference).downsampleKey(), Map.Entry::getValue));
    }

    public List<String> readList(String ... baseKeys) {
        TigerConfigurationKey reference = new TigerConfigurationKey(baseKeys);
        return this.retrieveMap(reference).entrySet().stream().filter(entry -> ((TigerConfigurationKey)entry.getKey()).isBelow(reference)).map(Map.Entry::getValue).toList();
    }

    public Map<String, String> readMapWithCaseSensitiveKeys(String ... baseKeys) {
        return this.readMapWithCaseSensitiveKeys(new TigerConfigurationKey(baseKeys));
    }

    public Map<String, String> readMapWithCaseSensitiveKeys(TigerConfigurationKey reference) {
        return this.retrieveMap(reference).entrySet().stream().filter(entry -> ((TigerConfigurationKey)entry.getKey()).isBelow(reference)).collect(Collectors.toMap(entry -> ((TigerConfigurationKey)entry.getKey()).subtractFromBeginning(reference).downsampleKeyCaseSensitive(), Map.Entry::getValue));
    }

    public List<AbstractTigerConfigurationSource> listSources() {
        return this.sourcesManager.getSortedListReversed();
    }

    public void putValue(String key, String value) {
        if (value == null) {
            throw new TigerConfigurationException("Trying to store null-value. Only non-values are allowed!");
        }
        this.putValue(key, value, SourceType.RUNTIME_EXPORT);
    }

    public void putValue(String key, Object value) {
        if (value == null) {
            throw new TigerConfigurationException("Trying to store null-value. Only non-values are allowed!");
        }
        if (value instanceof String) {
            String asString = (String)value;
            this.putValue(key, asString);
        } else {
            try {
                Yaml yaml = new Yaml((BaseConstructor)new DuplicateMapKeysForbiddenConstructor());
                HashMap<TigerConfigurationKey, String> valueMap = new HashMap<TigerConfigurationKey, String>();
                TigerConfigurationLoader.addYamlToMap(yaml.load(this.objectMapper.writeValueAsString(value)), new TigerConfigurationKey(key), valueMap);
                this.sourcesManager.addNewSource(BasicTigerConfigurationSource.builder().values(valueMap).sourceType(SourceType.RUNTIME_EXPORT).basePath(new TigerConfigurationKey(key)).build());
            }
            catch (JsonProcessingException e) {
                throw new TigerConfigurationException("Error during serialization", e);
            }
        }
    }

    public void putValue(String key, String value, SourceType sourceType) {
        Optional<AbstractTigerConfigurationSource> configurationSource = this.sourcesManager.getSortedStream().filter(source -> source.getSourceType() == sourceType).findAny();
        if (configurationSource.isEmpty()) {
            AbstractTigerConfigurationSource newSource = sourceType == SourceType.THREAD_CONTEXT ? new TigerThreadScopedConfigurationSource() : new BasicTigerConfigurationSource(sourceType);
            this.sourcesManager.addNewSource(newSource);
            newSource.putValue(new TigerConfigurationKey(key), value);
        } else {
            configurationSource.get().putValue(new TigerConfigurationKey(key), value);
        }
    }

    public void addConfigurationSource(AbstractTigerConfigurationSource configurationSource) {
        this.sourcesManager.addNewSource(configurationSource);
    }

    public boolean removeConfigurationSource(AbstractTigerConfigurationSource configurationSource) {
        return this.sourcesManager.removeSource(configurationSource);
    }

    @Generated
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public static class SkipEvaluationDeserializer
    extends JsonDeserializer<String>
    implements ContextualDeserializer {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(SkipEvaluationDeserializer.class);
        private final TigerConfigurationLoader configurationLoader;
        private boolean skipEvaluation;

        public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
            this.skipEvaluation = property != null && property.getAnnotation(TigerSkipEvaluation.class) != null;
            return new SkipEvaluationDeserializer(this.configurationLoader, this.skipEvaluation);
        }

        public String deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            String valueAsString = jsonParser.getValueAsString();
            if (this.skipEvaluation) {
                return valueAsString;
            }
            return TokenSubstituteHelper.substitute(valueAsString, this.configurationLoader);
        }

        @ConstructorProperties(value={"configurationLoader"})
        @Generated
        public SkipEvaluationDeserializer(TigerConfigurationLoader configurationLoader) {
            this.configurationLoader = configurationLoader;
        }

        @ConstructorProperties(value={"configurationLoader", "skipEvaluation"})
        @Generated
        public SkipEvaluationDeserializer(TigerConfigurationLoader configurationLoader, boolean skipEvaluation) {
            this.configurationLoader = configurationLoader;
            this.skipEvaluation = skipEvaluation;
        }
    }

    private static class AllowDelayedPrimitiveResolvementModule
    extends Module {
        private TigerConfigurationLoader tigerConfigurationLoader;

        public String getModuleName() {
            return "fallback provider";
        }

        public Version version() {
            return Version.unknownVersion();
        }

        public void setupModule(Module.SetupContext setupContext) {
            setupContext.addDeserializationProblemHandler((DeserializationProblemHandler)new ClazzFallbackConverter(this.tigerConfigurationLoader));
        }

        @ConstructorProperties(value={"tigerConfigurationLoader"})
        @Generated
        public AllowDelayedPrimitiveResolvementModule(TigerConfigurationLoader tigerConfigurationLoader) {
            this.tigerConfigurationLoader = tigerConfigurationLoader;
        }
    }

    private static class ClazzFallbackConverter
    extends DeserializationProblemHandler {
        TigerConfigurationLoader tigerConfigurationLoader;

        public Object handleWeirdStringValue(DeserializationContext ctxt, Class<?> targetType, String valueToConvert, String failureMsg) throws IOException {
            if (valueToConvert.contains("!{") || valueToConvert.contains("${")) {
                String substitute = TokenSubstituteHelper.substitute(valueToConvert, this.tigerConfigurationLoader);
                if (!substitute.equals(valueToConvert)) {
                    TextNode replacedTextNode = ctxt.getNodeFactory().textNode(substitute);
                    return ctxt.readTreeAsValue((JsonNode)replacedTextNode, targetType);
                }
                return this.returnTigerSpecificFallbackValue(ctxt, targetType, valueToConvert, failureMsg);
            }
            return super.handleWeirdStringValue(ctxt, targetType, valueToConvert, failureMsg);
        }

        Object returnTigerSpecificFallbackValue(DeserializationContext ctxt, Class<?> targetType, String valueToConvert, String failureMsg) throws IOException {
            if (targetType.equals(Boolean.class) || targetType.equals(Integer.class) || targetType.equals(Long.class) || targetType.equals(Character.class) || targetType.equals(Double.class) || targetType.equals(Float.class) || targetType.equals(Byte.class) || targetType.equals(Short.class)) {
                return null;
            }
            if (targetType.equals(Boolean.TYPE)) {
                return false;
            }
            if (targetType.equals(Integer.TYPE)) {
                return -1;
            }
            if (targetType.equals(Long.TYPE)) {
                return -1L;
            }
            if (targetType.equals(Double.TYPE)) {
                return -1.0;
            }
            if (targetType.equals(Float.TYPE)) {
                return Float.valueOf(-1.0f);
            }
            if (targetType.equals(Short.TYPE)) {
                return (short)-1;
            }
            if (targetType.equals(Character.TYPE)) {
                return Character.valueOf(' ');
            }
            if (targetType.equals(Byte.TYPE)) {
                return (byte)-1;
            }
            return super.handleWeirdStringValue(ctxt, targetType, valueToConvert, failureMsg);
        }

        @ConstructorProperties(value={"tigerConfigurationLoader"})
        @Generated
        public ClazzFallbackConverter(TigerConfigurationLoader tigerConfigurationLoader) {
            this.tigerConfigurationLoader = tigerConfigurationLoader;
        }
    }
}

