/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.util;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public enum RbelAnsiColors {
    RESET("\u001b[0m", "reset"),
    BLACK("\u001b[0;30m", "schwarz", "schwarzen", "black"),
    RED("\u001b[0;31m", "rot", "roten", "red"),
    GREEN("\u001b[0;32m", "gr\u00fcn", "gr\u00fcnen", "green"),
    YELLOW("\u001b[0;33m", "gelb", "gelben", "yellow"),
    BLUE("\u001b[0;34m", "blau", "blauen", "blue"),
    PURPLE("\u001b[0;35m", "magenta", "magentanen", "purple"),
    CYAN("\u001b[0;36m", "t\u00fcrkis", "t\u00fcrkisen", "cyan"),
    WHITE("\u001b[0;37m", "wei\u00df", "weiss", "wei\u00dfen", "weissen", "white"),
    BLACK_BOLD("\u001b[1;30m", new String[0]),
    RED_BOLD("\u001b[1;31m", new String[0]),
    GREEN_BOLD("\u001b[1;32m", new String[0]),
    YELLOW_BOLD("\u001b[1;33m", new String[0]),
    BLUE_BOLD("\u001b[1;34m", new String[0]),
    PURPLE_BOLD("\u001b[1;35m", new String[0]),
    CYAN_BOLD("\u001b[1;36m", new String[0]),
    WHITE_BOLD("\u001b[1;37m", new String[0]),
    BLACK_UNDERLINED("\u001b[4;30m", new String[0]),
    RED_UNDERLINED("\u001b[4;31m", new String[0]),
    GREEN_UNDERLINED("\u001b[4;32m", new String[0]),
    YELLOW_UNDERLINED("\u001b[4;33m", new String[0]),
    BLUE_UNDERLINED("\u001b[4;34m", new String[0]),
    PURPLE_UNDERLINED("\u001b[4;35m", new String[0]),
    CYAN_UNDERLINED("\u001b[4;36m", new String[0]),
    WHITE_UNDERLINED("\u001b[4;37m", new String[0]),
    BLACK_BACKGROUND("\u001b[40m", new String[0]),
    RED_BACKGROUND("\u001b[41m", new String[0]),
    GREEN_BACKGROUND("\u001b[42m", new String[0]),
    YELLOW_BACKGROUND("\u001b[43m", new String[0]),
    BLUE_BACKGROUND("\u001b[44m", new String[0]),
    PURPLE_BACKGROUND("\u001b[45m", new String[0]),
    CYAN_BACKGROUND("\u001b[46m", new String[0]),
    WHITE_BACKGROUND("\u001b[47m", new String[0]),
    BLACK_BRIGHT("\u001b[0;90m", new String[0]),
    RED_BRIGHT("\u001b[0;91m", new String[0]),
    GREEN_BRIGHT("\u001b[0;92m", new String[0]),
    YELLOW_BRIGHT("\u001b[0;93m", new String[0]),
    BLUE_BRIGHT("\u001b[0;94m", new String[0]),
    PURPLE_BRIGHT("\u001b[0;95m", new String[0]),
    CYAN_BRIGHT("\u001b[0;96m", new String[0]),
    WHITE_BRIGHT("\u001b[0;97m", new String[0]),
    BLACK_BOLD_BRIGHT("\u001b[1;90m", new String[0]),
    RED_BOLD_BRIGHT("\u001b[1;91m", new String[0]),
    GREEN_BOLD_BRIGHT("\u001b[1;92m", new String[0]),
    YELLOW_BOLD_BRIGHT("\u001b[1;93m", new String[0]),
    BLUE_BOLD_BRIGHT("\u001b[1;94m", new String[0]),
    PURPLE_BOLD_BRIGHT("\u001b[1;95m", new String[0]),
    CYAN_BOLD_BRIGHT("\u001b[1;96m", new String[0]),
    WHITE_BOLD_BRIGHT("\u001b[1;97m", new String[0]),
    BLACK_BACKGROUND_BRIGHT("\u001b[0;100m", new String[0]),
    RED_BACKGROUND_BRIGHT("\u001b[0;101m", new String[0]),
    GREEN_BACKGROUND_BRIGHT("\u001b[0;102m", new String[0]),
    YELLOW_BACKGROUND_BRIGHT("\u001b[0;103m", new String[0]),
    BLUE_BACKGROUND_BRIGHT("\u001b[0;104m", new String[0]),
    PURPLE_BACKGROUND_BRIGHT("\u001b[0;105m", new String[0]),
    CYAN_BACKGROUND_BRIGHT("\u001b[0;106m", new String[0]),
    WHITE_BACKGROUND_BRIGHT("\u001b[0;107m", new String[0]);

    private static boolean enableAnsiColors;
    private final String value;
    private final List<String> otherNames;

    private RbelAnsiColors(String value, String ... otherNames) {
        this.value = value;
        this.otherNames = Stream.of(otherNames).map(String::toLowerCase).toList();
    }

    public static void activateAnsiColors() {
        enableAnsiColors = true;
    }

    public static void deactivateAnsiColors() {
        enableAnsiColors = false;
    }

    public String toString() {
        if (enableAnsiColors) {
            return this.value;
        }
        return "";
    }

    public static Optional<RbelAnsiColors> seekColorSafe(String query) {
        return Arrays.stream(RbelAnsiColors.values()).filter(candidate -> candidate.doesColorMatchForQueryString(query)).findFirst();
    }

    public static RbelAnsiColors seekColor(String query) {
        return RbelAnsiColors.seekColorSafe(query).orElseThrow(() -> new RbelUnknownAnsiColorException("Could not match string '" + query + "' to any known color"));
    }

    public boolean doesColorMatchForQueryString(String query) {
        return this.otherNames.contains(query.toLowerCase());
    }

    static {
        enableAnsiColors = true;
    }

    private static class RbelUnknownAnsiColorException
    extends RuntimeException {
        public RbelUnknownAnsiColorException(String s) {
            super(s);
        }
    }
}

