/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.handler;

import java.util.Optional;
import java.util.function.Predicate;
import lombok.Generated;

public class TigerExceptionUtils {
    public static <E extends Throwable> Optional<E> getCauseWithType(Throwable exception, Class<E> causeClassToDetect) {
        if (causeClassToDetect.isInstance(exception)) {
            return Optional.of(exception);
        }
        if (exception == null || exception.getCause() == null) {
            return Optional.empty();
        }
        return TigerExceptionUtils.getCauseWithType(exception.getCause(), causeClassToDetect);
    }

    public static Optional<Throwable> getCauseWithMessageMatching(Throwable exception, Predicate<String> messageMatcher) {
        if (exception == null) {
            return Optional.empty();
        }
        if (messageMatcher.test(exception.getMessage())) {
            return Optional.of(exception);
        }
        if (exception.getCause() == null) {
            return Optional.empty();
        }
        return TigerExceptionUtils.getCauseWithMessageMatching(exception.getCause(), messageMatcher);
    }

    @Generated
    private TigerExceptionUtils() {
    }
}

