/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common.config;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.gematik.test.tiger.common.TokenSubstituteHelper;
import de.gematik.test.tiger.common.config.AbstractTigerConfigurationSource;
import de.gematik.test.tiger.common.config.SourceType;
import de.gematik.test.tiger.common.config.TigerConfigurationException;
import de.gematik.test.tiger.common.config.TigerConfigurationKey;
import de.gematik.test.tiger.common.config.TigerConfigurationKeys;
import de.gematik.test.tiger.common.config.TigerConfigurationLoader;
import de.gematik.test.tiger.common.config.TigerTypedConfigurationKey;
import de.gematik.test.tiger.common.data.config.AdditionalYamlProperty;
import de.gematik.test.tiger.common.jexl.TigerJexlContext;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerGlobalConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerGlobalConfiguration.class);
    public static final String TIGER_BASEKEY = "tiger";
    private static final TigerConfigurationLoader globalConfigurationLoader = new TigerConfigurationLoader();
    private static boolean requireTigerYaml = false;
    private static boolean initialized = false;

    private TigerGlobalConfiguration() {
    }

    public static synchronized void reset() {
        globalConfigurationLoader.reset();
        initialized = false;
        requireTigerYaml = false;
    }

    public static void initialize() {
        TigerGlobalConfiguration.initializeWithCliProperties(Map.of());
    }

    public static synchronized void initializeWithCliProperties(Map<String, String> additionalProperties) {
        if (initialized) {
            return;
        }
        initialized = true;
        globalConfigurationLoader.initialize();
        globalConfigurationLoader.loadEnvironmentVariables();
        globalConfigurationLoader.loadSystemProperties();
        if (additionalProperties != null) {
            additionalProperties.forEach((key, value) -> TigerGlobalConfiguration.putValue(key, value, SourceType.CLI));
        }
        TigerGlobalConfiguration.addFreePortVariables();
        TigerGlobalConfiguration.addHostnameVariable();
        TigerGlobalConfiguration.readMainYamlFile();
        TigerGlobalConfiguration.readHostYamlFile();
        TigerGlobalConfiguration.readAdditionalYamlFiles();
    }

    private static void addHostnameVariable() {
        globalConfigurationLoader.putValue("hostname", TigerGlobalConfiguration.getComputerName(), SourceType.DEFAULTS);
        globalConfigurationLoader.putValue("canonicalHostname", TigerGlobalConfiguration.getHostname().getCanonicalHostName(), SourceType.DEFAULTS);
        globalConfigurationLoader.putValue("fullHostname", TigerGlobalConfiguration.getHostname().getHostName(), SourceType.DEFAULTS);
    }

    private static void addFreePortVariables() {
        ArrayList<ServerSocket> sockets = new ArrayList<ServerSocket>();
        for (TigerTypedConfigurationKey<Integer> key : List.of(TigerConfigurationKeys.TESTENV_MGR_RESERVED_PORT, TigerConfigurationKeys.LOCALPROXY_ADMIN_RESERVED_PORT)) {
            try {
                ServerSocket serverSocket2 = new ServerSocket(0);
                key.putValue(serverSocket2.getLocalPort());
                sockets.add(serverSocket2);
            }
            catch (IOException e) {
                throw new TigerConfigurationException("Exception while trying to add tiger internal port variables", e);
            }
        }
        for (int i = 0; i < 256; ++i) {
            try {
                ServerSocket serverSocket3 = new ServerSocket(0);
                globalConfigurationLoader.putValue("free.port." + i, Integer.toString(serverSocket3.getLocalPort()), SourceType.RUNTIME_EXPORT);
                sockets.add(serverSocket3);
                continue;
            }
            catch (IOException e) {
                throw new TigerConfigurationException("Exception while trying to add free port variables", e);
            }
        }
        sockets.forEach(serverSocket -> {
            try {
                serverSocket.close();
            }
            catch (IOException e) {
                throw new TigerConfigurationException("Exception while closing temporary sockets for free port variables", e);
            }
        });
    }

    public static synchronized String readString(String key) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        return TigerGlobalConfiguration.resolvePlaceholders(globalConfigurationLoader.readString(key));
    }

    public static synchronized String readString(String key, String defaultValue) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        return TigerGlobalConfiguration.resolvePlaceholders(globalConfigurationLoader.readString(key, defaultValue));
    }

    public static synchronized Optional<String> readStringOptional(String key) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        return globalConfigurationLoader.readStringOptional(key).map(TigerGlobalConfiguration::resolvePlaceholders);
    }

    public static synchronized Optional<String> readStringWithoutResolving(String key) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        return globalConfigurationLoader.readStringOptional(key);
    }

    public static synchronized <T> Optional<T> instantiateConfigurationBean(Class<T> configurationBeanClass, String ... baseKeys) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        return globalConfigurationLoader.instantiateConfigurationBean(configurationBeanClass, baseKeys);
    }

    public static synchronized <T> Optional<T> instantiateConfigurationBeanStrict(Class<T> configurationBeanClass, String ... baseKeys) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        return globalConfigurationLoader.instantiateConfigurationBeanStrict(configurationBeanClass, baseKeys);
    }

    public static synchronized <T> T instantiateConfigurationBean(TypeReference<T> configurationBeanType, String ... baseKeys) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        return globalConfigurationLoader.instantiateConfigurationBean(configurationBeanType, baseKeys);
    }

    public static synchronized void readFromYaml(String yamlSource, String ... baseKeys) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        globalConfigurationLoader.readFromYaml(yamlSource, baseKeys);
    }

    public static synchronized void readFromYaml(String yamlSource, SourceType sourceType, String ... baseKeys) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        globalConfigurationLoader.readFromYaml(yamlSource, sourceType, baseKeys);
    }

    public static synchronized boolean readBoolean(String key) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        return globalConfigurationLoader.readBoolean(key);
    }

    public static synchronized boolean readBoolean(String key, boolean defaultValue) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        return globalConfigurationLoader.readBoolean(key, defaultValue);
    }

    public static synchronized Optional<Boolean> readBooleanOptional(String key) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        return globalConfigurationLoader.readBooleanOptional(key);
    }

    public static synchronized void readTemplates(String templatesYaml, String ... baseKeys) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        globalConfigurationLoader.readTemplates(templatesYaml, baseKeys);
    }

    private static void assertGlobalConfigurationIsInitialized() {
        if (!initialized) {
            TigerGlobalConfiguration.initialize();
            initialized = true;
        }
    }

    public static List<String> readList(String ... baseKeys) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        return globalConfigurationLoader.readList(baseKeys);
    }

    public static Map<String, String> readMap(String ... baseKeys) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        return globalConfigurationLoader.readMap(baseKeys);
    }

    public static Map<String, String> readMapWithCaseSensitiveKeys(String ... baseKeys) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        return globalConfigurationLoader.readMapWithCaseSensitiveKeys(baseKeys);
    }

    public static List<AbstractTigerConfigurationSource> listSources() {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        return globalConfigurationLoader.listSources();
    }

    public static void putValue(String key, String value) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        globalConfigurationLoader.putValue(key, value);
    }

    public static void putValue(String key, Object value) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        globalConfigurationLoader.putValue(key, value);
    }

    public static void putValue(String key, long value) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        globalConfigurationLoader.putValue(key, Long.toString(value));
    }

    public static void putValue(String key, boolean value) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        globalConfigurationLoader.putValue(key, Boolean.toString(value));
    }

    public static void putValue(String key, double value) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        globalConfigurationLoader.putValue(key, Double.toString(value));
    }

    public static void putValue(String key, int value) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        globalConfigurationLoader.putValue(key, Integer.toString(value));
    }

    public static void putValue(String key, String value, SourceType sourceType) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        globalConfigurationLoader.putValue(key, value, sourceType);
    }

    public static void putValue(String key, Object value, SourceType sourceType) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        globalConfigurationLoader.putValue(key, value.toString(), sourceType);
    }

    public static String resolvePlaceholders(String stringToSubstitute) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        return TokenSubstituteHelper.substitute(stringToSubstitute, globalConfigurationLoader);
    }

    public static String resolvePlaceholdersWithContext(String stringToSubstitute, TigerJexlContext context) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        return TokenSubstituteHelper.substitute(stringToSubstitute, globalConfigurationLoader, Optional.ofNullable(context));
    }

    public static Optional<Integer> readIntegerOptional(String key) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        return TigerGlobalConfiguration.readStringOptional(key).map(Integer::parseInt);
    }

    private static void readMainYamlFile() {
        Optional<String> tigerYamlValue = TigerConfigurationKeys.TIGER_YAML_VALUE.getValueWithoutResolving();
        if (tigerYamlValue.isPresent()) {
            log.info("Reading configuration from tiger.yaml property as string");
            globalConfigurationLoader.readFromYaml(tigerYamlValue.get(), SourceType.TEST_YAML, TIGER_BASEKEY);
            return;
        }
        Optional<File> customCfgFile = TigerConfigurationKeys.TIGER_TESTENV_CFGFILE_LOCATION.getValue().map(File::new);
        if (customCfgFile.isPresent()) {
            if (customCfgFile.get().exists()) {
                TigerGlobalConfiguration.readYamlFile(customCfgFile.get(), Optional.of(TIGER_BASEKEY), SourceType.MAIN_YAML);
                return;
            }
            throw new TigerConfigurationException("Could not find configuration-file '" + customCfgFile.get().getAbsolutePath() + "'.");
        }
        Optional<File> mainCfgFile = Stream.of(TigerConfigurationKeys.TIGER_TESTENV_CFGFILE_LOCATION.getValue().orElse(null), "tiger.yaml", "tiger.yml").filter(Objects::nonNull).map(File::new).filter(File::exists).findFirst();
        if (mainCfgFile.isPresent()) {
            TigerGlobalConfiguration.readYamlFile(mainCfgFile.get(), Optional.of(TIGER_BASEKEY), SourceType.MAIN_YAML);
            return;
        }
        if (requireTigerYaml) {
            throw new TigerConfigurationException("Could not find configuration-file 'tiger.yaml'.");
        }
    }

    private static void readHostYamlFile() {
        String computerName = TigerGlobalConfiguration.getComputerName();
        Stream.of("tiger-" + computerName + ".yaml", "tiger-" + computerName + ".yml").map(File::new).filter(File::exists).findFirst().ifPresent(hostCfgFile -> TigerGlobalConfiguration.readYamlFile(hostCfgFile, Optional.of(TIGER_BASEKEY), SourceType.HOST_YAML));
    }

    private static void readAdditionalYamlFiles() {
        List<AdditionalYamlProperty> additionalYamls = globalConfigurationLoader.instantiateConfigurationBean(new TypeReference<List<AdditionalYamlProperty>>(){}, TIGER_BASEKEY, "additionalYamls");
        for (AdditionalYamlProperty additionalYaml : additionalYamls) {
            File additionalYamlFile = TigerGlobalConfiguration.findAdditionalYamlFile(TigerGlobalConfiguration.resolvePlaceholders(additionalYaml.getFilename()));
            TigerGlobalConfiguration.readYamlFile(additionalYamlFile, Optional.ofNullable(additionalYaml.getBaseKey()), SourceType.ADDITIONAL_YAML);
        }
    }

    private static File findAdditionalYamlFile(String additionalYaml) {
        File yamlRelativeToTigerYaml;
        Optional<Path> configFileLocation = TigerConfigurationKeys.TIGER_TESTENV_CFGFILE_LOCATION.getValue().map(x$0 -> Path.of(x$0, new String[0]));
        if (configFileLocation.isPresent() && (yamlRelativeToTigerYaml = configFileLocation.get().resolveSibling(additionalYaml).toFile()).exists()) {
            return yamlRelativeToTigerYaml;
        }
        Path currentDirectory = Path.of(".", new String[0]);
        File yamlRelativeToWorkingDirectory = currentDirectory.resolveSibling(additionalYaml).toFile();
        if (yamlRelativeToWorkingDirectory.exists()) {
            return yamlRelativeToWorkingDirectory;
        }
        throw new TigerConfigurationException("The file " + additionalYaml + " relative to parent folder of tiger.yaml " + configFileLocation + " or current working directory " + currentDirectory + " is not found.");
    }

    static String getComputerName() {
        return TigerGlobalConfiguration.getHostname().getHostName().split("\\.")[0];
    }

    private static InetAddress getHostname() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            return InetAddress.getLoopbackAddress();
        }
    }

    private static void readYamlFile(File file, Optional<String> baseKey, SourceType sourceType) {
        try {
            log.info("Reading configuration from file '{}'", (Object)file.getAbsolutePath());
            if (baseKey.isPresent()) {
                TigerGlobalConfiguration.readFromYaml(FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8), sourceType, baseKey.get());
            } else {
                TigerGlobalConfiguration.readFromYaml(FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8), sourceType, new String[0]);
            }
        }
        catch (TigerConfigurationException tcex) {
            throw tcex;
        }
        catch (IOException | RuntimeException e) {
            throw new TigerConfigurationException("Error while reading configuration from file '" + file.getAbsolutePath() + "' with cause '" + e + "'", e);
        }
    }

    static void addConfigurationSource(AbstractTigerConfigurationSource configurationSource) {
        globalConfigurationLoader.addConfigurationSource(configurationSource);
    }

    static boolean removeConfigurationSource(AbstractTigerConfigurationSource configurationSource) {
        return globalConfigurationLoader.removeConfigurationSource(configurationSource);
    }

    public static ObjectMapper getObjectMapper() {
        return globalConfigurationLoader.getObjectMapper();
    }

    public static void deleteFromAllSources(TigerConfigurationKey configurationKey) {
        globalConfigurationLoader.listSources().forEach(source -> source.removeValue(configurationKey));
    }

    public static Map<String, Pair<SourceType, String>> exportConfiguration() {
        Stream<AbstractTigerConfigurationSource> sources = globalConfigurationLoader.listSources().stream().sorted(Comparator.comparing(AbstractTigerConfigurationSource::getSourceType, Comparator.comparing(SourceType::getPrecedence)).reversed());
        HashMap exportedConfiguration = new HashMap();
        ((Stream)sources.sequential()).forEach(s -> s.getValues().forEach((k, v) -> exportedConfiguration.put(k.downsampleKeyCaseSensitive(), Pair.of((Object)((Object)s.getSourceType()), (Object)v))));
        return Collections.unmodifiableMap(exportedConfiguration);
    }

    @Generated
    public static boolean isRequireTigerYaml() {
        return requireTigerYaml;
    }

    @Generated
    public static void setRequireTigerYaml(boolean requireTigerYaml) {
        TigerGlobalConfiguration.requireTigerYaml = requireTigerYaml;
    }
}

