/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common.config;

import de.gematik.test.tiger.common.config.AbstractTigerConfigurationSource;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;

public class TigerConfigurationSourcesManager {
    private List<AbstractTigerConfigurationSource> loadedSources = new CopyOnWriteArrayList<AbstractTigerConfigurationSource>();

    public void reset() {
        this.loadedSources.clear();
    }

    public Stream<AbstractTigerConfigurationSource> getSortedStream() {
        return this.loadedSources.stream().sorted();
    }

    public List<AbstractTigerConfigurationSource> getSortedListReversed() {
        return this.loadedSources.stream().sorted(Comparator.reverseOrder()).toList();
    }

    public void addNewSource(AbstractTigerConfigurationSource source) {
        this.loadedSources.add(source);
    }

    public boolean removeSource(AbstractTigerConfigurationSource source) {
        return this.loadedSources.remove(source);
    }
}

