/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common.jexl;

import de.gematik.test.tiger.common.jexl.InlineJexlToolbox;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedDeque;
import lombok.Generated;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.MapContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerJexlExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerJexlExecutor.class);
    private static final Map<Integer, JexlExpression> JEXL_EXPRESSION_CACHE = new HashMap<Integer, JexlExpression>();
    public static final Deque<Object> ELEMENT_STACK = new ConcurrentLinkedDeque<Object>();
    public static boolean ACTIVATE_JEXL_DEBUGGING = false;
    public static TigerJexlExecutor INSTANCE = new TigerJexlExecutor();
    private static final Map<String, Object> NAMESPACE_MAP = new HashMap<String, Object>();

    public boolean matchesAsJexlExpression(Object element, String jexlExpression) {
        return this.matchesAsJexlExpression(element, jexlExpression, Optional.empty());
    }

    public boolean matchesAsJexlExpression(Object element, String jexlExpression, Optional<String> key) {
        boolean result = this.evaluateJexlExpression(element, jexlExpression, key).filter(Boolean.class::isInstance).map(Boolean.class::cast).orElse(false);
        if (result && ACTIVATE_JEXL_DEBUGGING) {
            this.printDebugMessage(element, jexlExpression);
        }
        return result;
    }

    public Optional<Object> evaluateJexlExpression(String jexlExpression, Optional<String> key) {
        return this.evaluateJexlExpression(ELEMENT_STACK.peekFirst(), jexlExpression, key);
    }

    public Optional<Object> evaluateJexlExpression(Object element, String jexlExpression, Optional<String> key) {
        try {
            MapContext mapContext = new MapContext(this.buildJexlMapContext(element, key));
            NAMESPACE_MAP.forEach((arg_0, arg_1) -> ((MapContext)mapContext).set(arg_0, arg_1));
            JexlExpression expression = this.buildExpression(jexlExpression, element, mapContext);
            return Optional.ofNullable(expression.evaluate((JexlContext)mapContext));
        }
        catch (RuntimeException e) {
            if (ACTIVATE_JEXL_DEBUGGING) {
                log.info("Error during Jexl-Evaluation.", (Throwable)e);
            }
            return Optional.empty();
        }
    }

    protected void printDebugMessage(Object element, String jexlExpression) {
        log.trace("Found match: '{}' matches '{}'", element, (Object)jexlExpression);
    }

    protected Map<String, Object> buildJexlMapContext(Object element, Optional<String> key) {
        HashMap<String, Object> mapContext = new HashMap<String, Object>();
        mapContext.put("element", element);
        if (element != null) {
            mapContext.put("type", element.getClass().getSimpleName());
            mapContext.put("content", this.getContent(element));
        }
        return mapContext;
    }

    protected String getContent(Object element) {
        return element.toString();
    }

    protected JexlExpression buildExpression(String jexlExpression, Object element, MapContext mapContext) {
        int hashCode = jexlExpression.hashCode();
        if (JEXL_EXPRESSION_CACHE.containsKey(hashCode)) {
            return JEXL_EXPRESSION_CACHE.get(hashCode);
        }
        JexlEngine jexlEngine = new JexlBuilder().namespaces(NAMESPACE_MAP).strict(true).create();
        JexlExpression expression = jexlEngine.createExpression(jexlExpression);
        JEXL_EXPRESSION_CACHE.put(hashCode, expression);
        return expression;
    }

    public static void registerAdditionalNamespace(String namespace, Object value) {
        NAMESPACE_MAP.put(namespace, value);
    }

    public static void deregisterNamespace(String namespace) {
        NAMESPACE_MAP.remove(namespace);
    }

    static {
        NAMESPACE_MAP.put(null, InlineJexlToolbox.class);
    }
}

